/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.vdurmont.emoji.EmojiParser;
import java.io.Serializable;
import oms.com.base.server.common.model.BaseEntity;
import oms.com.base.server.common.utils.StringUtil;

public class User
extends BaseEntity
implements Serializable {
    @JsonSerialize(using=ToStringSerializer.class)
    private Long viewId;
    private String phone = "";
    private String nickname = "";
    private String avatar = "";
    private int gender = 1;
    private String birthday = "";
    private String token = "";
    private String remark = "";
    private Integer channelId;
    private Integer type;
    private Long tenantId;
    private String pho;

    public User() {
        this.status = 1;
        this.channelId = 0;
    }

    public Long getViewId() {
        return this.viewId;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getNickname() {
        return EmojiParser.parseToUnicode((String)this.nickname);
    }

    public void setNickname(String nickname) {
        if (nickname != null) {
            this.nickname = EmojiParser.parseToAliases((String)nickname);
        }
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public int getGender() {
        return this.gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getChannelId() {
        return this.channelId;
    }

    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getPho() {
        if (StringUtil.isNotBlank(this.phone)) {
            if (this.phone.length() > 4) {
                return this.phone.substring(this.phone.length() - 4);
            }
            return this.phone;
        }
        return "";
    }

    public String toString() {
        return "User [viewId=" + this.viewId + ", phone=" + this.phone + ", nickname=" + this.nickname + ", avatar=" + this.avatar + ", gender=" + this.gender + ", birthday=" + this.birthday + ", token=" + this.token + ", remark=" + this.remark + ", id=" + this.id + ", status=" + this.status + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + "]";
    }
}

