/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtil
implements Serializable {
    private static Calendar calendar = Calendar.getInstance();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static byte[] lock = new byte[0];
    public static final String DEFAULT_FORMAT_DATE = "yyyy-MM-dd";
    public static final String DEFAULT_FORMAT_TIME = "HH:mm:ss";
    public static final String DEFAULT_FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_FORMAT_DATE_MONTH_DAY = "MM-dd";
    public static final String DEFAULT_FORMAT_DATEStr = "yyyyMMdd";
    public static final String DEFAULT_FORMAT_TIME_HH_MM = "HH:mm";
    public static final String DEFAULT_FORMAT_DATE_MM = "yyyy-MM-dd HH:mm";
    public static final String DEFAULT_FORMAT_DATE_YY = "MM-dd";
    public static final String DEFAULT_FORMAT_DATE_YY_MM = "yyyy-MM";
    public static final String DEFAULT_FORMAT_DATE_DD = "dd";
    public static final String DEFAULT_FORMAT_DATE_MM_DD = "MM-dd HH:mm";
    public static final int EXPIRE_SECOND = 1;
    public static final int EXPIRE_MINUTE = 60;
    public static final int EXPIER_HOUR = 3600;
    public static final int EXPIRE_DAY = 86400;
    public static final int EXPIRE_WEEK = 604800;
    public static final int EXPIRE_YEAR = 31536000;
    public static final int EXPIRE_DEFAULT = 10800;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTime(Date time, String pattern) {
        if (time == null) {
            return "";
        }
        byte[] byArray = lock;
        synchronized (lock) {
            if (pattern != null && !DEFAULT_FORMAT_DATE.equals(pattern)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new SimpleDateFormat(pattern).format(time);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return dateFormat.format(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String strTime, String pattern) {
        byte[] byArray = lock;
        synchronized (lock) {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            Date date = null;
            try {
                date = formatter.parse(strTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTime(Date time) {
        if (time == null) {
            return "";
        }
        byte[] byArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dateFormat.format(time);
        }
    }

    public static Date parseTime(String dateTimeStr, String pattern) {
        if (StringUtils.isEmpty((CharSequence)dateTimeStr)) {
            return null;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            return dateFormat.parse(dateTimeStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addHour(Date startDate, int hour) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(startDate);
            calendar.add(11, hour);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addSecond(Date startDate, int second) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(startDate);
            calendar.add(13, second);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addDay(Date startDate, int day) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(startDate);
            calendar.add(6, day);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date addMonth(Date startDate, int month) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(startDate);
            calendar.add(2, month);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getStartTimeOfDay(Date day) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(day);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getEndTimeOfDay(Date day) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(day);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHour(Date date) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(date);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.get(11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMonth(Date date) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(date);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.get(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDayOfMonth(Date date) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(date);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.get(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMinuteOfDate(Date date) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(date);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.get(12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDay(Date date) {
        byte[] byArray = lock;
        synchronized (lock) {
            calendar.setTime(date);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.get(7);
        }
    }

    public static int getAge(Date birthDay) {
        if (birthDay == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            return 0;
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static Date getTimesWeekmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getTimesMonthmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getCurrentYearStartTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, cal.get(1));
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static void main(String[] args) {
        System.out.print(DateTimeUtil.getEffectiveDay("20190417"));
    }

    public static String getEffectiveDay(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT_DATEStr);
        Date sDate = null;
        try {
            sDate = sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int count = DateTimeUtil.differentDays(new Date(), sDate);
        if (count >= 0) {
            return "\u5269\u4f59" + (count + 1) + "\u5929";
        }
        return "\u5df2\u5931\u6548";
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static Map<String, Object> getDatePoor(Date endDate, Date nowDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        map.put("day", day);
        map.put("hour", hour);
        map.put("min", min);
        return map;
    }

    public static Date parseTime(long dateTimeLong, String pattern) {
        if (dateTimeLong == 0L) {
            return null;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            String d = dateFormat.format(dateTimeLong);
            return dateFormat.parse(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getTimeInterval(Date date1, Date date2) {
        long interval = Math.abs(date1.getTime() - date2.getTime());
        return (int)interval;
    }
}

