/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final int CONNECTION_TIMEOUT_MS = 3000;
    private static final String UTF8_CHARSET = "UTF-8";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String simpleGetInvoke(String url, Map<String, String> params) throws ClientProtocolException, IOException, URISyntaxException {
        return HttpClientUtils.simpleGetInvoke(url, null, params);
    }

    public static String simpleGetInvoke(String url, String cookies, Map<String, String> params) throws ClientProtocolException, IOException, URISyntaxException {
        HttpResponse response = HttpClientUtils.getInvoke(url, cookies, params);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return EntityUtils.toString((HttpEntity)entity, (String)UTF8_CHARSET);
        }
        return "";
    }

    public static HttpResponse getInvoke(String url, String cookies, Map<String, String> params) throws ClientProtocolException, IOException, URISyntaxException {
        HttpClient client = HttpClientUtils.buildHttpClient(false);
        HttpGet get = HttpClientUtils.buildHttpGet(url, params);
        if (StringUtils.isNotEmpty((CharSequence)cookies)) {
            get.setHeader("Cookie", cookies);
        }
        return client.execute((HttpUriRequest)get);
    }

    public static String simplePostInvoke(String url, Map<String, String> params) throws URISyntaxException, ClientProtocolException, IOException {
        return HttpClientUtils.simplePostInvoke(url, params, null);
    }

    public static String simplePostInvoke(String url, Map<String, String> params, String cookies) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = HttpClientUtils.postInvoke(url, params, cookies);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return EntityUtils.toString((HttpEntity)entity, (String)UTF8_CHARSET);
        }
        return "";
    }

    public static String simplePostInvokeHeaders(String url, Map<String, String> params, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = HttpClientUtils.postInvoke(url, params, headers);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return EntityUtils.toString((HttpEntity)entity, (String)UTF8_CHARSET);
        }
        return "";
    }

    public static HttpResponse postInvoke(String url, Map<String, String> params, String cookie) throws URISyntaxException, ClientProtocolException, IOException {
        HttpClient client = HttpClientUtils.buildHttpClient(false);
        HttpPost postMethod = HttpClientUtils.buildHttpPost(url, params);
        if (StringUtils.isNotEmpty((CharSequence)cookie)) {
            postMethod.setHeader("Cookie", cookie);
        }
        return client.execute((HttpUriRequest)postMethod);
    }

    public static HttpResponse postInvoke(String url, Map<String, String> params, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpClient client = HttpClientUtils.buildHttpClient(false);
        HttpPost postMethod = HttpClientUtils.buildHttpPost(url, params);
        postMethod.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString(params), ContentType.APPLICATION_JSON));
        ArrayList<BasicHeader> basicHeaders = new ArrayList<BasicHeader>();
        if (!headers.isEmpty()) {
            Set<String> keys = headers.keySet();
            for (String key : keys) {
                BasicHeader basicHeader = new BasicHeader(key, headers.get(key));
                basicHeaders.add(basicHeader);
            }
            BasicHeader[] headers2 = new BasicHeader[basicHeaders.size()];
            basicHeaders.toArray(headers2);
            postMethod.setHeaders((Header[])headers2);
        }
        return client.execute((HttpUriRequest)postMethod);
    }

    public static String simplePostJSONInvoke(String url, JSONObject params) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost postMethod;
        HttpClient client = HttpClientUtils.buildHttpClient(false);
        HttpResponse response = client.execute((HttpUriRequest)(postMethod = HttpClientUtils.buildJSONHttpPost(url, params)));
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return EntityUtils.toString((HttpEntity)entity, (String)UTF8_CHARSET);
        }
        return "";
    }

    public static String simplePostXMLInvoke(String url, Map<String, String> params) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost postMethod;
        HttpClient client = HttpClientUtils.buildHttpClient(false);
        HttpResponse response = client.execute((HttpUriRequest)(postMethod = HttpClientUtils.buildXMLHttpPost(url, params)));
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return EntityUtils.toString((HttpEntity)entity, (String)UTF8_CHARSET);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String simpleSSlKeyPostXMLInvoke(String url, Map<String, String> params, String keyPath, String keyPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, KeyManagementException, UnrecoverableKeyException, URISyntaxException {
        log.info("===========post\u8bf7\u6c42\u5165\u53c2\uff1aurl=" + url + ",params=" + params + ",keyPath=" + keyPath + ",keyPassword=" + keyPassword);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream instream = new FileInputStream(new File(keyPath));){
            keyStore.load(instream, keyPassword.toCharArray());
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, keyPassword.toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        HttpPost httppost = HttpClientUtils.buildXMLHttpPost(url, params);
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        log.info("===========\u4f59\u989d\u63d0\u73b0\u8bf7\u6c42\u5fae\u4fe1\u7ed3\u679c\uff0cresult=" + JSON.toJSONString((Object)response));
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return EntityUtils.toString((HttpEntity)entity, (String)UTF8_CHARSET);
        }
        return "";
    }

    public static HttpClient buildHttpClient(boolean isMultiThread) {
        CloseableHttpClient client = null;
        client = isMultiThread ? HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build() : HttpClientBuilder.create().build();
        return client;
    }

    public static HttpPost buildHttpPost(String url, Map<String, String> params) throws UnsupportedEncodingException, URISyntaxException {
        HttpPost post = new HttpPost(url);
        post.setConfig(HttpClientUtils.generateRequestConfig());
        post.setHeader("Content-Encoding", UTF8_CHARSET);
        UrlEncodedFormEntity he = null;
        if (params != null) {
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            for (String key : params.keySet()) {
                formparams.add(new BasicNameValuePair(key, params.get(key)));
            }
            he = new UrlEncodedFormEntity(formparams, UTF_8);
            post.setEntity((HttpEntity)he);
        }
        return post;
    }

    public static HttpPost buildJSONHttpPost(String url, JSONObject params) throws UnsupportedEncodingException, URISyntaxException {
        HttpPost post = new HttpPost(url);
        post.setConfig(HttpClientUtils.generateRequestConfig());
        post.setHeader("Content-Encoding", UTF8_CHARSET);
        if (params != null) {
            StringEntity entry = new StringEntity(params.toString(), UTF8_CHARSET);
            entry.setContentEncoding(UTF8_CHARSET);
            entry.setContentType("application/json");
            post.setEntity((HttpEntity)entry);
        }
        return post;
    }

    public static HttpPost buildXMLHttpPost(String url, Map<String, String> params) throws UnsupportedEncodingException, URISyntaxException {
        HttpPost post = new HttpPost(url);
        post.setConfig(HttpClientUtils.generateRequestConfig());
        post.setHeader("Content-Encoding", UTF8_CHARSET);
        if (params != null) {
            StringEntity entry = new StringEntity(HttpClientUtils.mapToXml(params), UTF8_CHARSET);
            entry.setContentEncoding(UTF8_CHARSET);
            post.setEntity((HttpEntity)entry);
        }
        return post;
    }

    public static String mapToXml(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append("<" + entry.getKey() + ">");
            sb.append(entry.getValue());
            sb.append("</" + entry.getKey() + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public static HttpGet buildHttpGet(String url, Map<String, String> params) throws URISyntaxException {
        HttpGet get = new HttpGet(HttpClientUtils.buildGetUrl(url, params));
        get.setConfig(HttpClientUtils.generateRequestConfig());
        get.setHeader("Content-Encoding", UTF8_CHARSET);
        return get;
    }

    private static RequestConfig generateRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectTimeout(3000).setSocketTimeout(3000).build();
        return requestConfig;
    }

    public static String buildGetUrl(String url, Map<String, String> params) {
        StringBuffer uriStr = new StringBuffer(url);
        if (params != null) {
            ArrayList<BasicNameValuePair> ps = new ArrayList<BasicNameValuePair>();
            for (String key : params.keySet()) {
                ps.add(new BasicNameValuePair(key, params.get(key)));
            }
            uriStr.append("?");
            uriStr.append(URLEncodedUtils.format(ps, (Charset)UTF_8));
        }
        return uriStr.toString();
    }

    private HttpClientUtils() {
    }

    public static String getHostIP() {
        Enumeration<NetworkInterface> n = null;
        try {
            n = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error("NetworkInterface.getNetworkInterfaces() error:" + e);
        }
        while (n.hasMoreElements()) {
            NetworkInterface e = n.nextElement();
            Enumeration<InetAddress> a = e.getInetAddresses();
            while (a.hasMoreElements()) {
                InetAddress addr = a.nextElement();
                if (addr.isLoopbackAddress() || addr.isLoopbackAddress() || addr.getHostAddress().indexOf(":") != -1) continue;
                return addr.getHostAddress();
            }
        }
        return null;
    }

    public static String getRealIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && (ipAddress = request.getRemoteAddr()) != null && (ipAddress.equals("127.0.0.1") || ipAddress.equals("0:0:0:0:0:0:0:1"))) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getXmlFromRequest(HttpServletRequest request) throws IOException {
        String reqXml = "";
        reqXml = request.getQueryString();
        if ("post".equalsIgnoreCase(request.getMethod())) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            reqXml = sb.toString();
        }
        return reqXml;
    }

    public static String getRemoteIpByRequest(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.length() > 15) {
            log.info("ip.length() > 15 " + ip);
            if (ip.indexOf(",") > 0) {
                ip = ip.substring(0, ip.indexOf(","));
            }
            log.info("ip \uff1a " + ip);
        }
        return ip;
    }

    public static final String getLocalIpByRequest(HttpServletRequest request) throws Exception {
        if (request == null) {
            throw new Exception("getIpAddr method HttpServletRequest Object is null");
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

