/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtil
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(MapUtil.class);

    public static <T> boolean isEmpty(Map<T, T> map) {
        return map == null || map.size() == 0;
    }

    public static <T> T mapToBean(Map<String, ? extends Object> map, T bean) {
        try {
            BeanUtils.populate(bean, map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return bean;
    }

    public static <T> Map<String, String> beanToMap(T bean) {
        try {
            return BeanUtils.describe(bean);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

