/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);

    public static void senderDelayed(String exchange, String routingKey, RabbitTemplate rabbitTemplate, String msg, int ms) {
        rabbitTemplate.convertAndSend(exchange, routingKey, (Object)msg, message -> {
            message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
            message.getMessageProperties().setDelay(Integer.valueOf(ms));
            log.info("send message to rabbitmq info: " + msg);
            return message;
        });
    }

    public static void senderGoEasyMsg(String exchange, String routingKey, RabbitTemplate rabbitTemplate, String msg) {
        log.info("\u53d1\u9001\u6d88\u606f---->exchange: {}" + exchange + "routingKey: {}" + routingKey + "msg: {}" + msg);
        rabbitTemplate.convertAndSend(exchange, routingKey, (Object)msg);
    }
}

