/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

@Component
public class RedisClientUtil
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RedisClientUtil.class);
    @Autowired
    private JedisPool jedisPoolTeplate;
    @Autowired
    private RedisProperties prop;
    private static String password;
    private static JedisPool jedisPool;
    public static final int EXPIRE_SECOND = 1;
    public static final int EXPIRE_MINUTE = 60;
    public static final int EXPIER_HOUR = 3600;
    public static final int EXPIRE_12_HOUR = 43200;
    public static final int EXPIRE_DAY = 86400;
    public static final int EXPIRE_WEEK = 604800;
    public static final int EXPIRE_DEFAULT = 10800;
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    private static final Long RELEASE_SUCCESS;

    @PostConstruct
    public void init() {
        password = this.prop.getPassword();
        jedisPool = this.jedisPoolTeplate;
    }

    private static Jedis getJedis() {
        Jedis jedis = jedisPool.getResource();
        jedis.auth(password);
        return jedis;
    }

    public static void close(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public static String get(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static void set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            jedis.set(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static void set(String key, String value, long seconds) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            jedis.set(key, value, SET_IF_NOT_EXIST, "EX", seconds);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static Long incr(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            Long l = jedis.incr(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static Long hsetnx(String key, String field, String value) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            Long l = jedis.hsetnx(key, field, value);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static Long hincrBy(String key, String field, long value) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            Long l = jedis.hincrBy(key, field, value);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static void hset(String key, String field, String value) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            jedis.hset(key, field, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hget(String key, String field) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            String string = jedis.hget(key, field);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RedisClientUtil.close(jedis);
        }
        return null;
    }

    public static Map<String, String> hgetAll(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            Map map = jedis.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static String blpop(int timeout, String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            List list = jedis.blpop(timeout, key);
            String string = (String)list.get(1);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static String blpop(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            List list = jedis.blpop(0, key);
            String string = (String)list.get(1);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static void lpush(String key, String ... value) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            jedis.lpush(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
    }

    public static String brpop(int timeout, String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            List list = jedis.brpop(timeout, key);
            String string = (String)list.get(1);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static String brpop(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            List list = jedis.brpop(0, key);
            String string = (String)list.get(1);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static void rpush(String key, String ... value) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            jedis.rpush(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
    }

    public static long ttl(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            long l = jedis.ttl(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpire(String key, int expireTime) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            jedis.expire(key, expireTime);
        }
        catch (Exception e) {
            log.error("redis error:", (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static Long del(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            Long l = jedis.del(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static void hmset(String key, Map<String, String> map) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            jedis.hmset(key, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static Map<String, String> hmgetAll(String key) {
        Jedis jedis = null;
        Map map = null;
        try {
            jedis = RedisClientUtil.getJedis();
            map = jedis.hgetAll(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
        return map;
    }

    public static Boolean exists(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            Boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static Long hdel(String key, String ... fields) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            Long l = jedis.hdel(key, fields);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static boolean tryGetDistributedLock(String lockKey, String requestId, int expireTime) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            String result = jedis.set(lockKey, requestId, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, expireTime * 1000);
            if (LOCK_SUCCESS.equals(result)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public static boolean releaseDistributedLock(String lockKey, String requestId) {
        Jedis jedis = null;
        try {
            jedis = RedisClientUtil.getJedis();
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Collections.singletonList(requestId));
            if (RELEASE_SUCCESS.equals(result)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JedisException(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisClientUtil.close(jedis);
        }
    }

    public JedisPool getJedisPoolTeplate() {
        return this.jedisPoolTeplate;
    }

    public RedisProperties getProp() {
        return this.prop;
    }

    public void setJedisPoolTeplate(JedisPool jedisPoolTeplate) {
        this.jedisPoolTeplate = jedisPoolTeplate;
    }

    public void setProp(RedisProperties prop) {
        this.prop = prop;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisClientUtil)) {
            return false;
        }
        RedisClientUtil other = (RedisClientUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JedisPool this$jedisPoolTeplate = this.getJedisPoolTeplate();
        JedisPool other$jedisPoolTeplate = other.getJedisPoolTeplate();
        if (this$jedisPoolTeplate == null ? other$jedisPoolTeplate != null : !this$jedisPoolTeplate.equals(other$jedisPoolTeplate)) {
            return false;
        }
        RedisProperties this$prop = this.getProp();
        RedisProperties other$prop = other.getProp();
        return !(this$prop == null ? other$prop != null : !this$prop.equals(other$prop));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisClientUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JedisPool $jedisPoolTeplate = this.getJedisPoolTeplate();
        result = result * 59 + ($jedisPoolTeplate == null ? 43 : $jedisPoolTeplate.hashCode());
        RedisProperties $prop = this.getProp();
        result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
        return result;
    }

    public String toString() {
        return "RedisClientUtil(jedisPoolTeplate=" + this.getJedisPoolTeplate() + ", prop=" + this.getProp() + ")";
    }

    static {
        RELEASE_SUCCESS = 1L;
    }
}

