/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import oms.com.base.server.common.utils.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TimeDisplayUtil {
    private static final Logger log = LoggerFactory.getLogger(TimeDisplayUtil.class);

    public static String timeDisplay(Long time) {
        String result = "";
        try {
            long currentTime = System.currentTimeMillis();
            long timeDifference = currentTime - time;
            if (timeDifference < 60000L) {
                result = "\u521a\u521a";
            } else if (timeDifference < 3600000L) {
                result = timeDifference / 60000L + "\u5206\u949f\u524d";
            } else if (timeDifference < 86400000L) {
                long l = timeDifference % 3600000L / 60000L;
                result = timeDifference / 3600000L + "\u5c0f\u65f6" + (l == 0L ? "" : l + "\u5206\u949f\u524d");
            } else if (timeDifference <= 259200000L) {
                result = timeDifference / 86400000L + "\u5929\u524d";
            } else {
                SimpleDateFormat MMddHHmm = new SimpleDateFormat("MM-dd HH:mm");
                result = MMddHHmm.format(time);
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public static String timeFormat(String timeDate) {
        String result = "";
        try {
            Date parseTime = DateTimeUtil.parseTime(timeDate, "yyyy-MM-dd HH:mm:ss");
            Date now = new Date();
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sf2 = new SimpleDateFormat("yyyy-MM");
            SimpleDateFormat sf3 = new SimpleDateFormat("dd");
            String nowDay = sf.format(now);
            String day = sf.format(parseTime);
            String nowyymm = sf2.format(now);
            String yymm = sf2.format(parseTime);
            String formatTime = DateTimeUtil.formatTime(parseTime, "HH:mm");
            if (StrUtil.equals((CharSequence)day, (CharSequence)nowDay)) {
                result = "\u4eca\u5929 " + formatTime;
            } else if (StrUtil.equals((CharSequence)nowyymm, (CharSequence)yymm)) {
                String format = sf3.format(now);
                String format1 = sf3.format(parseTime);
                if (Integer.parseInt(format1) - Integer.parseInt(format) == 1) {
                    result = "\u660e\u5929 " + formatTime;
                } else {
                    SimpleDateFormat MMddHHmm = new SimpleDateFormat("MM-dd HH:mm");
                    result = MMddHHmm.format(parseTime);
                }
            } else {
                SimpleDateFormat MMddHHmm = new SimpleDateFormat("MM-dd HH:mm");
                result = MMddHHmm.format(parseTime);
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public static String timeRemaining(Long time) {
        String result = "";
        try {
            long currentTime = System.currentTimeMillis();
            long timeDifference = currentTime - time;
            if (timeDifference < 0L) {
                result = "\u5269\u4f59";
                timeDifference = -timeDifference;
            } else {
                result = "\u8d85\u65f6";
            }
            long l1 = timeDifference % 60000L;
            if (timeDifference < 3600000L) {
                long l = timeDifference / 60000L;
                result = l == 0L ? "\u5373\u5c06\u8d85\u65f6" : (currentTime - time < 0L ? result + (l1 == 0L ? l + "\u5206\u949f" : l + 1L + "\u5206\u949f") : result + l + "\u5206\u949f");
            } else if (timeDifference < 86400000L) {
                long l = timeDifference % 3600000L / 60000L;
                result = result + timeDifference / 3600000L + "\u5c0f\u65f6" + (l1 == 0L ? l + "\u5206\u949f" : l + 1L + "\u5206\u949f");
            } else {
                result = result + timeDifference / 86400000L + "\u5929";
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) {
        String time = "2023-07-25 19:34:00";
        long time1 = DateUtil.parse((CharSequence)time, (String)"yyyy-MM-dd HH:mm:ss").getTime();
        System.out.println(TimeDisplayUtil.timeRemaining(time1));
    }
}

