/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TimeUtil
implements Serializable {
    public static LinkedHashMap<String, Object> getDatesBetweenTwoDate(Date startDate, Date endDate, Object value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        LinkedHashMap<String, Object> dateMap = new LinkedHashMap<String, Object>();
        dateMap.put(sdf.format(startDate), value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (true) {
            calendar.add(5, 1);
            if (!endDate.after(calendar.getTime())) break;
            dateMap.put(sdf.format(calendar.getTime()), value);
        }
        dateMap.put(sdf.format(endDate), value);
        return dateMap;
    }

    public static List<Map<String, Object>> getDateBetweenTwoDate(String key, Date startDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Map<String, Object>> dateList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> startMap = new HashMap<String, String>();
        startMap.put(key, sdf.format(startDate));
        dateList.add(startMap);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (true) {
            calendar.add(5, 1);
            if (!endDate.after(calendar.getTime())) break;
            HashMap<String, String> dateMap = new HashMap<String, String>();
            dateMap.put(key, sdf.format(calendar.getTime()));
            dateList.add(dateMap);
        }
        HashMap<String, String> endMap = new HashMap<String, String>();
        endMap.put(key, sdf.format(endDate));
        dateList.add(endMap);
        return dateList;
    }

    public static LocalDate DateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static Date LocalDateToDate(LocalDate localDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static LocalDate stringToLocalDate(String str) {
        LocalDate localDate = LocalDate.parse(str, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return localDate;
    }

    public static Date stringToDate(String string) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = sdf.parse(string);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String str = sdf.format(date);
        return str;
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String str = sdf.format(date);
        return str;
    }

    public static Date formartStringToDate(String format, String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getTwoDay(String dateString, String TwoDay) {
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        long day = 0L;
        try {
            Date date = myFormatter.parse(TwoDay);
            Date mydate = myFormatter.parse(dateString);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return "";
        }
        return day + "";
    }
}

