/*
 * Decompiled with CFR 0.152.
 */
package oms.com.base.server.common.utils.annotate;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import oms.com.base.server.common.utils.annotate.DefaultFieldVal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class MaskFieldSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    private String[] tags;
    private String defaultVal;

    public MaskFieldSerializer() {
    }

    public MaskFieldSerializer(String[] tags, String defaultVal) {
        this.tags = tags;
        this.defaultVal = defaultVal;
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value instanceof List) {
            if (value == null) {
                ArrayList tmp = new ArrayList();
                jgen.writeObject(tmp);
            } else {
                jgen.writeObject(value);
            }
            return;
        }
        List allTagList = Lists.newArrayList((Object[])this.tags).stream().map(e -> e).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(allTagList)) {
            if (this.defaultVal == null) {
                jgen.writeObject(value);
            } else {
                jgen.writeObject((Object)this.defaultVal);
            }
            return;
        }
        if (this.defaultVal == null) {
            jgen.writeObject(value);
            return;
        }
        String tmpStr = null;
        tmpStr = value == null ? "null" : String.valueOf(value);
        if (allTagList.contains(tmpStr)) {
            if (StringUtils.isNotBlank((CharSequence)this.defaultVal)) {
                jgen.writeObject((Object)this.defaultVal);
            } else {
                jgen.writeObject(value);
            }
        } else {
            String currentName = jgen.getOutputContext().getCurrentName();
            System.out.println(currentName);
            jgen.writeObject(value);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            DefaultFieldVal defaultFieldVal = (DefaultFieldVal)beanProperty.getAnnotation(DefaultFieldVal.class);
            if (defaultFieldVal == null) {
                defaultFieldVal = (DefaultFieldVal)beanProperty.getContextAnnotation(DefaultFieldVal.class);
            }
            if (defaultFieldVal != null) {
                return new MaskFieldSerializer(defaultFieldVal.tags(), defaultFieldVal.defaultVal());
            }
        }
        return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
    }
}

