/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.build;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.Profile;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.ProfilesConversionUtils;
import org.apache.maven.profiles.ProfilesRoot;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.build.ProfileAdvisor;
import org.apache.maven.profiles.injection.ProfileInjector;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ProfileAdvisor.class)
public class DefaultProfileAdvisor
implements ProfileAdvisor,
LogEnabled,
Contextualizable {
    public static final String ROLE_HINT = "default";
    @Requirement
    private MavenTools mavenTools;
    @Requirement
    private MavenProfilesBuilder profilesBuilder;
    @Requirement
    private ProfileInjector profileInjector;
    @Requirement
    private PlexusContainer container;
    private Logger logger;

    public List applyActivatedProfiles(Model model, File pomFile, boolean useProfilesXml, ProfileActivationContext activationContext) throws ProjectBuildingException {
        ProfileManager profileManager = this.buildProfileManager(model, pomFile, useProfilesXml, activationContext);
        return this.applyActivatedProfiles(model, pomFile, profileManager);
    }

    public List applyActivatedExternalProfiles(Model model, File projectDir, ProfileManager externalProfileManager) throws ProjectBuildingException {
        if (externalProfileManager == null) {
            return Collections.EMPTY_LIST;
        }
        return this.applyActivatedProfiles(model, projectDir, externalProfileManager);
    }

    private List applyActivatedProfiles(Model model, File pomFile, ProfileManager profileManager) throws ProjectBuildingException {
        List activeProfiles;
        if (profileManager != null) {
            try {
                activeProfiles = profileManager.getActiveProfiles(model);
            }
            catch (ProfileActivationException e) {
                String artifactId;
                String groupId = model.getGroupId();
                if (groupId == null) {
                    groupId = "unknown";
                }
                if ((artifactId = model.getArtifactId()) == null) {
                    artifactId = "unknown";
                }
                String projectId = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
                throw new ProjectBuildingException(projectId, e.getMessage(), pomFile, e);
            }
            for (org.apache.maven.model.Profile profile : activeProfiles) {
                this.profileInjector.inject(profile, model);
            }
        } else {
            activeProfiles = Collections.EMPTY_LIST;
        }
        return activeProfiles;
    }

    private ProfileManager buildProfileManager(Model model, File pomFile, boolean useProfilesXml, ProfileActivationContext profileActivationContext) throws ProjectBuildingException {
        DefaultProfileManager profileManager = new DefaultProfileManager(this.container, profileActivationContext);
        profileManager.addProfiles(model.getProfiles());
        if (useProfilesXml && pomFile != null) {
            this.loadExternalProjectProfiles(profileManager, model, pomFile);
        }
        return profileManager;
    }

    public LinkedHashSet getArtifactRepositoriesFromActiveProfiles(Model model, File pomFile, ProfileManager profileManager) throws ProjectBuildingException {
        List activeExternalProfiles;
        if (profileManager == null) {
            return new LinkedHashSet();
        }
        try {
            activeExternalProfiles = profileManager.getActiveProfiles(model);
        }
        catch (ProfileActivationException e) {
            throw new ProjectBuildingException(model.getId(), "Failed to compute active profiles for repository aggregation.", pomFile, e);
        }
        LinkedHashSet<ArtifactRepository> remoteRepositories = new LinkedHashSet<ArtifactRepository>();
        for (org.apache.maven.model.Profile externalProfile : activeExternalProfiles) {
            if (externalProfile.getRepositories() == null) continue;
            for (Repository mavenRepo : externalProfile.getRepositories()) {
                ArtifactRepository artifactRepo;
                try {
                    artifactRepo = this.mavenTools.buildArtifactRepository(mavenRepo);
                }
                catch (InvalidRepositoryException e) {
                    throw new ProjectBuildingException(model.getId(), e.getMessage(), e);
                }
                remoteRepositories.add(artifactRepo);
            }
        }
        return remoteRepositories;
    }

    public LinkedHashSet getArtifactRepositoriesFromActiveProfiles(Model model, File pomFile, boolean useProfilesXml, ProfileActivationContext activationContext) throws ProjectBuildingException {
        ProfileManager profileManager = this.buildProfileManager(model, pomFile, useProfilesXml, activationContext);
        return this.getArtifactRepositoriesFromActiveProfiles(model, pomFile, profileManager);
    }

    private void loadExternalProjectProfiles(ProfileManager profileManager, Model model, File pomFile) throws ProjectBuildingException {
        if (pomFile != null) {
            File projectDir = pomFile.getParentFile();
            try {
                ProfilesRoot root = this.profilesBuilder.buildProfiles(projectDir);
                if (root != null) {
                    List active = root.getActiveProfiles();
                    if (active != null && !active.isEmpty()) {
                        ProfileActivationContext ctx = profileManager.getProfileActivationContext();
                        ctx.setExplicitlyActiveProfileIds(root.getActiveProfiles());
                    }
                    for (Profile rawProfile : root.getProfiles()) {
                        org.apache.maven.model.Profile converted = ProfilesConversionUtils.convertFromProfileXmlProfile(rawProfile);
                        profileManager.addProfile(converted);
                    }
                }
            }
            catch (IOException e) {
                throw new ProjectBuildingException(model.getId(), "Cannot read profiles.xml resource from directory: " + projectDir, pomFile, e);
            }
            catch (XmlPullParserException e) {
                throw new ProjectBuildingException(model.getId(), "Cannot parse profiles.xml resource from directory: " + projectDir, pomFile, e);
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

