/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ScannerUtil {
    private static final String FS = System.getProperty("file.separator");
    private static final String JAVA_SOURCE_FILE_EXTENSION = ".java";
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private static final boolean IS_NON_UNIX_FS = !FS.equals("/");

    private ScannerUtil() {
    }

    @Nonnull
    public static String convertToJavaClassName(@Nonnull String test) {
        return StringUtils.removeEnd((String)test, (String)JAVA_CLASS_FILE_EXTENSION).replace(FS, ".");
    }

    @Nonnull
    public static String convertJarFileResourceToJavaClassName(@Nonnull String test) {
        return StringUtils.removeEnd((String)test, (String)JAVA_CLASS_FILE_EXTENSION).replace("/", ".");
    }

    @Nonnull
    public static String convertSlashToSystemFileSeparator(@Nonnull String path) {
        return IS_NON_UNIX_FS ? path.replace("/", FS) : path;
    }

    @Nonnull
    public static String stripBaseDir(String basedir, String test) {
        return StringUtils.removeStart((String)test, (String)basedir);
    }

    @Nonnull
    public static String[] processIncludesExcludes(@Nonnull List<String> list) {
        ArrayList newList = new ArrayList();
        Iterator<String> i$ = list.iterator();
        while (i$.hasNext()) {
            String aList;
            String include = aList = i$.next();
            String[] includes = include.split(",");
            Collections.addAll(newList, includes);
        }
        String[] incs = new String[newList.size()];
        for (int i = 0; i < incs.length; ++i) {
            String inc = (String)newList.get(i);
            if (inc.endsWith(JAVA_SOURCE_FILE_EXTENSION)) {
                inc = StringUtils.removeEnd((String)inc, (String)JAVA_SOURCE_FILE_EXTENSION) + JAVA_CLASS_FILE_EXTENSION;
            }
            incs[i] = ScannerUtil.convertSlashToSystemFileSeparator(inc);
        }
        return incs;
    }
}

