/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.topic.TopicValidator;

public class NamespaceUtil {
    public static final char NAMESPACE_SEPARATOR = '%';
    public static final String STRING_BLANK = "";
    public static final int RETRY_PREFIX_LENGTH = "%RETRY%".length();
    public static final int DLQ_PREFIX_LENGTH = "%DLQ%".length();

    public static String withoutNamespace(String resourceWithNamespace) {
        String resourceWithoutRetryAndDLQ;
        int index;
        if (StringUtils.isEmpty((CharSequence)resourceWithNamespace) || NamespaceUtil.isSystemResource(resourceWithNamespace)) {
            return resourceWithNamespace;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (NamespaceUtil.isRetryTopic(resourceWithNamespace)) {
            stringBuilder.append("%RETRY%");
        }
        if (NamespaceUtil.isDLQTopic(resourceWithNamespace)) {
            stringBuilder.append("%DLQ%");
        }
        if ((index = (resourceWithoutRetryAndDLQ = NamespaceUtil.withOutRetryAndDLQ(resourceWithNamespace)).indexOf(37)) > 0) {
            String resourceWithoutNamespace = resourceWithoutRetryAndDLQ.substring(index + 1);
            return stringBuilder.append(resourceWithoutNamespace).toString();
        }
        return resourceWithNamespace;
    }

    public static String withoutNamespace(String resourceWithNamespace, String namespace) {
        if (StringUtils.isEmpty((CharSequence)resourceWithNamespace) || StringUtils.isEmpty((CharSequence)namespace)) {
            return resourceWithNamespace;
        }
        String resourceWithoutRetryAndDLQ = NamespaceUtil.withOutRetryAndDLQ(resourceWithNamespace);
        if (resourceWithoutRetryAndDLQ.startsWith(namespace + '%')) {
            return NamespaceUtil.withoutNamespace(resourceWithNamespace);
        }
        return resourceWithNamespace;
    }

    public static String wrapNamespace(String namespace, String resourceWithOutNamespace) {
        if (StringUtils.isEmpty((CharSequence)namespace) || StringUtils.isEmpty((CharSequence)resourceWithOutNamespace)) {
            return resourceWithOutNamespace;
        }
        if (NamespaceUtil.isSystemResource(resourceWithOutNamespace) || NamespaceUtil.isAlreadyWithNamespace(resourceWithOutNamespace, namespace)) {
            return resourceWithOutNamespace;
        }
        String resourceWithoutRetryAndDLQ = NamespaceUtil.withOutRetryAndDLQ(resourceWithOutNamespace);
        StringBuilder stringBuilder = new StringBuilder();
        if (NamespaceUtil.isRetryTopic(resourceWithOutNamespace)) {
            stringBuilder.append("%RETRY%");
        }
        if (NamespaceUtil.isDLQTopic(resourceWithOutNamespace)) {
            stringBuilder.append("%DLQ%");
        }
        return stringBuilder.append(namespace).append('%').append(resourceWithoutRetryAndDLQ).toString();
    }

    public static boolean isAlreadyWithNamespace(String resource, String namespace) {
        if (StringUtils.isEmpty((CharSequence)namespace) || StringUtils.isEmpty((CharSequence)resource) || NamespaceUtil.isSystemResource(resource)) {
            return false;
        }
        String resourceWithoutRetryAndDLQ = NamespaceUtil.withOutRetryAndDLQ(resource);
        return resourceWithoutRetryAndDLQ.startsWith(namespace + '%');
    }

    public static String wrapNamespaceAndRetry(String namespace, String consumerGroup) {
        if (StringUtils.isEmpty((CharSequence)consumerGroup)) {
            return null;
        }
        return "%RETRY%" + NamespaceUtil.wrapNamespace(namespace, consumerGroup);
    }

    public static String getNamespaceFromResource(String resource) {
        if (StringUtils.isEmpty((CharSequence)resource) || NamespaceUtil.isSystemResource(resource)) {
            return STRING_BLANK;
        }
        String resourceWithoutRetryAndDLQ = NamespaceUtil.withOutRetryAndDLQ(resource);
        int index = resourceWithoutRetryAndDLQ.indexOf(37);
        return index > 0 ? resourceWithoutRetryAndDLQ.substring(0, index) : STRING_BLANK;
    }

    private static String withOutRetryAndDLQ(String originalResource) {
        if (StringUtils.isEmpty((CharSequence)originalResource)) {
            return STRING_BLANK;
        }
        if (NamespaceUtil.isRetryTopic(originalResource)) {
            return originalResource.substring(RETRY_PREFIX_LENGTH);
        }
        if (NamespaceUtil.isDLQTopic(originalResource)) {
            return originalResource.substring(DLQ_PREFIX_LENGTH);
        }
        return originalResource;
    }

    private static boolean isSystemResource(String resource) {
        if (StringUtils.isEmpty((CharSequence)resource)) {
            return false;
        }
        return TopicValidator.isSystemTopic((String)resource) || MixAll.isSysConsumerGroup((String)resource);
    }

    public static boolean isRetryTopic(String resource) {
        return StringUtils.isNotBlank((CharSequence)resource) && resource.startsWith("%RETRY%");
    }

    public static boolean isDLQTopic(String resource) {
        return StringUtils.isNotBlank((CharSequence)resource) && resource.startsWith("%DLQ%");
    }
}

