/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.crypto;

import com.google.common.base.Splitter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.bitcoinj.crypto.ChildNumber;

public class HDPath
extends AbstractList<ChildNumber> {
    private static final char PREFIX_PRIVATE = 'm';
    private static final char PREFIX_PUBLIC = 'M';
    private static final char SEPARATOR = '/';
    private static final Splitter SEPARATOR_SPLITTER = Splitter.on((char)'/').trimResults();
    protected final boolean hasPrivateKey;
    protected final List<ChildNumber> unmodifiableList;

    public HDPath(boolean hasPrivateKey, List<ChildNumber> list) {
        this.hasPrivateKey = hasPrivateKey;
        this.unmodifiableList = Collections.unmodifiableList(list);
    }

    public HDPath(List<ChildNumber> list) {
        this(false, list);
    }

    private static HDPath of(boolean hasPrivateKey, List<ChildNumber> list) {
        return new HDPath(hasPrivateKey, list);
    }

    public static HDPath M(List<ChildNumber> list) {
        return HDPath.of(false, list);
    }

    public static HDPath M() {
        return HDPath.M(Collections.emptyList());
    }

    public static HDPath M(ChildNumber childNumber) {
        return HDPath.M(Collections.singletonList(childNumber));
    }

    public static HDPath M(ChildNumber ... children) {
        return HDPath.M(Arrays.asList(children));
    }

    public static HDPath m(List<ChildNumber> list) {
        return HDPath.of(true, list);
    }

    public static HDPath m() {
        return HDPath.m(Collections.emptyList());
    }

    public static HDPath m(ChildNumber childNumber) {
        return HDPath.m(Collections.singletonList(childNumber));
    }

    public static HDPath m(ChildNumber ... children) {
        return HDPath.m(Arrays.asList(children));
    }

    public static HDPath parsePath(@Nonnull String path) {
        LinkedList parsedNodes = new LinkedList(SEPARATOR_SPLITTER.splitToList((CharSequence)path));
        boolean hasPrivateKey = false;
        if (!parsedNodes.isEmpty()) {
            String firstNode = (String)parsedNodes.get(0);
            if (firstNode.equals(Character.toString('m'))) {
                hasPrivateKey = true;
            }
            if (hasPrivateKey || firstNode.equals(Character.toString('M'))) {
                parsedNodes.remove(0);
            }
        }
        ArrayList<ChildNumber> nodes = new ArrayList<ChildNumber>(parsedNodes.size());
        for (String n : parsedNodes) {
            if (n.isEmpty()) continue;
            boolean isHard = n.endsWith("H");
            if (isHard) {
                n = n.substring(0, n.length() - 1).trim();
            }
            int nodeNumber = Integer.parseInt(n);
            nodes.add(new ChildNumber(nodeNumber, isHard));
        }
        return new HDPath(hasPrivateKey, nodes);
    }

    public boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    public HDPath extend(ChildNumber child1, ChildNumber ... children) {
        ArrayList<ChildNumber> mutable = new ArrayList<ChildNumber>(this.unmodifiableList);
        mutable.add(child1);
        mutable.addAll(Arrays.asList(children));
        return new HDPath(this.hasPrivateKey, mutable);
    }

    public HDPath extend(HDPath path2) {
        ArrayList<ChildNumber> mutable = new ArrayList<ChildNumber>(this.unmodifiableList);
        mutable.addAll(path2);
        return new HDPath(this.hasPrivateKey, mutable);
    }

    public HDPath extend(List<ChildNumber> path2) {
        return this.extend(HDPath.M(path2));
    }

    @Override
    public ChildNumber get(int index) {
        return this.unmodifiableList.get(index);
    }

    @Override
    public int size() {
        return this.unmodifiableList.size();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.hasPrivateKey ? (char)'m' : 'M');
        for (ChildNumber segment : this.unmodifiableList) {
            b.append('/');
            b.append(segment.toString());
        }
        return b.toString();
    }
}

