/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerFilterProvider;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionBroadcast;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.UTXOProvider;
import org.bitcoinj.core.UTXOProviderException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.listeners.NewBestBlockListener;
import org.bitcoinj.core.listeners.ReorganizeListener;
import org.bitcoinj.core.listeners.TransactionConfidenceEventListener;
import org.bitcoinj.core.listeners.TransactionReceivedInBlockListener;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.KeyCrypterException;
import org.bitcoinj.crypto.KeyCrypterScrypt;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.script.ScriptChunk;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.script.ScriptPattern;
import org.bitcoinj.signers.LocalTransactionSigner;
import org.bitcoinj.signers.MissingSigResolutionSigner;
import org.bitcoinj.signers.TransactionSigner;
import org.bitcoinj.utils.BaseTaggableObject;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.AllRandomKeysRotating;
import org.bitcoinj.wallet.CoinSelection;
import org.bitcoinj.wallet.CoinSelector;
import org.bitcoinj.wallet.DecryptingKeyBag;
import org.bitcoinj.wallet.DefaultCoinSelector;
import org.bitcoinj.wallet.DefaultRiskAnalysis;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.DeterministicUpgradeRequiresPassword;
import org.bitcoinj.wallet.FilteringCoinSelector;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.KeyChainGroup;
import org.bitcoinj.wallet.KeyChainGroupStructure;
import org.bitcoinj.wallet.KeyTimeCoinSelector;
import org.bitcoinj.wallet.Protos;
import org.bitcoinj.wallet.RedeemData;
import org.bitcoinj.wallet.RiskAnalysis;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.UnreadableWalletException;
import org.bitcoinj.wallet.WalletExtension;
import org.bitcoinj.wallet.WalletFiles;
import org.bitcoinj.wallet.WalletProtobufSerializer;
import org.bitcoinj.wallet.WalletTransaction;
import org.bitcoinj.wallet.listeners.CurrentKeyChangeEventListener;
import org.bitcoinj.wallet.listeners.KeyChainEventListener;
import org.bitcoinj.wallet.listeners.ScriptsChangeEventListener;
import org.bitcoinj.wallet.listeners.WalletChangeEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsReceivedEventListener;
import org.bitcoinj.wallet.listeners.WalletCoinsSentEventListener;
import org.bitcoinj.wallet.listeners.WalletReorganizeEventListener;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wallet
extends BaseTaggableObject
implements NewBestBlockListener,
TransactionReceivedInBlockListener,
PeerFilterProvider,
KeyBag,
TransactionBag,
ReorganizeListener {
    private static final Logger log = LoggerFactory.getLogger(Wallet.class);
    protected final ReentrantLock lock = Threading.lock(Wallet.class);
    protected final ReentrantLock keyChainGroupLock = Threading.lock("Wallet-KeyChainGroup lock");
    private static final int MINIMUM_BLOOM_DATA_LENGTH = 8;
    private final Map<Sha256Hash, Transaction> pending;
    private final Map<Sha256Hash, Transaction> unspent;
    private final Map<Sha256Hash, Transaction> spent;
    private final Map<Sha256Hash, Transaction> dead;
    protected final Map<Sha256Hash, Transaction> transactions;
    protected final HashSet<TransactionOutput> myUnspents = new HashSet();
    private final LinkedHashMap<Sha256Hash, Transaction> riskDropped = new LinkedHashMap<Sha256Hash, Transaction>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Sha256Hash, Transaction> eldest) {
            return this.size() > 1000;
        }
    };
    @GuardedBy(value="keyChainGroupLock")
    private KeyChainGroup keyChainGroup;
    @GuardedBy(value="keyChainGroupLock")
    private Set<Script> watchedScripts;
    protected final Context context;
    protected final NetworkParameters params;
    @Nullable
    private Sha256Hash lastBlockSeenHash;
    private int lastBlockSeenHeight;
    private long lastBlockSeenTimeSecs;
    private final CopyOnWriteArrayList<ListenerRegistration<WalletChangeEventListener>> changeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<WalletCoinsReceivedEventListener>> coinsReceivedListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<WalletCoinsSentEventListener>> coinsSentListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<WalletReorganizeEventListener>> reorganizeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<ScriptsChangeEventListener>> scriptsChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerRegistration<TransactionConfidenceEventListener>> transactionConfidenceListeners = new CopyOnWriteArrayList();
    private TransactionConfidence.Listener txConfidenceListener;
    private HashSet<Sha256Hash> ignoreNextNewBlock;
    private boolean acceptRiskyTransactions;
    private RiskAnalysis.Analyzer riskAnalyzer = DefaultRiskAnalysis.FACTORY;
    private int onWalletChangedSuppressions;
    private boolean insideReorg;
    private Map<Transaction, TransactionConfidence.Listener.ChangeReason> confidenceChanged;
    protected volatile WalletFiles vFileManager;
    protected volatile TransactionBroadcaster vTransactionBroadcaster;
    private volatile long vKeyRotationTimestamp;
    protected final CoinSelector coinSelector = DefaultCoinSelector.get();
    private int version;
    private String description;
    private final HashMap<String, WalletExtension> extensions;
    @GuardedBy(value="lock")
    private volatile List<TransactionSigner> signers;
    @Nullable
    private volatile UTXOProvider vUTXOProvider;
    private boolean hardSaveOnNextBlock = false;
    @GuardedBy(value="lock")
    private List<BalanceFutureRequest> balanceFutureRequests = new LinkedList<BalanceFutureRequest>();
    private final ArrayList<TransactionOutPoint> bloomOutPoints = new ArrayList();
    private final AtomicInteger bloomFilterGuard = new AtomicInteger(0);

    public static Wallet createDeterministic(NetworkParameters params, Script.ScriptType outputScriptType) {
        return Wallet.createDeterministic(Context.getOrCreate(params), outputScriptType);
    }

    public static Wallet createDeterministic(Context context, Script.ScriptType outputScriptType) {
        return new Wallet(context, KeyChainGroup.builder(context.getParams()).fromRandom(outputScriptType).build());
    }

    @Deprecated
    @VisibleForTesting
    protected Wallet(Context context) {
        this(context, KeyChainGroup.builder(context.getParams()).fromRandom(Script.ScriptType.P2PKH).build());
    }

    public static Wallet createBasic(NetworkParameters params) {
        return new Wallet(params, KeyChainGroup.createBasic(params));
    }

    public static Wallet fromSeed(NetworkParameters params, DeterministicSeed seed, Script.ScriptType outputScriptType) {
        return Wallet.fromSeed(params, seed, outputScriptType, KeyChainGroupStructure.DEFAULT);
    }

    public static Wallet fromSeed(NetworkParameters params, DeterministicSeed seed, Script.ScriptType outputScriptType, KeyChainGroupStructure structure) {
        return new Wallet(params, KeyChainGroup.builder(params, structure).fromSeed(seed, outputScriptType).build());
    }

    @Deprecated
    public static Wallet fromSeed(NetworkParameters params, DeterministicSeed seed) {
        return Wallet.fromSeed(params, seed, Script.ScriptType.P2PKH);
    }

    public static Wallet fromSeed(NetworkParameters params, DeterministicSeed seed, Script.ScriptType outputScriptType, List<ChildNumber> accountPath) {
        DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().seed(seed)).outputScriptType(outputScriptType)).accountPath(accountPath)).build();
        return new Wallet(params, KeyChainGroup.builder(params).addChain(chain).build());
    }

    @Deprecated
    public static Wallet fromSeed(NetworkParameters params, DeterministicSeed seed, List<ChildNumber> accountPath) {
        return Wallet.fromSeed(params, seed, Script.ScriptType.P2PKH, accountPath);
    }

    public static Wallet fromWatchingKey(NetworkParameters params, DeterministicKey watchKey, Script.ScriptType outputScriptType) {
        DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().watch(watchKey)).outputScriptType(outputScriptType)).build();
        return new Wallet(params, KeyChainGroup.builder(params).addChain(chain).build());
    }

    @Deprecated
    public static Wallet fromWatchingKey(NetworkParameters params, DeterministicKey watchKey) {
        return Wallet.fromWatchingKey(params, watchKey, Script.ScriptType.P2PKH);
    }

    public static Wallet fromWatchingKeyB58(NetworkParameters params, String watchKeyB58, long creationTimeSeconds) {
        DeterministicKey watchKey = DeterministicKey.deserializeB58(null, watchKeyB58, params);
        watchKey.setCreationTimeSeconds(creationTimeSeconds);
        return Wallet.fromWatchingKey(params, watchKey, Wallet.outputScriptTypeFromB58(params, watchKeyB58));
    }

    public static Wallet fromSpendingKey(NetworkParameters params, DeterministicKey spendKey, Script.ScriptType outputScriptType) {
        DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().spend(spendKey)).outputScriptType(outputScriptType)).build();
        return new Wallet(params, KeyChainGroup.builder(params).addChain(chain).build());
    }

    @Deprecated
    public static Wallet fromSpendingKey(NetworkParameters params, DeterministicKey spendKey) {
        return Wallet.fromSpendingKey(params, spendKey, Script.ScriptType.P2PKH);
    }

    public static Wallet fromSpendingKeyB58(NetworkParameters params, String spendingKeyB58, long creationTimeSeconds) {
        DeterministicKey spendKey = DeterministicKey.deserializeB58(null, spendingKeyB58, params);
        spendKey.setCreationTimeSeconds(creationTimeSeconds);
        return Wallet.fromSpendingKey(params, spendKey, Wallet.outputScriptTypeFromB58(params, spendingKeyB58));
    }

    public static Wallet fromMasterKey(NetworkParameters params, DeterministicKey masterKey, Script.ScriptType outputScriptType, ChildNumber accountNumber) {
        DeterministicKey accountKey = HDKeyDerivation.deriveChildKey(masterKey, accountNumber);
        accountKey = accountKey.dropParent();
        accountKey.setCreationTimeSeconds(masterKey.getCreationTimeSeconds());
        DeterministicKeyChain chain = ((DeterministicKeyChain.Builder)((DeterministicKeyChain.Builder)DeterministicKeyChain.builder().spend(accountKey)).outputScriptType(outputScriptType)).build();
        return new Wallet(params, KeyChainGroup.builder(params).addChain(chain).build());
    }

    @Deprecated
    public static Wallet fromKeys(NetworkParameters params, List<ECKey> keys) {
        for (ECKey key : keys) {
            Preconditions.checkArgument((!(key instanceof DeterministicKey) ? 1 : 0) != 0);
        }
        KeyChainGroup group = KeyChainGroup.builder(params).build();
        group.importKeys(keys);
        return new Wallet(params, group);
    }

    private static Script.ScriptType outputScriptTypeFromB58(NetworkParameters params, String base58) {
        int header = ByteBuffer.wrap(Base58.decodeChecked(base58)).getInt();
        if (header == params.getBip32HeaderP2PKHpub() || header == params.getBip32HeaderP2PKHpriv()) {
            return Script.ScriptType.P2PKH;
        }
        if (header == params.getBip32HeaderP2WPKHpub() || header == params.getBip32HeaderP2WPKHpriv()) {
            return Script.ScriptType.P2WPKH;
        }
        throw new IllegalArgumentException(base58.substring(0, 4));
    }

    public Wallet(NetworkParameters params, KeyChainGroup keyChainGroup) {
        this(Context.getOrCreate(params), keyChainGroup);
    }

    private Wallet(Context context, KeyChainGroup keyChainGroup) {
        this.context = (Context)Preconditions.checkNotNull((Object)context);
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)context.getParams());
        this.keyChainGroup = (KeyChainGroup)Preconditions.checkNotNull((Object)keyChainGroup);
        this.watchedScripts = new HashSet<Script>();
        this.unspent = new HashMap<Sha256Hash, Transaction>();
        this.spent = new HashMap<Sha256Hash, Transaction>();
        this.pending = new HashMap<Sha256Hash, Transaction>();
        this.dead = new HashMap<Sha256Hash, Transaction>();
        this.transactions = new HashMap<Sha256Hash, Transaction>();
        this.extensions = new HashMap();
        this.confidenceChanged = new LinkedHashMap<Transaction, TransactionConfidence.Listener.ChangeReason>();
        this.signers = new ArrayList<TransactionSigner>();
        this.addTransactionSigner(new LocalTransactionSigner());
        this.createTransientState();
    }

    private void createTransientState() {
        this.ignoreNextNewBlock = new HashSet();
        this.txConfidenceListener = new TransactionConfidence.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfidenceChanged(TransactionConfidence confidence, TransactionConfidence.Listener.ChangeReason reason) {
                if (reason == TransactionConfidence.Listener.ChangeReason.SEEN_PEERS) {
                    Wallet.this.lock.lock();
                    try {
                        Wallet.this.checkBalanceFuturesLocked(null);
                        Transaction tx = Wallet.this.getTransaction(confidence.getTransactionHash());
                        Wallet.this.queueOnTransactionConfidenceChanged(tx);
                        Wallet.this.maybeQueueOnWalletChanged();
                    }
                    finally {
                        Wallet.this.lock.unlock();
                    }
                }
            }
        };
        this.acceptRiskyTransactions = false;
    }

    public NetworkParameters getNetworkParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeterministicKeyChain> getActiveKeyChains() {
        this.keyChainGroupLock.lock();
        try {
            long keyRotationTimeSecs = this.vKeyRotationTimestamp;
            List<DeterministicKeyChain> list = this.keyChainGroup.getActiveKeyChains(keyRotationTimeSecs);
            return list;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicKeyChain getActiveKeyChain() {
        this.keyChainGroupLock.lock();
        try {
            DeterministicKeyChain deterministicKeyChain = this.keyChainGroup.getActiveKeyChain();
            return deterministicKeyChain;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public final void addTransactionSigner(TransactionSigner signer) {
        block4: {
            this.lock.lock();
            try {
                if (signer.isReady()) {
                    this.signers.add(signer);
                    break block4;
                }
                throw new IllegalStateException("Signer instance is not ready to be added into Wallet: " + signer.getClass());
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public List<TransactionSigner> getTransactionSigners() {
        this.lock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.signers);
            return immutableList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public DeterministicKey currentKey(KeyChain.KeyPurpose purpose) {
        this.keyChainGroupLock.lock();
        try {
            DeterministicKey deterministicKey = this.keyChainGroup.currentKey(purpose);
            return deterministicKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicKey currentReceiveKey() {
        return this.currentKey(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    public Address currentAddress(KeyChain.KeyPurpose purpose) {
        this.keyChainGroupLock.lock();
        try {
            Address address = this.keyChainGroup.currentAddress(purpose);
            return address;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public Address currentReceiveAddress() {
        return this.currentAddress(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    public DeterministicKey freshKey(KeyChain.KeyPurpose purpose) {
        return this.freshKeys(purpose, 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeterministicKey> freshKeys(KeyChain.KeyPurpose purpose, int numberOfKeys) {
        List<DeterministicKey> keys;
        this.keyChainGroupLock.lock();
        try {
            keys = this.keyChainGroup.freshKeys(purpose, numberOfKeys);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
        return keys;
    }

    public DeterministicKey freshReceiveKey() {
        return this.freshKey(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    public Address freshAddress(KeyChain.KeyPurpose purpose) {
        Address address;
        this.keyChainGroupLock.lock();
        try {
            address = this.keyChainGroup.freshAddress(purpose);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
        return address;
    }

    public Address freshReceiveAddress() {
        return this.freshAddress(KeyChain.KeyPurpose.RECEIVE_FUNDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address freshReceiveAddress(Script.ScriptType scriptType) {
        Address address;
        this.keyChainGroupLock.lock();
        try {
            long keyRotationTimeSecs = this.vKeyRotationTimestamp;
            address = this.keyChainGroup.freshAddress(KeyChain.KeyPurpose.RECEIVE_FUNDS, scriptType, keyRotationTimeSecs);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ECKey> getIssuedReceiveKeys() {
        this.keyChainGroupLock.lock();
        try {
            LinkedList<DeterministicKey> keys = new LinkedList<DeterministicKey>();
            long keyRotationTimeSecs = this.vKeyRotationTimestamp;
            for (DeterministicKeyChain chain : this.keyChainGroup.getActiveKeyChains(keyRotationTimeSecs)) {
                keys.addAll(chain.getIssuedReceiveKeys());
            }
            LinkedList<DeterministicKey> linkedList = keys;
            return linkedList;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getIssuedReceiveAddresses() {
        this.keyChainGroupLock.lock();
        try {
            ArrayList<Address> addresses = new ArrayList<Address>();
            long keyRotationTimeSecs = this.vKeyRotationTimestamp;
            for (DeterministicKeyChain chain : this.keyChainGroup.getActiveKeyChains(keyRotationTimeSecs)) {
                Script.ScriptType outputScriptType = chain.getOutputScriptType();
                for (ECKey eCKey : chain.getIssuedReceiveKeys()) {
                    addresses.add(Address.fromKey(this.getParams(), eCKey, outputScriptType));
                }
            }
            ArrayList<Address> arrayList = addresses;
            return arrayList;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Deprecated
    public void upgradeToDeterministic(@Nullable KeyParameter aesKey) {
        this.upgradeToDeterministic(Script.ScriptType.P2PKH, aesKey);
    }

    public void upgradeToDeterministic(Script.ScriptType outputScriptType, @Nullable KeyParameter aesKey) throws DeterministicUpgradeRequiresPassword {
        this.upgradeToDeterministic(outputScriptType, KeyChainGroupStructure.DEFAULT, aesKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeToDeterministic(Script.ScriptType outputScriptType, KeyChainGroupStructure structure, @Nullable KeyParameter aesKey) throws DeterministicUpgradeRequiresPassword {
        this.keyChainGroupLock.lock();
        try {
            long keyRotationTimeSecs = this.vKeyRotationTimestamp;
            this.keyChainGroup.upgradeToDeterministic(outputScriptType, structure, keyRotationTimeSecs, aesKey);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Deprecated
    public boolean isDeterministicUpgradeRequired() {
        return this.isDeterministicUpgradeRequired(Script.ScriptType.P2PKH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeterministicUpgradeRequired(Script.ScriptType outputScriptType) {
        this.keyChainGroupLock.lock();
        try {
            long keyRotationTimeSecs = this.vKeyRotationTimestamp;
            boolean bl = this.keyChainGroup.isDeterministicUpgradeRequired(outputScriptType, keyRotationTimeSecs);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public List<Script> getWatchedScripts() {
        this.keyChainGroupLock.lock();
        try {
            ArrayList<Script> arrayList = new ArrayList<Script>(this.watchedScripts);
            return arrayList;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean removeKey(ECKey key) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.removeImportedKey(key);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public int getKeyChainGroupSize() {
        this.keyChainGroupLock.lock();
        try {
            int n = this.keyChainGroup.numKeys();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @VisibleForTesting
    public int getKeyChainGroupCombinedKeyLookaheadEpochs() {
        this.keyChainGroupLock.lock();
        try {
            int n = this.keyChainGroup.getCombinedKeyLookaheadEpochs();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public List<ECKey> getImportedKeys() {
        this.keyChainGroupLock.lock();
        try {
            List<ECKey> list = this.keyChainGroup.getImportedKeys();
            return list;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public Address currentChangeAddress() {
        return this.currentAddress(KeyChain.KeyPurpose.CHANGE);
    }

    public boolean importKey(ECKey key) {
        return this.importKeys(Lists.newArrayList((Object[])new ECKey[]{key})) == 1;
    }

    public int importKeys(List<ECKey> keys) {
        int result;
        this.checkNoDeterministicKeys(keys);
        this.keyChainGroupLock.lock();
        try {
            result = this.keyChainGroup.importKeys(keys);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
        return result;
    }

    private void checkNoDeterministicKeys(List<ECKey> keys) {
        for (ECKey key : keys) {
            if (!(key instanceof DeterministicKey)) continue;
            throw new IllegalArgumentException("Cannot import HD keys back into the wallet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importKeysAndEncrypt(List<ECKey> keys, CharSequence password) {
        this.keyChainGroupLock.lock();
        try {
            Preconditions.checkNotNull((Object)this.getKeyCrypter(), (Object)"Wallet is not encrypted");
            int n = this.importKeysAndEncrypt(keys, this.getKeyCrypter().deriveKey(password));
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importKeysAndEncrypt(List<ECKey> keys, KeyParameter aesKey) {
        this.keyChainGroupLock.lock();
        try {
            this.checkNoDeterministicKeys(keys);
            int n = this.keyChainGroup.importKeysAndEncrypt(keys, aesKey);
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void addAndActivateHDChain(DeterministicKeyChain chain) {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.addAndActivateHDChain(chain);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public int getKeyChainGroupLookaheadSize() {
        this.keyChainGroupLock.lock();
        try {
            int n = this.keyChainGroup.getLookaheadSize();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public int getKeyChainGroupLookaheadThreshold() {
        this.keyChainGroupLock.lock();
        try {
            int n = this.keyChainGroup.getLookaheadThreshold();
            return n;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicKey getWatchingKey() {
        this.keyChainGroupLock.lock();
        try {
            DeterministicKey deterministicKey = this.keyChainGroup.getActiveKeyChain().getWatchingKey();
            return deterministicKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isWatching() {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.isWatching();
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isAddressWatched(Address address) {
        Script script = ScriptBuilder.createOutputScript(address);
        return this.isWatchedScript(script);
    }

    public boolean addWatchedAddress(Address address) {
        long now = Utils.currentTimeSeconds();
        return this.addWatchedAddresses(Lists.newArrayList((Object[])new Address[]{address}), now) == 1;
    }

    public boolean addWatchedAddress(Address address, long creationTime) {
        return this.addWatchedAddresses(Lists.newArrayList((Object[])new Address[]{address}), creationTime) == 1;
    }

    public int addWatchedAddresses(List<Address> addresses, long creationTime) {
        ArrayList<Script> scripts = new ArrayList<Script>();
        for (Address address : addresses) {
            Script script = ScriptBuilder.createOutputScript(address);
            script.setCreationTimeSeconds(creationTime);
            scripts.add(script);
        }
        return this.addWatchedScripts(scripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWatchedScripts(List<Script> scripts) {
        int added = 0;
        this.keyChainGroupLock.lock();
        try {
            for (Script script : scripts) {
                if (this.watchedScripts.contains(script)) {
                    this.watchedScripts.remove(script);
                }
                if (script.getCreationTimeSeconds() == 0L) {
                    log.warn("Adding a script to the wallet with a creation time of zero, this will disable the checkpointing optimization!    {}", (Object)script);
                }
                this.watchedScripts.add(script);
                ++added;
            }
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        if (added > 0) {
            this.queueOnScriptsChanged(scripts, true);
            this.saveNow();
        }
        return added;
    }

    public boolean removeWatchedAddress(Address address) {
        return this.removeWatchedAddresses((List<Address>)ImmutableList.of((Object)address));
    }

    public boolean removeWatchedAddresses(List<Address> addresses) {
        ArrayList<Script> scripts = new ArrayList<Script>();
        for (Address address : addresses) {
            Script script = ScriptBuilder.createOutputScript(address);
            scripts.add(script);
        }
        return this.removeWatchedScripts(scripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWatchedScripts(List<Script> scripts) {
        this.lock.lock();
        try {
            for (Script script : scripts) {
                if (!this.watchedScripts.contains(script)) continue;
                this.watchedScripts.remove(script);
            }
            this.queueOnScriptsChanged(scripts, false);
            this.saveNow();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getWatchedAddresses() {
        this.keyChainGroupLock.lock();
        try {
            LinkedList<Address> addresses = new LinkedList<Address>();
            for (Script script : this.watchedScripts) {
                if (!ScriptPattern.isP2PKH(script)) continue;
                addresses.add(script.getToAddress(this.params));
            }
            LinkedList<Address> linkedList = addresses;
            return linkedList;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Deprecated
    public ECKey findKeyFromPubHash(byte[] pubKeyHash) {
        return this.findKeyFromPubKeyHash(pubKeyHash, Script.ScriptType.P2PKH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ECKey findKeyFromPubKeyHash(byte[] pubKeyHash, @Nullable Script.ScriptType scriptType) {
        this.keyChainGroupLock.lock();
        try {
            ECKey eCKey = this.keyChainGroup.findKeyFromPubKeyHash(pubKeyHash, scriptType);
            return eCKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean hasKey(ECKey key) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.hasKey(key);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isAddressMine(Address address) {
        Script.ScriptType scriptType = address.getOutputScriptType();
        if (scriptType == Script.ScriptType.P2PKH || scriptType == Script.ScriptType.P2WPKH) {
            return this.isPubKeyHashMine(address.getHash(), scriptType);
        }
        if (scriptType == Script.ScriptType.P2SH) {
            return this.isPayToScriptHashMine(address.getHash());
        }
        if (scriptType == Script.ScriptType.P2WSH || scriptType == Script.ScriptType.P2TR) {
            return false;
        }
        throw new IllegalArgumentException(address.toString());
    }

    @Deprecated
    public boolean isPubKeyHashMine(byte[] pubKeyHash) {
        return this.isPubKeyHashMine(pubKeyHash, Script.ScriptType.P2PKH);
    }

    @Override
    public boolean isPubKeyHashMine(byte[] pubKeyHash, @Nullable Script.ScriptType scriptType) {
        return this.findKeyFromPubKeyHash(pubKeyHash, scriptType) != null;
    }

    @Override
    public boolean isWatchedScript(Script script) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.watchedScripts.contains(script);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public ECKey findKeyFromAddress(Address address) {
        Script.ScriptType scriptType = address.getOutputScriptType();
        if (scriptType == Script.ScriptType.P2PKH || scriptType == Script.ScriptType.P2WPKH) {
            return this.findKeyFromPubKeyHash(address.getHash(), scriptType);
        }
        return null;
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubKey) {
        this.keyChainGroupLock.lock();
        try {
            ECKey eCKey = this.keyChainGroup.findKeyFromPubKey(pubKey);
            return eCKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Override
    public boolean isPubKeyMine(byte[] pubKey) {
        return this.findKeyFromPubKey(pubKey) != null;
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataFromScriptHash(byte[] payToScriptHash) {
        this.keyChainGroupLock.lock();
        try {
            RedeemData redeemData = this.keyChainGroup.findRedeemDataFromScriptHash(payToScriptHash);
            return redeemData;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Override
    public boolean isPayToScriptHashMine(byte[] payToScriptHash) {
        return this.findRedeemDataFromScriptHash(payToScriptHash) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markKeysAsUsed(Transaction tx) {
        this.keyChainGroupLock.lock();
        try {
            for (TransactionOutput o : tx.getOutputs()) {
                try {
                    byte[] pubkeyHash;
                    Script script = o.getScriptPubKey();
                    if (ScriptPattern.isP2PK(script)) {
                        byte[] pubkey = ScriptPattern.extractKeyFromP2PK(script);
                        this.keyChainGroup.markPubKeyAsUsed(pubkey);
                        continue;
                    }
                    if (ScriptPattern.isP2PKH(script)) {
                        pubkeyHash = ScriptPattern.extractHashFromP2PKH(script);
                        this.keyChainGroup.markPubKeyHashAsUsed(pubkeyHash);
                        continue;
                    }
                    if (ScriptPattern.isP2SH(script)) {
                        LegacyAddress a = LegacyAddress.fromScriptHash(tx.getParams(), ScriptPattern.extractHashFromP2SH(script));
                        this.keyChainGroup.markP2SHAddressAsUsed(a);
                        continue;
                    }
                    if (!ScriptPattern.isP2WH(script)) continue;
                    pubkeyHash = ScriptPattern.extractHashFromP2WH(script);
                    this.keyChainGroup.markPubKeyHashAsUsed(pubkeyHash);
                }
                catch (ScriptException e) {
                    log.info("Could not parse tx output script: {}", (Object)e.toString());
                }
            }
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicSeed getKeyChainSeed() {
        this.keyChainGroupLock.lock();
        try {
            DeterministicSeed seed = this.keyChainGroup.getActiveKeyChain().getSeed();
            if (seed == null) {
                throw new ECKey.MissingPrivateKeyException();
            }
            DeterministicSeed deterministicSeed = seed;
            return deterministicSeed;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public DeterministicKey getKeyByPath(List<ChildNumber> path) {
        this.keyChainGroupLock.lock();
        try {
            DeterministicKey deterministicKey = this.keyChainGroup.getActiveKeyChain().getKeyByPath(path, false);
            return deterministicKey;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void encrypt(CharSequence password) {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypterScrypt scrypt = new KeyCrypterScrypt();
            this.keyChainGroup.encrypt(scrypt, scrypt.deriveKey(password));
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public void encrypt(KeyCrypter keyCrypter, KeyParameter aesKey) {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.encrypt(keyCrypter, aesKey);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public void decrypt(CharSequence password) throws BadWalletEncryptionKeyException {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypter crypter = this.keyChainGroup.getKeyCrypter();
            Preconditions.checkState((crypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
            this.keyChainGroup.decrypt(crypter.deriveKey(password));
        }
        catch (KeyCrypterException.InvalidCipherText | KeyCrypterException.PublicPrivateMismatch e) {
            throw new BadWalletEncryptionKeyException(e);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public void decrypt(KeyParameter aesKey) throws BadWalletEncryptionKeyException {
        this.keyChainGroupLock.lock();
        try {
            this.keyChainGroup.decrypt(aesKey);
        }
        catch (KeyCrypterException.InvalidCipherText | KeyCrypterException.PublicPrivateMismatch e) {
            throw new BadWalletEncryptionKeyException(e);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
        this.saveNow();
    }

    public boolean checkPassword(CharSequence password) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.checkPassword(password);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean checkAESKey(KeyParameter aesKey) {
        this.keyChainGroupLock.lock();
        try {
            boolean bl = this.keyChainGroup.checkAESKey(aesKey);
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Nullable
    public KeyCrypter getKeyCrypter() {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypter keyCrypter = this.keyChainGroup.getKeyCrypter();
            return keyCrypter;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public Protos.Wallet.EncryptionType getEncryptionType() {
        this.keyChainGroupLock.lock();
        try {
            KeyCrypter crypter = this.keyChainGroup.getKeyCrypter();
            if (crypter != null) {
                Protos.Wallet.EncryptionType encryptionType = crypter.getUnderstoodEncryptionType();
                return encryptionType;
            }
            Protos.Wallet.EncryptionType encryptionType = Protos.Wallet.EncryptionType.UNENCRYPTED;
            return encryptionType;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public boolean isEncrypted() {
        return this.getEncryptionType() != Protos.Wallet.EncryptionType.UNENCRYPTED;
    }

    public void changeEncryptionPassword(CharSequence currentPassword, CharSequence newPassword) throws BadWalletEncryptionKeyException {
        this.keyChainGroupLock.lock();
        try {
            this.decrypt(currentPassword);
            this.encrypt(newPassword);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeEncryptionKey(KeyCrypter keyCrypter, KeyParameter currentAesKey, KeyParameter newAesKey) throws BadWalletEncryptionKeyException {
        this.keyChainGroupLock.lock();
        try {
            this.decrypt(currentAesKey);
            this.encrypt(keyCrypter, newAesKey);
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public List<Protos.Key> serializeKeyChainGroupToProtobuf() {
        this.keyChainGroupLock.lock();
        try {
            List<Protos.Key> list = this.keyChainGroup.serializeToProtobuf();
            return list;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void saveToFile(File temp, File destFile) throws IOException {
        FileOutputStream stream = null;
        this.lock.lock();
        try {
            stream = new FileOutputStream(temp);
            this.saveToFileStream(stream);
            stream.flush();
            stream.getFD().sync();
            stream.close();
            stream = null;
            if (Utils.isWindows()) {
                File canonical = destFile.getCanonicalFile();
                if (canonical.exists() && !canonical.delete()) {
                    throw new IOException("Failed to delete canonical wallet file for replacement with autosave");
                }
                if (temp.renameTo(canonical)) {
                    return;
                }
                throw new IOException("Failed to rename " + temp + " to " + canonical);
            }
            if (!temp.renameTo(destFile)) {
                throw new IOException("Failed to rename " + temp + " to " + destFile);
            }
        }
        catch (RuntimeException e) {
            log.error("Failed whilst saving wallet", (Throwable)e);
            throw e;
        }
        finally {
            this.lock.unlock();
            if (stream != null) {
                stream.close();
            }
            if (temp.exists()) {
                log.warn("Temp file still exists after failed save.");
            }
        }
    }

    public void saveToFile(File f) throws IOException {
        File directory = f.getAbsoluteFile().getParentFile();
        File temp = File.createTempFile("wallet", null, directory);
        this.saveToFile(temp, f);
    }

    public void setAcceptRiskyTransactions(boolean acceptRiskyTransactions) {
        this.lock.lock();
        try {
            this.acceptRiskyTransactions = acceptRiskyTransactions;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isAcceptRiskyTransactions() {
        this.lock.lock();
        try {
            boolean bl = this.acceptRiskyTransactions;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRiskAnalyzer(RiskAnalysis.Analyzer analyzer) {
        this.lock.lock();
        try {
            this.riskAnalyzer = (RiskAnalysis.Analyzer)Preconditions.checkNotNull((Object)analyzer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public RiskAnalysis.Analyzer getRiskAnalyzer() {
        this.lock.lock();
        try {
            RiskAnalysis.Analyzer analyzer = this.riskAnalyzer;
            return analyzer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalletFiles autosaveToFile(File f, long delayTime, TimeUnit timeUnit, @Nullable WalletFiles.Listener eventListener) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.vFileManager == null ? 1 : 0) != 0, (Object)"Already auto saving this wallet.");
            WalletFiles manager = new WalletFiles(this, f, delayTime, timeUnit);
            if (eventListener != null) {
                manager.setListener(eventListener);
            }
            this.vFileManager = manager;
            WalletFiles walletFiles = manager;
            return walletFiles;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdownAutosaveAndWait() {
        this.lock.lock();
        try {
            WalletFiles files = this.vFileManager;
            this.vFileManager = null;
            Preconditions.checkState((files != null ? 1 : 0) != 0, (Object)"Auto saving not enabled.");
            files.shutdownAndWait();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void saveLater() {
        WalletFiles files = this.vFileManager;
        if (files != null) {
            files.saveLater();
        }
    }

    protected void saveNow() {
        block3: {
            WalletFiles files = this.vFileManager;
            if (files != null) {
                try {
                    files.saveNow();
                }
                catch (IOException e) {
                    log.error("Failed to save wallet to disk!", (Throwable)e);
                    Thread.UncaughtExceptionHandler handler = Threading.uncaughtExceptionHandler;
                    if (handler == null) break block3;
                    handler.uncaughtException(Thread.currentThread(), e);
                }
            }
        }
    }

    public void saveToFileStream(OutputStream f) throws IOException {
        this.lock.lock();
        try {
            new WalletProtobufSerializer().writeWallet(this, f);
        }
        finally {
            this.lock.unlock();
        }
    }

    public NetworkParameters getParams() {
        return this.params;
    }

    public Context getContext() {
        return this.context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Wallet loadFromFile(File file, WalletExtension ... walletExtensions) throws UnreadableWalletException {
        try (FileInputStream stream = new FileInputStream(file);){
            Wallet wallet = Wallet.loadFromFileStream(stream, walletExtensions);
            return wallet;
        }
        catch (IOException e) {
            throw new UnreadableWalletException("Could not open file", e);
        }
    }

    public boolean isConsistent() {
        try {
            this.isConsistentOrThrow();
            return true;
        }
        catch (IllegalStateException x) {
            log.error(x.getMessage());
            try {
                log.error(this.toString());
            }
            catch (RuntimeException x2) {
                log.error("Printing inconsistent wallet failed", (Throwable)x2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isConsistentOrThrow() throws IllegalStateException {
        this.lock.lock();
        try {
            Set<Transaction> transactions = this.getTransactions(true);
            HashSet<Sha256Hash> hashes = new HashSet<Sha256Hash>();
            for (Transaction tx : transactions) {
                hashes.add(tx.getTxId());
            }
            int size1 = transactions.size();
            if (size1 != hashes.size()) {
                throw new IllegalStateException("Two transactions with same hash");
            }
            int size2 = this.unspent.size() + this.spent.size() + this.pending.size() + this.dead.size();
            if (size1 != size2) {
                throw new IllegalStateException("Inconsistent wallet sizes: " + size1 + ", " + size2);
            }
            for (Transaction tx : this.unspent.values()) {
                if (this.isTxConsistent(tx, false)) continue;
                throw new IllegalStateException("Inconsistent unspent tx: " + tx.getTxId());
            }
            for (Transaction tx : this.spent.values()) {
                if (this.isTxConsistent(tx, true)) continue;
                throw new IllegalStateException("Inconsistent spent tx: " + tx.getTxId());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    boolean isTxConsistent(Transaction tx, boolean isSpent) {
        boolean isActuallySpent = true;
        for (TransactionOutput o : tx.getOutputs()) {
            if (o.isAvailableForSpending()) {
                if (o.isMineOrWatched(this)) {
                    isActuallySpent = false;
                }
                if (o.getSpentBy() == null) continue;
                log.error("isAvailableForSpending != spentBy");
                return false;
            }
            if (o.getSpentBy() != null) continue;
            log.error("isAvailableForSpending != spentBy");
            return false;
        }
        return isActuallySpent == isSpent;
    }

    public static Wallet loadFromFileStream(InputStream stream, WalletExtension ... walletExtensions) throws UnreadableWalletException {
        Wallet wallet = new WalletProtobufSerializer().readWallet(stream, walletExtensions);
        if (!wallet.isConsistent()) {
            log.error("Loaded an inconsistent wallet");
        }
        return wallet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notifyTransactionIsInBlock(Sha256Hash txHash, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        this.lock.lock();
        try {
            Transaction tx = this.transactions.get(txHash);
            if (tx == null) {
                tx = this.riskDropped.get(txHash);
                if (tx != null) {
                    log.info("Risk analysis dropped tx {} but was included in block anyway", (Object)tx.getTxId());
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            this.receive(tx, block, blockType, relativityOffset);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivePending(Transaction tx, @Nullable List<Transaction> dependencies, boolean overrideIsRelevant) throws VerificationException {
        this.lock.lock();
        try {
            tx.verify();
            EnumSet<WalletTransaction.Pool> containingPools = this.getContainingPools(tx);
            if (!containingPools.equals(EnumSet.noneOf(WalletTransaction.Pool.class))) {
                log.debug("Received tx we already saw in a block or created ourselves: " + tx.getTxId());
                return;
            }
            if (!overrideIsRelevant && !this.isPendingTransactionRelevant(tx)) {
                return;
            }
            if (this.isTransactionRisky(tx, dependencies) && !this.acceptRiskyTransactions) {
                Transaction cloneTx = tx.getParams().getDefaultSerializer().makeTransaction(tx.bitcoinSerialize());
                cloneTx.setPurpose(tx.getPurpose());
                cloneTx.setUpdateTime(tx.getUpdateTime());
                this.riskDropped.put(cloneTx.getTxId(), cloneTx);
                log.warn("There are now {} risk dropped transactions being kept in memory", (Object)this.riskDropped.size());
                return;
            }
            Coin valueSentToMe = tx.getValueSentToMe(this);
            Coin valueSentFromMe = tx.getValueSentFromMe(this);
            if (log.isInfoEnabled()) {
                log.info("Received a pending transaction {} that spends {} from our own wallet, and sends us {}", new Object[]{tx.getTxId(), valueSentFromMe.toFriendlyString(), valueSentToMe.toFriendlyString()});
            }
            if (tx.getConfidence().getSource().equals((Object)TransactionConfidence.Source.UNKNOWN)) {
                log.warn("Wallet received transaction with an unknown source. Consider tagging it!");
            }
            Transaction cloneTx = tx.getParams().getDefaultSerializer().makeTransaction(tx.bitcoinSerialize());
            cloneTx.setPurpose(tx.getPurpose());
            cloneTx.setUpdateTime(tx.getUpdateTime());
            this.commitTx(cloneTx);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransactionRisky(Transaction tx, @Nullable List<Transaction> dependencies) {
        this.lock.lock();
        try {
            RiskAnalysis analysis;
            RiskAnalysis.Result result;
            if (dependencies == null) {
                dependencies = ImmutableList.of();
            }
            if ((result = (analysis = this.riskAnalyzer.create(this, tx, (List<Transaction>)dependencies)).analyze()) != RiskAnalysis.Result.OK) {
                log.warn("Pending transaction was considered risky: {}\n{}", (Object)analysis, (Object)tx);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void receivePending(Transaction tx, @Nullable List<Transaction> dependencies) throws VerificationException {
        this.receivePending(tx, dependencies, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPendingTransactionRelevant(Transaction tx) throws ScriptException {
        this.lock.lock();
        try {
            EnumSet<WalletTransaction.Pool> containingPools = this.getContainingPools(tx);
            if (!containingPools.equals(EnumSet.noneOf(WalletTransaction.Pool.class))) {
                log.debug("Received tx we already saw in a block or created ourselves: " + tx.getTxId());
                boolean bl = false;
                return bl;
            }
            if (!this.isTransactionRelevant(tx)) {
                log.debug("Received tx that isn't relevant to this wallet, discarding.");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isTransactionRelevant(Transaction tx) throws ScriptException {
        this.lock.lock();
        try {
            boolean bl = tx.getValueSentFromMe(this).signum() > 0 || tx.getValueSentToMe(this).signum() > 0 || !this.findDoubleSpendsAgainst(tx, this.transactions).isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Set<Transaction> findDoubleSpendsAgainst(Transaction tx, Map<Sha256Hash, Transaction> candidates) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (tx.isCoinBase()) {
            return new HashSet<Transaction>();
        }
        HashSet<TransactionOutPoint> outpoints = new HashSet<TransactionOutPoint>();
        for (TransactionInput input : tx.getInputs()) {
            outpoints.add(input.getOutpoint());
        }
        HashSet<Transaction> doubleSpendTxns = new HashSet<Transaction>();
        for (Transaction p : candidates.values()) {
            if (p.equals(tx)) continue;
            for (TransactionInput input : p.getInputs()) {
                TransactionOutPoint outpoint = input.getOutpoint();
                if (!outpoints.contains(outpoint)) continue;
                doubleSpendTxns.add(p);
            }
        }
        return doubleSpendTxns;
    }

    void addTransactionsDependingOn(Set<Transaction> txSet, Set<Transaction> txPool) {
        LinkedHashMap<Sha256Hash, Transaction> txQueue = new LinkedHashMap<Sha256Hash, Transaction>();
        for (Transaction tx : txSet) {
            txQueue.put(tx.getTxId(), tx);
        }
        while (!txQueue.isEmpty()) {
            Transaction tx = (Transaction)txQueue.remove(txQueue.keySet().iterator().next());
            for (Transaction anotherTx : txPool) {
                if (anotherTx.equals(tx)) continue;
                for (TransactionInput input : anotherTx.getInputs()) {
                    if (!input.getOutpoint().getHash().equals(tx.getTxId()) || txQueue.get(anotherTx.getTxId()) != null) continue;
                    txQueue.put(anotherTx.getTxId(), anotherTx);
                    txSet.add(anotherTx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveFromBlock(Transaction tx, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        this.lock.lock();
        try {
            if (!this.isTransactionRelevant(tx)) {
                return;
            }
            this.receive(tx, block, blockType, relativityOffset);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void receive(Transaction tx, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        boolean wasPending;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Coin prevBalance = this.getBalance();
        Sha256Hash txHash = tx.getTxId();
        boolean bestChain = blockType == AbstractBlockChain.NewBlockType.BEST_CHAIN;
        boolean sideChain = blockType == AbstractBlockChain.NewBlockType.SIDE_CHAIN;
        Coin valueSentFromMe = tx.getValueSentFromMe(this);
        Coin valueSentToMe = tx.getValueSentToMe(this);
        Coin valueDifference = valueSentToMe.subtract(valueSentFromMe);
        log.info("Received tx{} for {}: {} [{}] in block {}", new Object[]{sideChain ? " on a side chain" : "", valueDifference.toFriendlyString(), tx.getTxId(), relativityOffset, block != null ? block.getHeader().getHash() : "(unit test)"});
        this.markKeysAsUsed(tx);
        ++this.onWalletChangedSuppressions;
        Transaction tmp = this.transactions.get(tx.getTxId());
        if (tmp != null) {
            tx = tmp;
        }
        boolean bl = wasPending = this.pending.remove(txHash) != null;
        if (wasPending) {
            log.info("  <-pending");
        }
        if (bestChain) {
            boolean wasDead;
            boolean bl2 = wasDead = this.dead.remove(txHash) != null;
            if (wasDead) {
                log.info("  <-dead");
            }
            if (wasPending) {
                for (TransactionOutput output : tx.getOutputs()) {
                    TransactionInput spentBy = output.getSpentBy();
                    if (spentBy == null) continue;
                    Preconditions.checkState((boolean)this.myUnspents.add(output));
                    spentBy.disconnect();
                }
            }
            this.processTxFromBestChain(tx, wasPending || wasDead);
        } else {
            Preconditions.checkState((boolean)sideChain);
            if (wasPending) {
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
                log.info("  ->pending");
            } else {
                Sha256Hash hash = tx.getTxId();
                if (!(this.unspent.containsKey(hash) || this.spent.containsKey(hash) || this.dead.containsKey(hash))) {
                    this.commitTx(tx);
                }
            }
        }
        if (block != null) {
            tx.setBlockAppearance(block, bestChain, relativityOffset);
            if (bestChain) {
                this.ignoreNextNewBlock.add(txHash);
                HashSet<Transaction> currentTxDependencies = new HashSet<Transaction>();
                currentTxDependencies.add(tx);
                this.addTransactionsDependingOn(currentTxDependencies, this.getTransactions(true));
                currentTxDependencies.remove(tx);
                List<Transaction> currentTxDependenciesSorted = this.sortTxnsByDependency(currentTxDependencies);
                for (Transaction txDependency : currentTxDependenciesSorted) {
                    if (!txDependency.getConfidence().getConfidenceType().equals((Object)TransactionConfidence.ConfidenceType.IN_CONFLICT) || !this.isNotSpendingTxnsInConfidenceType(txDependency, TransactionConfidence.ConfidenceType.IN_CONFLICT)) continue;
                    txDependency.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
                    this.confidenceChanged.put(txDependency, TransactionConfidence.Listener.ChangeReason.TYPE);
                }
            }
        }
        --this.onWalletChangedSuppressions;
        if (bestChain) {
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
        } else {
            this.maybeQueueOnWalletChanged();
        }
        if (!this.insideReorg && bestChain) {
            Coin newBalance = this.getBalance();
            log.info("Balance is now: " + newBalance.toFriendlyString());
            if (!wasPending) {
                int diff = valueDifference.signum();
                if (diff > 0) {
                    this.queueOnCoinsReceived(tx, prevBalance, newBalance);
                } else if (diff < 0) {
                    this.queueOnCoinsSent(tx, prevBalance, newBalance);
                }
            }
            this.checkBalanceFuturesLocked(newBalance);
        }
        this.informConfidenceListenersIfNotReorganizing();
        this.isConsistentOrThrow();
        this.saveLater();
        this.hardSaveOnNextBlock = true;
    }

    private boolean isNotSpendingTxnsInConfidenceType(Transaction tx, TransactionConfidence.ConfidenceType confidenceType) {
        for (TransactionInput txInput : tx.getInputs()) {
            Transaction connectedTx = this.getTransaction(txInput.getOutpoint().getHash());
            if (connectedTx == null || !connectedTx.getConfidence().getConfidenceType().equals((Object)confidenceType)) continue;
            return false;
        }
        return true;
    }

    List<Transaction> sortTxnsByDependency(Set<Transaction> inputSet) {
        ArrayList<Transaction> result = new ArrayList<Transaction>(inputSet);
        for (int i = 0; i < result.size() - 1; ++i) {
            boolean txAtISpendsOtherTxInTheList;
            block1: do {
                txAtISpendsOtherTxInTheList = false;
                for (int j = i + 1; j < result.size(); ++j) {
                    if (!this.spends(result.get(i), result.get(j))) continue;
                    Transaction transactionAtI = result.remove(i);
                    result.add(j, transactionAtI);
                    txAtISpendsOtherTxInTheList = true;
                    continue block1;
                }
            } while (txAtISpendsOtherTxInTheList);
        }
        return result;
    }

    boolean spends(Transaction txA, Transaction txB) {
        for (TransactionInput txInput : txA.getInputs()) {
            if (!txInput.getOutpoint().getHash().equals(txB.getTxId())) continue;
            return true;
        }
        return false;
    }

    private void informConfidenceListenersIfNotReorganizing() {
        if (this.insideReorg) {
            return;
        }
        for (Map.Entry<Transaction, TransactionConfidence.Listener.ChangeReason> entry : this.confidenceChanged.entrySet()) {
            Transaction tx = entry.getKey();
            tx.getConfidence().queueListeners(entry.getValue());
            this.queueOnTransactionConfidenceChanged(tx);
        }
        this.confidenceChanged.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNewBestBlock(StoredBlock block) throws VerificationException {
        Sha256Hash newBlockHash = block.getHeader().getHash();
        if (newBlockHash.equals(this.getLastBlockSeenHash())) {
            return;
        }
        this.lock.lock();
        try {
            this.setLastBlockSeenHash(newBlockHash);
            this.setLastBlockSeenHeight(block.getHeight());
            this.setLastBlockSeenTimeSecs(block.getHeader().getTimeSeconds());
            Set<Transaction> transactions = this.getTransactions(true);
            for (Transaction tx : transactions) {
                if (this.ignoreNextNewBlock.contains(tx.getTxId())) {
                    this.ignoreNextNewBlock.remove(tx.getTxId());
                    continue;
                }
                TransactionConfidence confidence = tx.getConfidence();
                if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) continue;
                if (confidence.incrementDepthInBlocks() > this.context.getEventHorizon()) {
                    confidence.clearBroadcastBy();
                }
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.DEPTH);
            }
            this.informConfidenceListenersIfNotReorganizing();
            this.maybeQueueOnWalletChanged();
            if (this.hardSaveOnNextBlock) {
                this.saveNow();
                this.hardSaveOnNextBlock = false;
            } else {
                this.saveLater();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processTxFromBestChain(Transaction tx, boolean forceAddToPool) throws VerificationException {
        boolean isDeadCoinbase;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((!this.pending.containsKey(tx.getTxId()) ? 1 : 0) != 0);
        boolean bl = isDeadCoinbase = tx.isCoinBase() && this.dead.containsKey(tx.getTxId());
        if (isDeadCoinbase) {
            log.info("  coinbase tx <-dead: confidence {}", (Object)tx.getTxId(), (Object)tx.getConfidence().getConfidenceType().name());
            this.dead.remove(tx.getTxId());
        }
        this.updateForSpends(tx, true);
        boolean hasOutputsToMe = tx.getValueSentToMe(this).signum() > 0;
        boolean hasOutputsFromMe = false;
        if (hasOutputsToMe) {
            if (tx.isEveryOwnedOutputSpent(this)) {
                log.info("  tx {} ->spent (by pending)", (Object)tx.getTxId());
                this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
            } else {
                log.info("  tx {} ->unspent", (Object)tx.getTxId());
                this.addWalletTransaction(WalletTransaction.Pool.UNSPENT, tx);
            }
        } else if (tx.getValueSentFromMe(this).signum() > 0) {
            hasOutputsFromMe = true;
            log.info("  tx {} ->spent", (Object)tx.getTxId());
            this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
        } else if (forceAddToPool) {
            log.info("  tx {} ->spent (manually added)", (Object)tx.getTxId());
            this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
        }
        Set<Transaction> doubleSpendTxns = this.findDoubleSpendsAgainst(tx, this.pending);
        if (!doubleSpendTxns.isEmpty()) {
            this.killTxns(doubleSpendTxns, tx);
        }
        if (!(hasOutputsToMe || hasOutputsFromMe || forceAddToPool || this.findDoubleSpendsAgainst(tx, this.transactions).isEmpty())) {
            for (TransactionInput input : tx.getInputs()) {
                TransactionOutput output = input.getConnectedOutput();
                if (output == null || output.isMineOrWatched(this)) continue;
                input.disconnect();
            }
        }
    }

    private void updateForSpends(Transaction tx, boolean fromChain) throws VerificationException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (fromChain) {
            Preconditions.checkState((!this.pending.containsKey(tx.getTxId()) ? 1 : 0) != 0);
        }
        for (TransactionInput input : tx.getInputs()) {
            TransactionInput.ConnectionResult result = input.connect(this.unspent, TransactionInput.ConnectMode.ABORT_ON_CONFLICT);
            if (result == TransactionInput.ConnectionResult.NO_SUCH_TX && (result = input.connect(this.spent, TransactionInput.ConnectMode.ABORT_ON_CONFLICT)) == TransactionInput.ConnectionResult.NO_SUCH_TX && (result = input.connect(this.pending, TransactionInput.ConnectMode.ABORT_ON_CONFLICT)) == TransactionInput.ConnectionResult.NO_SUCH_TX) continue;
            TransactionOutput output = (TransactionOutput)Preconditions.checkNotNull((Object)input.getConnectedOutput());
            if (result == TransactionInput.ConnectionResult.ALREADY_SPENT) {
                if (fromChain) continue;
                log.warn("Saw two pending transactions double spend each other");
                log.warn("  offending input is input {}", (Object)tx.getInputs().indexOf(input));
                log.warn("{}: {}", (Object)tx.getTxId(), (Object)tx.toHexString());
                Transaction other = output.getSpentBy().getParentTransaction();
                log.warn("{}: {}", (Object)other.getTxId(), (Object)other.toHexString());
                continue;
            }
            if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
            Transaction connected = (Transaction)Preconditions.checkNotNull((Object)input.getConnectedTransaction());
            log.info("  marked {} as spent by {}", (Object)input.getOutpoint(), (Object)tx.getTxId());
            this.maybeMovePool(connected, "prevtx");
            if (!output.isMineOrWatched(this)) continue;
            Preconditions.checkState((boolean)this.myUnspents.remove(output));
        }
        for (Transaction pendingTx : this.pending.values()) {
            for (TransactionInput input : pendingTx.getInputs()) {
                TransactionInput.ConnectionResult result = input.connect(tx, TransactionInput.ConnectMode.ABORT_ON_CONFLICT);
                if (fromChain) {
                    Preconditions.checkState((result != TransactionInput.ConnectionResult.ALREADY_SPENT ? 1 : 0) != 0);
                }
                if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
                log.info("Connected pending tx input {}:{}", (Object)pendingTx.getTxId(), (Object)pendingTx.getInputs().indexOf(input));
                if (!this.myUnspents.remove(input.getConnectedOutput())) continue;
                log.info("Removed from UNSPENTS: {}", (Object)input.getConnectedOutput());
            }
        }
        if (!fromChain) {
            this.maybeMovePool(tx, "pendingtx");
        }
    }

    private void killTxns(Set<Transaction> txnsToKill, @Nullable Transaction overridingTx) {
        LinkedList<Transaction> work = new LinkedList<Transaction>(txnsToKill);
        while (!work.isEmpty()) {
            ChildMessage connected;
            Transaction tx = work.poll();
            log.warn("TX {} killed{}", (Object)tx.getTxId(), (Object)(overridingTx != null ? " by " + overridingTx.getTxId() : ""));
            log.warn("Disconnecting each input and moving connected transactions.");
            this.pending.remove(tx.getTxId());
            this.unspent.remove(tx.getTxId());
            this.spent.remove(tx.getTxId());
            this.addWalletTransaction(WalletTransaction.Pool.DEAD, tx);
            for (TransactionInput deadInput : tx.getInputs()) {
                connected = deadInput.getConnectedTransaction();
                if (connected == null) continue;
                if (((Transaction)connected).getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.DEAD && deadInput.getConnectedOutput().getSpentBy() != null && deadInput.getConnectedOutput().getSpentBy().equals(deadInput)) {
                    Preconditions.checkState((boolean)this.myUnspents.add(deadInput.getConnectedOutput()));
                    log.info("Added to UNSPENTS: {} in {}", (Object)deadInput.getConnectedOutput(), (Object)deadInput.getConnectedOutput().getParentTransaction().getTxId());
                }
                deadInput.disconnect();
                this.maybeMovePool((Transaction)connected, "kill");
            }
            tx.getConfidence().setOverridingTransaction(overridingTx);
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
            for (TransactionOutput deadOutput : tx.getOutputs()) {
                if (this.myUnspents.remove(deadOutput)) {
                    log.info("XX Removed from UNSPENTS: {}", (Object)deadOutput);
                }
                if ((connected = deadOutput.getSpentBy()) == null) continue;
                Transaction parentTransaction = ((TransactionInput)connected).getParentTransaction();
                log.info("This death invalidated dependent tx {}", (Object)parentTransaction.getTxId());
                work.push(parentTransaction);
            }
        }
        if (overridingTx == null) {
            return;
        }
        log.warn("Now attempting to connect the inputs of the overriding transaction.");
        for (TransactionInput input : overridingTx.getInputs()) {
            TransactionInput.ConnectionResult result = input.connect(this.unspent, TransactionInput.ConnectMode.DISCONNECT_ON_CONFLICT);
            if (result == TransactionInput.ConnectionResult.SUCCESS) {
                this.maybeMovePool(input.getConnectedTransaction(), "kill");
                this.myUnspents.remove(input.getConnectedOutput());
                log.info("Removing from UNSPENTS: {}", (Object)input.getConnectedOutput());
                continue;
            }
            result = input.connect(this.spent, TransactionInput.ConnectMode.DISCONNECT_ON_CONFLICT);
            if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
            this.maybeMovePool(input.getConnectedTransaction(), "kill");
            this.myUnspents.remove(input.getConnectedOutput());
            log.info("Removing from UNSPENTS: {}", (Object)input.getConnectedOutput());
        }
    }

    private void maybeMovePool(Transaction tx, String context) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (tx.isEveryOwnedOutputSpent(this)) {
            if (this.unspent.remove(tx.getTxId()) != null) {
                if (log.isInfoEnabled()) {
                    log.info("  {} {} <-unspent ->spent", (Object)tx.getTxId(), (Object)context);
                }
                this.spent.put(tx.getTxId(), tx);
            }
        } else if (this.spent.remove(tx.getTxId()) != null) {
            if (log.isInfoEnabled()) {
                log.info("  {} {} <-spent ->unspent", (Object)tx.getTxId(), (Object)context);
            }
            this.unspent.put(tx.getTxId(), tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeCommitTx(Transaction tx) throws VerificationException {
        tx.verify();
        this.lock.lock();
        try {
            if (this.pending.containsKey(tx.getTxId())) {
                boolean bl = false;
                return bl;
            }
            log.info("commitTx of {}", (Object)tx.getTxId());
            Coin balance = this.getBalance();
            tx.setUpdateTime(Utils.now());
            Coin valueSentToMe = Coin.ZERO;
            for (TransactionOutput o : tx.getOutputs()) {
                if (!o.isMineOrWatched(this)) continue;
                valueSentToMe = valueSentToMe.add(o.getValue());
            }
            this.updateForSpends(tx, false);
            Set<Transaction> doubleSpendPendingTxns = this.findDoubleSpendsAgainst(tx, this.pending);
            Set<Transaction> doubleSpendUnspentTxns = this.findDoubleSpendsAgainst(tx, this.unspent);
            Set<Transaction> doubleSpendSpentTxns = this.findDoubleSpendsAgainst(tx, this.spent);
            if (!(doubleSpendUnspentTxns.isEmpty() && doubleSpendSpentTxns.isEmpty() && this.isNotSpendingTxnsInConfidenceType(tx, TransactionConfidence.ConfidenceType.DEAD))) {
                log.info("->dead: {}", (Object)tx.getTxId());
                tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.DEAD);
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
                this.addWalletTransaction(WalletTransaction.Pool.DEAD, tx);
            } else if (!doubleSpendPendingTxns.isEmpty() || !this.isNotSpendingTxnsInConfidenceType(tx, TransactionConfidence.ConfidenceType.IN_CONFLICT)) {
                log.info("->pending (IN_CONFLICT): {}", (Object)tx.getTxId());
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
                doubleSpendPendingTxns.add(tx);
                this.addTransactionsDependingOn(doubleSpendPendingTxns, this.getTransactions(true));
                for (Transaction doubleSpendTx : doubleSpendPendingTxns) {
                    doubleSpendTx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.IN_CONFLICT);
                    this.confidenceChanged.put(doubleSpendTx, TransactionConfidence.Listener.ChangeReason.TYPE);
                }
            } else {
                log.info("->pending: {}", (Object)tx.getTxId());
                tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
            }
            if (log.isInfoEnabled()) {
                log.info("Estimated balance is now: {}", (Object)this.getBalance(BalanceType.ESTIMATED).toFriendlyString());
            }
            this.markKeysAsUsed(tx);
            try {
                Coin valueSentFromMe = tx.getValueSentFromMe(this);
                Coin newBalance = balance.add(valueSentToMe).subtract(valueSentFromMe);
                if (valueSentToMe.signum() > 0) {
                    this.checkBalanceFuturesLocked(null);
                    this.queueOnCoinsReceived(tx, balance, newBalance);
                }
                if (valueSentFromMe.signum() > 0) {
                    this.queueOnCoinsSent(tx, balance, newBalance);
                }
                this.maybeQueueOnWalletChanged();
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
            this.isConsistentOrThrow();
            this.informConfidenceListenersIfNotReorganizing();
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public void commitTx(Transaction tx) throws VerificationException {
        Preconditions.checkArgument((boolean)this.maybeCommitTx(tx), (Object)"commitTx called on the same transaction twice");
    }

    public void addChangeEventListener(WalletChangeEventListener listener) {
        this.addChangeEventListener(Threading.USER_THREAD, listener);
    }

    public void addChangeEventListener(Executor executor, WalletChangeEventListener listener) {
        this.changeListeners.add(new ListenerRegistration<WalletChangeEventListener>(listener, executor));
    }

    public void addCoinsReceivedEventListener(WalletCoinsReceivedEventListener listener) {
        this.addCoinsReceivedEventListener(Threading.USER_THREAD, listener);
    }

    public void addCoinsReceivedEventListener(Executor executor, WalletCoinsReceivedEventListener listener) {
        this.coinsReceivedListeners.add(new ListenerRegistration<WalletCoinsReceivedEventListener>(listener, executor));
    }

    public void addCoinsSentEventListener(WalletCoinsSentEventListener listener) {
        this.addCoinsSentEventListener(Threading.USER_THREAD, listener);
    }

    public void addCoinsSentEventListener(Executor executor, WalletCoinsSentEventListener listener) {
        this.coinsSentListeners.add(new ListenerRegistration<WalletCoinsSentEventListener>(listener, executor));
    }

    public void addKeyChainEventListener(KeyChainEventListener listener) {
        this.keyChainGroup.addEventListener(listener, Threading.USER_THREAD);
    }

    public void addKeyChainEventListener(Executor executor, KeyChainEventListener listener) {
        this.keyChainGroup.addEventListener(listener, executor);
    }

    public void addCurrentKeyChangeEventListener(CurrentKeyChangeEventListener listener) {
        this.keyChainGroup.addCurrentKeyChangeEventListener(listener);
    }

    public void addCurrentKeyChangeEventListener(Executor executor, CurrentKeyChangeEventListener listener) {
        this.keyChainGroup.addCurrentKeyChangeEventListener(listener, executor);
    }

    public void addReorganizeEventListener(WalletReorganizeEventListener listener) {
        this.addReorganizeEventListener(Threading.USER_THREAD, listener);
    }

    public void addReorganizeEventListener(Executor executor, WalletReorganizeEventListener listener) {
        this.reorganizeListeners.add(new ListenerRegistration<WalletReorganizeEventListener>(listener, executor));
    }

    public void addScriptsChangeEventListener(ScriptsChangeEventListener listener) {
        this.addScriptsChangeEventListener(Threading.USER_THREAD, listener);
    }

    public void addScriptsChangeEventListener(Executor executor, ScriptsChangeEventListener listener) {
        this.scriptsChangeListeners.add(new ListenerRegistration<ScriptsChangeEventListener>(listener, executor));
    }

    public void addTransactionConfidenceEventListener(TransactionConfidenceEventListener listener) {
        this.addTransactionConfidenceEventListener(Threading.USER_THREAD, listener);
    }

    public void addTransactionConfidenceEventListener(Executor executor, TransactionConfidenceEventListener listener) {
        this.transactionConfidenceListeners.add(new ListenerRegistration<TransactionConfidenceEventListener>(listener, executor));
    }

    public boolean removeChangeEventListener(WalletChangeEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.changeListeners);
    }

    public boolean removeCoinsReceivedEventListener(WalletCoinsReceivedEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.coinsReceivedListeners);
    }

    public boolean removeCoinsSentEventListener(WalletCoinsSentEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.coinsSentListeners);
    }

    public boolean removeKeyChainEventListener(KeyChainEventListener listener) {
        return this.keyChainGroup.removeEventListener(listener);
    }

    public boolean removeCurrentKeyChangeEventListener(CurrentKeyChangeEventListener listener) {
        return this.keyChainGroup.removeCurrentKeyChangeEventListener(listener);
    }

    public boolean removeReorganizeEventListener(WalletReorganizeEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.reorganizeListeners);
    }

    public boolean removeScriptsChangeEventListener(ScriptsChangeEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.scriptsChangeListeners);
    }

    public boolean removeTransactionConfidenceEventListener(TransactionConfidenceEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.transactionConfidenceListeners);
    }

    private void queueOnTransactionConfidenceChanged(final Transaction tx) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<TransactionConfidenceEventListener> registration : this.transactionConfidenceListeners) {
            if (registration.executor == Threading.SAME_THREAD) {
                ((TransactionConfidenceEventListener)registration.listener).onTransactionConfidenceChanged(this, tx);
                continue;
            }
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((TransactionConfidenceEventListener)registration.listener).onTransactionConfidenceChanged(Wallet.this, tx);
                }
            });
        }
    }

    protected void maybeQueueOnWalletChanged() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((this.onWalletChangedSuppressions >= 0 ? 1 : 0) != 0);
        if (this.onWalletChangedSuppressions > 0) {
            return;
        }
        for (final ListenerRegistration<WalletChangeEventListener> registration : this.changeListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletChangeEventListener)registration.listener).onWalletChanged(Wallet.this);
                }
            });
        }
    }

    protected void queueOnCoinsReceived(final Transaction tx, final Coin balance, final Coin newBalance) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletCoinsReceivedEventListener> registration : this.coinsReceivedListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletCoinsReceivedEventListener)registration.listener).onCoinsReceived(Wallet.this, tx, balance, newBalance);
                }
            });
        }
    }

    protected void queueOnCoinsSent(final Transaction tx, final Coin prevBalance, final Coin newBalance) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletCoinsSentEventListener> registration : this.coinsSentListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletCoinsSentEventListener)registration.listener).onCoinsSent(Wallet.this, tx, prevBalance, newBalance);
                }
            });
        }
    }

    protected void queueOnReorganize() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((boolean)this.insideReorg);
        for (final ListenerRegistration<WalletReorganizeEventListener> registration : this.reorganizeListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletReorganizeEventListener)registration.listener).onReorganize(Wallet.this);
                }
            });
        }
    }

    protected void queueOnScriptsChanged(final List<Script> scripts, final boolean isAddingScripts) {
        for (final ListenerRegistration<ScriptsChangeEventListener> registration : this.scriptsChangeListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((ScriptsChangeEventListener)registration.listener).onScriptsChanged(Wallet.this, scripts, isAddingScripts);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Transaction> getTransactions(boolean includeDead) {
        this.lock.lock();
        try {
            HashSet<Transaction> all = new HashSet<Transaction>();
            all.addAll(this.unspent.values());
            all.addAll(this.spent.values());
            all.addAll(this.pending.values());
            if (includeDead) {
                all.addAll(this.dead.values());
            }
            HashSet<Transaction> hashSet = all;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Iterable<WalletTransaction> getWalletTransactions() {
        this.lock.lock();
        try {
            HashSet<WalletTransaction> all = new HashSet<WalletTransaction>();
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.UNSPENT, this.unspent.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.SPENT, this.spent.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.DEAD, this.dead.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.PENDING, this.pending.values());
            HashSet<WalletTransaction> hashSet = all;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void addWalletTransactionsToSet(Set<WalletTransaction> txns, WalletTransaction.Pool poolType, Collection<Transaction> pool) {
        for (Transaction tx : pool) {
            txns.add(new WalletTransaction(poolType, tx));
        }
    }

    public void addWalletTransaction(WalletTransaction wtx) {
        this.lock.lock();
        try {
            this.addWalletTransaction(wtx.getPool(), wtx.getTransaction());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addWalletTransaction(WalletTransaction.Pool pool, Transaction tx) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        this.transactions.put(tx.getTxId(), tx);
        switch (pool) {
            case UNSPENT: {
                Preconditions.checkState((this.unspent.put(tx.getTxId(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case SPENT: {
                Preconditions.checkState((this.spent.put(tx.getTxId(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case PENDING: {
                Preconditions.checkState((this.pending.put(tx.getTxId(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case DEAD: {
                Preconditions.checkState((this.dead.put(tx.getTxId(), tx) == null ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new RuntimeException("Unknown wallet transaction type " + (Object)((Object)pool));
            }
        }
        if (pool == WalletTransaction.Pool.UNSPENT || pool == WalletTransaction.Pool.PENDING) {
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.isAvailableForSpending() || !output.isMineOrWatched(this)) continue;
                this.myUnspents.add(output);
            }
        }
        tx.getConfidence().addEventListener(Threading.SAME_THREAD, this.txConfidenceListener);
    }

    public List<Transaction> getTransactionsByTime() {
        return this.getRecentTransactions(0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getRecentTransactions(int numTransactions, boolean includeDead) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((numTransactions >= 0 ? 1 : 0) != 0);
            int size = this.unspent.size() + this.spent.size() + this.pending.size();
            if (numTransactions > size || numTransactions == 0) {
                numTransactions = size;
            }
            ArrayList<Transaction> all = new ArrayList<Transaction>(this.getTransactions(includeDead));
            Collections.sort(all, Transaction.SORT_TX_BY_UPDATE_TIME);
            if (numTransactions == all.size()) {
                ArrayList<Transaction> arrayList = all;
                return arrayList;
            }
            all.subList(numTransactions, all.size()).clear();
            ArrayList<Transaction> arrayList = all;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Transaction getTransaction(Sha256Hash hash) {
        this.lock.lock();
        try {
            Transaction transaction = this.transactions.get(hash);
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<Sha256Hash, Transaction> getTransactionPool(WalletTransaction.Pool pool) {
        this.lock.lock();
        try {
            switch (pool) {
                case UNSPENT: {
                    Map<Sha256Hash, Transaction> map = this.unspent;
                    return map;
                }
                case SPENT: {
                    Map<Sha256Hash, Transaction> map = this.spent;
                    return map;
                }
                case PENDING: {
                    Map<Sha256Hash, Transaction> map = this.pending;
                    return map;
                }
                case DEAD: {
                    Map<Sha256Hash, Transaction> map = this.dead;
                    return map;
                }
            }
            throw new RuntimeException("Unknown wallet transaction type " + (Object)((Object)pool));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.clearTransactions();
            this.lastBlockSeenHash = null;
            this.lastBlockSeenHeight = -1;
            this.lastBlockSeenTimeSecs = 0L;
            this.saveLater();
            this.maybeQueueOnWalletChanged();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearTransactions(int fromHeight) {
        block4: {
            this.lock.lock();
            try {
                if (fromHeight == 0) {
                    this.clearTransactions();
                    this.saveLater();
                    break block4;
                }
                throw new UnsupportedOperationException();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void clearTransactions() {
        this.unspent.clear();
        this.spent.clear();
        this.pending.clear();
        this.dead.clear();
        this.transactions.clear();
        this.myUnspents.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionOutput> getWatchedOutputs(boolean excludeImmatureCoinbases) {
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            LinkedList<TransactionOutput> candidates = new LinkedList<TransactionOutput>();
            for (Transaction tx : Iterables.concat(this.unspent.values(), this.pending.values())) {
                if (excludeImmatureCoinbases && !tx.isMature()) continue;
                for (TransactionOutput output : tx.getOutputs()) {
                    if (!output.isAvailableForSpending()) continue;
                    try {
                        Script scriptPubKey = output.getScriptPubKey();
                        if (!this.watchedScripts.contains(scriptPubKey)) continue;
                        candidates.add(output);
                    }
                    catch (ScriptException scriptException) {}
                }
            }
            LinkedList<TransactionOutput> linkedList = candidates;
            return linkedList;
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.lock.lock();
        try {
            boolean dirty = false;
            Iterator<Transaction> i = this.pending.values().iterator();
            while (i.hasNext()) {
                Transaction tx = i.next();
                if (!this.isTransactionRisky(tx, null) || this.acceptRiskyTransactions) continue;
                log.debug("Found risky transaction {} in wallet during cleanup.", (Object)tx.getTxId());
                if (!tx.isAnyOutputSpent()) {
                    for (TransactionInput input : tx.getInputs()) {
                        TransactionOutput output = input.getConnectedOutput();
                        if (output == null) continue;
                        if (output.isMineOrWatched(this)) {
                            Preconditions.checkState((boolean)this.myUnspents.add(output));
                        }
                        input.disconnect();
                    }
                    for (TransactionOutput output : tx.getOutputs()) {
                        this.myUnspents.remove(output);
                    }
                    i.remove();
                    this.transactions.remove(tx.getTxId());
                    dirty = true;
                    log.info("Removed transaction {} from pending pool during cleanup.", (Object)tx.getTxId());
                    continue;
                }
                log.info("Cannot remove transaction {} from pending pool during cleanup, as it's already spent partially.", (Object)tx.getTxId());
            }
            if (dirty) {
                this.isConsistentOrThrow();
                this.saveLater();
                if (log.isInfoEnabled()) {
                    log.info("Estimated balance is now: {}", (Object)this.getBalance(BalanceType.ESTIMATED).toFriendlyString());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnumSet<WalletTransaction.Pool> getContainingPools(Transaction tx) {
        this.lock.lock();
        try {
            EnumSet<WalletTransaction.Pool> result = EnumSet.noneOf(WalletTransaction.Pool.class);
            Sha256Hash txHash = tx.getTxId();
            if (this.unspent.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.UNSPENT);
            }
            if (this.spent.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.SPENT);
            }
            if (this.pending.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.PENDING);
            }
            if (this.dead.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.DEAD);
            }
            EnumSet<WalletTransaction.Pool> enumSet = result;
            return enumSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    public int getPoolSize(WalletTransaction.Pool pool) {
        this.lock.lock();
        try {
            switch (pool) {
                case UNSPENT: {
                    int n = this.unspent.size();
                    return n;
                }
                case SPENT: {
                    int n = this.spent.size();
                    return n;
                }
                case PENDING: {
                    int n = this.pending.size();
                    return n;
                }
                case DEAD: {
                    int n = this.dead.size();
                    return n;
                }
            }
            throw new RuntimeException("Unreachable");
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    public boolean poolContainsTxHash(WalletTransaction.Pool pool, Sha256Hash txHash) {
        this.lock.lock();
        try {
            switch (pool) {
                case UNSPENT: {
                    boolean bl = this.unspent.containsKey(txHash);
                    return bl;
                }
                case SPENT: {
                    boolean bl = this.spent.containsKey(txHash);
                    return bl;
                }
                case PENDING: {
                    boolean bl = this.pending.containsKey(txHash);
                    return bl;
                }
                case DEAD: {
                    boolean bl = this.dead.containsKey(txHash);
                    return bl;
                }
            }
            throw new RuntimeException("Unreachable");
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<TransactionOutput> getUnspents() {
        this.lock.lock();
        try {
            ArrayList<TransactionOutput> arrayList = new ArrayList<TransactionOutput>(this.myUnspents);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.toString(false, false, null, true, true, null);
    }

    @Deprecated
    public String toString(boolean includePrivateKeys, boolean includeTransactions, boolean includeExtensions, @Nullable AbstractBlockChain chain) {
        return this.toString(false, includePrivateKeys, null, includeTransactions, includeExtensions, chain);
    }

    @Deprecated
    public String toString(boolean includePrivateKeys, @Nullable KeyParameter aesKey, boolean includeTransactions, boolean includeExtensions, @Nullable AbstractBlockChain chain) {
        return this.toString(false, includePrivateKeys, aesKey, includeTransactions, includeExtensions, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean includeLookahead, boolean includePrivateKeys, @Nullable KeyParameter aesKey, boolean includeTransactions, boolean includeExtensions, @Nullable AbstractBlockChain chain) {
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            StringBuilder builder = new StringBuilder("Wallet\n");
            if (includePrivateKeys) {
                builder.append("  WARNING: includes private keys!\n");
            }
            builder.append("Balances:\n");
            for (BalanceType balanceType : BalanceType.values()) {
                builder.append("  ").append(this.getBalance(balanceType).toFriendlyString()).append(' ').append((Object)balanceType).append('\n');
            }
            builder.append("Transactions:\n");
            builder.append("  ").append(this.pending.size()).append(" pending\n");
            builder.append("  ").append(this.unspent.size()).append(" unspent\n");
            builder.append("  ").append(this.spent.size()).append(" spent\n");
            builder.append("  ").append(this.dead.size()).append(" dead\n");
            Date lastBlockSeenTime = this.getLastBlockSeenTime();
            builder.append("Last seen best block: ").append(this.getLastBlockSeenHeight()).append(" (").append(lastBlockSeenTime == null ? "time unknown" : Utils.dateTimeFormat(lastBlockSeenTime)).append("): ").append(this.getLastBlockSeenHash()).append('\n');
            KeyCrypter crypter = this.keyChainGroup.getKeyCrypter();
            if (crypter != null) {
                builder.append("Encryption: ").append(crypter).append('\n');
            }
            if (this.isWatching()) {
                builder.append("Wallet is watching.\n");
            }
            builder.append("\nKeys:\n");
            builder.append("Earliest creation time: ").append(Utils.dateTimeFormat(this.getEarliestKeyCreationTime() * 1000L)).append('\n');
            Date keyRotationTime = this.getKeyRotationTime();
            if (keyRotationTime != null) {
                builder.append("Key rotation time:      ").append(Utils.dateTimeFormat(keyRotationTime)).append('\n');
            }
            builder.append(this.keyChainGroup.toString(includeLookahead, includePrivateKeys, aesKey));
            if (!this.watchedScripts.isEmpty()) {
                builder.append("\nWatched scripts:\n");
                for (Script script : this.watchedScripts) {
                    builder.append("  ").append(script).append("\n");
                }
            }
            if (includeTransactions) {
                if (this.pending.size() > 0) {
                    builder.append("\n>>> PENDING:\n");
                    this.toStringHelper(builder, this.pending, chain, Transaction.SORT_TX_BY_UPDATE_TIME);
                }
                if (this.unspent.size() > 0) {
                    builder.append("\n>>> UNSPENT:\n");
                    this.toStringHelper(builder, this.unspent, chain, Transaction.SORT_TX_BY_HEIGHT);
                }
                if (this.spent.size() > 0) {
                    builder.append("\n>>> SPENT:\n");
                    this.toStringHelper(builder, this.spent, chain, Transaction.SORT_TX_BY_HEIGHT);
                }
                if (this.dead.size() > 0) {
                    builder.append("\n>>> DEAD:\n");
                    this.toStringHelper(builder, this.dead, chain, Transaction.SORT_TX_BY_UPDATE_TIME);
                }
            }
            if (includeExtensions && this.extensions.size() > 0) {
                builder.append("\n>>> EXTENSIONS:\n");
                for (WalletExtension extension : this.extensions.values()) {
                    builder.append(extension).append("\n\n");
                }
            }
            Iterator<WalletExtension> iterator = builder.toString();
            return iterator;
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
    }

    private void toStringHelper(StringBuilder builder, Map<Sha256Hash, Transaction> transactionMap, @Nullable AbstractBlockChain chain, @Nullable Comparator<Transaction> sortOrder) {
        Collection<Transaction> txns;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (sortOrder != null) {
            txns = new TreeSet<Transaction>(sortOrder);
            txns.addAll(transactionMap.values());
        } else {
            txns = transactionMap.values();
        }
        for (Transaction tx : txns) {
            try {
                builder.append(tx.getValue(this).toFriendlyString());
                builder.append(" total value (sends ");
                builder.append(tx.getValueSentFromMe(this).toFriendlyString());
                builder.append(" and receives ");
                builder.append(tx.getValueSentToMe(this).toFriendlyString());
                builder.append(")\n");
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
            if (tx.hasConfidence()) {
                builder.append("  confidence: ").append(tx.getConfidence()).append('\n');
            }
            builder.append(tx.toString(chain, "  "));
        }
    }

    public Collection<Transaction> getPendingTransactions() {
        this.lock.lock();
        try {
            Collection<Transaction> collection = Collections.unmodifiableCollection(this.pending.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEarliestKeyCreationTime() {
        this.keyChainGroupLock.lock();
        try {
            long earliestTime = this.keyChainGroup.getEarliestKeyCreationTime();
            for (Script script : this.watchedScripts) {
                earliestTime = Math.min(script.getCreationTimeSeconds(), earliestTime);
            }
            if (earliestTime == Long.MAX_VALUE) {
                long l = Utils.currentTimeSeconds();
                return l;
            }
            long l = earliestTime;
            return l;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    @Nullable
    public Sha256Hash getLastBlockSeenHash() {
        this.lock.lock();
        try {
            Sha256Hash sha256Hash = this.lastBlockSeenHash;
            return sha256Hash;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastBlockSeenHash(@Nullable Sha256Hash lastBlockSeenHash) {
        this.lock.lock();
        try {
            this.lastBlockSeenHash = lastBlockSeenHash;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastBlockSeenHeight(int lastBlockSeenHeight) {
        this.lock.lock();
        try {
            this.lastBlockSeenHeight = lastBlockSeenHeight;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLastBlockSeenTimeSecs(long timeSecs) {
        this.lock.lock();
        try {
            this.lastBlockSeenTimeSecs = timeSecs;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getLastBlockSeenTimeSecs() {
        this.lock.lock();
        try {
            long l = this.lastBlockSeenTimeSecs;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Date getLastBlockSeenTime() {
        long secs = this.getLastBlockSeenTimeSecs();
        if (secs == 0L) {
            return null;
        }
        return new Date(secs * 1000L);
    }

    public int getLastBlockSeenHeight() {
        this.lock.lock();
        try {
            int n = this.lastBlockSeenHeight;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Coin getBalance() {
        return this.getBalance(BalanceType.AVAILABLE);
    }

    public Coin getBalance(BalanceType balanceType) {
        this.lock.lock();
        try {
            if (balanceType == BalanceType.AVAILABLE || balanceType == BalanceType.AVAILABLE_SPENDABLE) {
                List<TransactionOutput> candidates = this.calculateAllSpendCandidates(true, balanceType == BalanceType.AVAILABLE_SPENDABLE);
                CoinSelection selection = this.coinSelector.select(NetworkParameters.MAX_MONEY, candidates);
                Coin coin = selection.valueGathered;
                return coin;
            }
            if (balanceType == BalanceType.ESTIMATED || balanceType == BalanceType.ESTIMATED_SPENDABLE) {
                List<TransactionOutput> all = this.calculateAllSpendCandidates(false, balanceType == BalanceType.ESTIMATED_SPENDABLE);
                Coin value = Coin.ZERO;
                for (TransactionOutput out : all) {
                    value = value.add(out.getValue());
                }
                Coin coin = value;
                return coin;
            }
            throw new AssertionError((Object)"Unknown balance type");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coin getBalance(CoinSelector selector) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)selector);
            List<TransactionOutput> candidates = this.calculateAllSpendCandidates(true, false);
            CoinSelection selection = selector.select(this.params.getMaxMoney(), candidates);
            Coin coin = selection.valueGathered;
            return coin;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Coin> getBalanceFuture(Coin value, BalanceType type) {
        this.lock.lock();
        try {
            SettableFuture future = SettableFuture.create();
            Coin current = this.getBalance(type);
            if (current.compareTo(value) >= 0) {
                future.set((Object)current);
            } else {
                BalanceFutureRequest req = new BalanceFutureRequest();
                req.future = future;
                req.value = value;
                req.type = type;
                this.balanceFutureRequests.add(req);
            }
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkBalanceFuturesLocked(@Nullable Coin avail) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        ListIterator<BalanceFutureRequest> it = this.balanceFutureRequests.listIterator();
        while (it.hasNext()) {
            final BalanceFutureRequest req = it.next();
            Coin val = this.getBalance(req.type);
            if (val.compareTo(req.value) < 0) continue;
            it.remove();
            final Coin v = val;
            Threading.USER_THREAD.execute(new Runnable(){

                @Override
                public void run() {
                    req.future.set((Object)v);
                }
            });
        }
    }

    public Coin getTotalReceived() {
        Coin total = Coin.ZERO;
        for (Transaction tx : this.transactions.values()) {
            Coin txTotal = Coin.ZERO;
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.isMine(this)) continue;
                txTotal = txTotal.add(output.getValue());
            }
            for (TransactionInput in : tx.getInputs()) {
                TransactionOutput prevOut = in.getConnectedOutput();
                if (prevOut == null || !prevOut.isMine(this)) continue;
                txTotal = txTotal.subtract(prevOut.getValue());
            }
            if (!txTotal.isPositive()) continue;
            total = total.add(txTotal);
        }
        return total;
    }

    public Coin getTotalSent() {
        Coin total = Coin.ZERO;
        for (Transaction tx : this.transactions.values()) {
            Coin txOutputTotal = Coin.ZERO;
            for (TransactionOutput transactionOutput : tx.getOutputs()) {
                if (transactionOutput.isMine(this)) continue;
                txOutputTotal = txOutputTotal.add(transactionOutput.getValue());
            }
            Coin txOwnedInputsTotal = Coin.ZERO;
            for (TransactionInput in : tx.getInputs()) {
                TransactionOutput prevOut = in.getConnectedOutput();
                if (prevOut == null || !prevOut.isMine(this)) continue;
                txOwnedInputsTotal = txOwnedInputsTotal.add(prevOut.getValue());
            }
            Coin coin = tx.getInputSum();
            if (txOwnedInputsTotal != coin) {
                BigInteger txOutputTotalNum = new BigInteger(txOutputTotal.toString());
                txOutputTotalNum = txOutputTotalNum.multiply(new BigInteger(txOwnedInputsTotal.toString()));
                txOutputTotalNum = txOutputTotalNum.divide(new BigInteger(coin.toString()));
                txOutputTotal = Coin.valueOf(txOutputTotalNum.longValue());
            }
            total = total.add(txOutputTotal);
        }
        return total;
    }

    public Transaction createSend(Address address, Coin value) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        return this.createSend(address, value, false);
    }

    public Transaction createSend(Address address, Coin value, boolean allowUnconfirmed) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        SendRequest req = SendRequest.to(address, value);
        if (this.params.getId().equals("org.bitcoinj.unittest")) {
            req.shuffleOutputs = false;
        }
        if (allowUnconfirmed) {
            req.allowUnconfirmed();
        }
        this.completeTx(req);
        return req.tx;
    }

    public Transaction sendCoinsOffline(SendRequest request) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        this.lock.lock();
        try {
            this.completeTx(request);
            this.commitTx(request.tx);
            Transaction transaction = request.tx;
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SendResult sendCoins(TransactionBroadcaster broadcaster, Address to, Coin value) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        SendRequest request = SendRequest.to(to, value);
        return this.sendCoins(broadcaster, request);
    }

    public SendResult sendCoins(TransactionBroadcaster broadcaster, SendRequest request) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        Preconditions.checkState((!this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
        Transaction tx = this.sendCoinsOffline(request);
        SendResult result = new SendResult(tx, broadcaster.broadcastTransaction(tx));
        return result;
    }

    public SendResult sendCoins(SendRequest request) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        TransactionBroadcaster broadcaster = this.vTransactionBroadcaster;
        Preconditions.checkState((broadcaster != null ? 1 : 0) != 0, (Object)"No transaction broadcaster is configured");
        return this.sendCoins(broadcaster, request);
    }

    public Transaction sendCoins(Peer peer, SendRequest request) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        Transaction tx = this.sendCoinsOffline(request);
        peer.sendMessage(tx);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeTx(SendRequest req) throws InsufficientMoneyException, BadWalletEncryptionKeyException {
        this.lock.lock();
        try {
            int size;
            CoinSelection bestCoinSelection;
            Preconditions.checkArgument((!req.completed ? 1 : 0) != 0, (Object)"Given SendRequest has already been completed.");
            Coin value = Coin.ZERO;
            for (TransactionOutput transactionOutput : req.tx.getOutputs()) {
                value = value.add(transactionOutput.getValue());
            }
            log.info("Completing send tx with {} outputs totalling {} and a fee of {}/vkB", new Object[]{req.tx.getOutputs().size(), value.toFriendlyString(), req.feePerKb.toFriendlyString()});
            Coin totalInput = Coin.ZERO;
            for (TransactionInput input : req.tx.getInputs()) {
                if (input.getConnectedOutput() != null) {
                    totalInput = totalInput.add(input.getConnectedOutput().getValue());
                    continue;
                }
                log.warn("SendRequest transaction already has inputs but we don't know how much they are worth - they will be added to fee.");
            }
            value = value.subtract(totalInput);
            ArrayList<TransactionInput> arrayList = new ArrayList<TransactionInput>(req.tx.getInputs());
            if (req.ensureMinRequiredFee && !req.emptyWallet) {
                int opReturnCount = 0;
                for (TransactionOutput output : req.tx.getOutputs()) {
                    if (output.isDust()) {
                        throw new DustySendRequested();
                    }
                    if (!ScriptPattern.isOpReturn(output.getScriptPubKey())) continue;
                    ++opReturnCount;
                }
                if (opReturnCount > 1) {
                    throw new MultipleOpReturnRequested();
                }
            }
            List<TransactionOutput> candidates = this.calculateAllSpendCandidates(true, req.missingSigsMode == MissingSigsMode.THROW);
            TransactionOutput bestChangeOutput = null;
            List<Coin> updatedOutputValues = null;
            if (!req.emptyWallet) {
                FeeCalculation feeCalculation = this.calculateFee(req, value, arrayList, req.ensureMinRequiredFee, candidates);
                bestCoinSelection = feeCalculation.bestCoinSelection;
                bestChangeOutput = feeCalculation.bestChangeOutput;
                updatedOutputValues = feeCalculation.updatedOutputValues;
            } else {
                Preconditions.checkState((req.tx.getOutputs().size() == 1 ? 1 : 0) != 0, (Object)"Empty wallet TX must have a single output only.");
                CoinSelector selector = req.coinSelector == null ? this.coinSelector : req.coinSelector;
                bestCoinSelection = selector.select(this.params.getMaxMoney(), candidates);
                candidates = null;
                req.tx.getOutput(0L).setValue(bestCoinSelection.valueGathered);
                log.info("  emptying {}", (Object)bestCoinSelection.valueGathered.toFriendlyString());
            }
            for (TransactionOutput output : bestCoinSelection.gathered) {
                req.tx.addInput(output);
            }
            if (req.emptyWallet && !this.adjustOutputDownwardsForFee(req.tx, bestCoinSelection, req.feePerKb, req.ensureMinRequiredFee)) {
                throw new CouldNotAdjustDownwards();
            }
            if (updatedOutputValues != null) {
                for (int i = 0; i < updatedOutputValues.size(); ++i) {
                    req.tx.getOutput(i).setValue(updatedOutputValues.get(i));
                }
            }
            if (bestChangeOutput != null) {
                req.tx.addOutput(bestChangeOutput);
                log.info("  with {} change", (Object)bestChangeOutput.getValue().toFriendlyString());
            }
            if (req.shuffleOutputs) {
                req.tx.shuffleOutputs();
            }
            if (req.signInputs) {
                this.signTransaction(req);
            }
            if ((size = req.tx.unsafeBitcoinSerialize().length) > 100000) {
                throw new ExceededMaxTransactionSize();
            }
            req.tx.getConfidence().setSource(TransactionConfidence.Source.SELF);
            req.tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
            req.tx.setExchangeRate(req.exchangeRate);
            req.tx.setMemo(req.memo);
            req.completed = true;
            log.info("  completed: {}", (Object)req.tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signTransaction(SendRequest req) throws BadWalletEncryptionKeyException {
        this.lock.lock();
        try {
            Transaction tx = req.tx;
            List<TransactionInput> inputs = tx.getInputs();
            List<TransactionOutput> outputs = tx.getOutputs();
            Preconditions.checkState((inputs.size() > 0 ? 1 : 0) != 0);
            Preconditions.checkState((outputs.size() > 0 ? 1 : 0) != 0);
            DecryptingKeyBag maybeDecryptingKeyBag = new DecryptingKeyBag(this, req.aesKey);
            int numInputs = tx.getInputs().size();
            for (int i = 0; i < numInputs; ++i) {
                TransactionInput txIn = tx.getInput(i);
                TransactionOutput connectedOutput = txIn.getConnectedOutput();
                if (connectedOutput == null) continue;
                Script scriptPubKey = connectedOutput.getScriptPubKey();
                try {
                    txIn.getScriptSig().correctlySpends(tx, i, txIn.getWitness(), connectedOutput.getValue(), connectedOutput.getScriptPubKey(), Script.ALL_VERIFY_FLAGS);
                    log.warn("Input {} already correctly spends output, assuming SIGHASH type used will be safe and skipping signing.", (Object)i);
                    continue;
                }
                catch (ScriptException e) {
                    log.debug("Input contained an incorrect signature", (Throwable)e);
                    RedeemData redeemData = txIn.getConnectedRedeemData(maybeDecryptingKeyBag);
                    Preconditions.checkNotNull((Object)redeemData, (String)"Transaction exists in wallet that we cannot redeem: %s", (Object)txIn.getOutpoint().getHash());
                    txIn.setScriptSig(scriptPubKey.createEmptyInputScript(redeemData.keys.get(0), redeemData.redeemScript));
                    txIn.setWitness(scriptPubKey.createEmptyWitness(redeemData.keys.get(0)));
                }
            }
            TransactionSigner.ProposedTransaction proposal = new TransactionSigner.ProposedTransaction(tx);
            for (TransactionSigner signer : this.signers) {
                if (signer.signInputs(proposal, maybeDecryptingKeyBag)) continue;
                log.info("{} returned false for the tx", (Object)signer.getClass().getName());
            }
            new MissingSigResolutionSigner(req.missingSigsMode).signInputs(proposal, maybeDecryptingKeyBag);
        }
        catch (KeyCrypterException.InvalidCipherText | KeyCrypterException.PublicPrivateMismatch e) {
            throw new BadWalletEncryptionKeyException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean adjustOutputDownwardsForFee(Transaction tx, CoinSelection coinSelection, Coin feePerKb, boolean ensureMinRequiredFee) {
        if (ensureMinRequiredFee && feePerKb.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
            feePerKb = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
        }
        int vsize = tx.getVsize() + this.estimateVirtualBytesForSigning(coinSelection);
        Coin fee = feePerKb.multiply(vsize).divide(1000L);
        TransactionOutput output = tx.getOutput(0L);
        output.setValue(output.getValue().subtract(fee));
        return !output.isDust();
    }

    public List<TransactionOutput> calculateAllSpendCandidates() {
        return this.calculateAllSpendCandidates(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransactionOutput> calculateAllSpendCandidates(boolean excludeImmatureCoinbases, boolean excludeUnsignable) {
        this.lock.lock();
        try {
            AbstractList candidates;
            if (this.vUTXOProvider == null) {
                candidates = new ArrayList(this.myUnspents.size());
                for (TransactionOutput output : this.myUnspents) {
                    if (excludeUnsignable && !this.canSignFor(output.getScriptPubKey())) continue;
                    Transaction transaction = (Transaction)Preconditions.checkNotNull((Object)output.getParentTransaction());
                    if (excludeImmatureCoinbases && !transaction.isMature()) continue;
                    candidates.add((TransactionOutput)output);
                }
            } else {
                candidates = this.calculateAllSpendCandidatesFromUTXOProvider(excludeImmatureCoinbases);
            }
            AbstractList abstractList = candidates;
            return abstractList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean canSignFor(Script script) {
        if (ScriptPattern.isP2PK(script)) {
            byte[] pubkey = ScriptPattern.extractKeyFromP2PK(script);
            ECKey key = this.findKeyFromPubKey(pubkey);
            return key != null && (key.isEncrypted() || key.hasPrivKey());
        }
        if (ScriptPattern.isP2SH(script)) {
            RedeemData data = this.findRedeemDataFromScriptHash(ScriptPattern.extractHashFromP2SH(script));
            return data != null && this.canSignFor(data.redeemScript);
        }
        if (ScriptPattern.isP2PKH(script)) {
            ECKey key = this.findKeyFromPubKeyHash(ScriptPattern.extractHashFromP2PKH(script), Script.ScriptType.P2PKH);
            return key != null && (key.isEncrypted() || key.hasPrivKey());
        }
        if (ScriptPattern.isP2WPKH(script)) {
            ECKey key = this.findKeyFromPubKeyHash(ScriptPattern.extractHashFromP2WH(script), Script.ScriptType.P2WPKH);
            return key != null && (key.isEncrypted() || key.hasPrivKey()) && key.isCompressed();
        }
        if (ScriptPattern.isSentToMultisig(script)) {
            for (ECKey pubkey : script.getPubKeys()) {
                ECKey key = this.findKeyFromPubKey(pubkey.getPubKey());
                if (key == null || !key.isEncrypted() && !key.hasPrivKey()) continue;
                return true;
            }
        }
        return false;
    }

    protected LinkedList<TransactionOutput> calculateAllSpendCandidatesFromUTXOProvider(boolean excludeImmatureCoinbases) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        UTXOProvider utxoProvider = (UTXOProvider)Preconditions.checkNotNull((Object)this.vUTXOProvider, (Object)"No UTXO provider has been set");
        LinkedList<TransactionOutput> candidates = new LinkedList<TransactionOutput>();
        try {
            int chainHeight = utxoProvider.getChainHeadHeight();
            for (UTXO output : this.getStoredOutputsFromUTXOProvider()) {
                boolean coinbase = output.isCoinbase();
                int depth = chainHeight - output.getHeight() + 1;
                if (excludeImmatureCoinbases && coinbase && depth < this.params.getSpendableCoinbaseDepth()) continue;
                candidates.add(new FreeStandingTransactionOutput(this.params, output, chainHeight));
            }
        }
        catch (UTXOProviderException e) {
            throw new RuntimeException("UTXO provider error", e);
        }
        for (Transaction tx : this.pending.values()) {
            for (TransactionInput input : tx.getInputs()) {
                if (!input.getConnectedOutput().isMine(this)) continue;
                candidates.remove(input.getConnectedOutput());
            }
            if (excludeImmatureCoinbases && !tx.isMature()) continue;
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.isAvailableForSpending() || !output.isMine(this)) continue;
                candidates.add(output);
            }
        }
        return candidates;
    }

    protected List<UTXO> getStoredOutputsFromUTXOProvider() throws UTXOProviderException {
        UTXOProvider utxoProvider = (UTXOProvider)Preconditions.checkNotNull((Object)this.vUTXOProvider, (Object)"No UTXO provider has been set");
        ArrayList<UTXO> candidates = new ArrayList<UTXO>();
        List<ECKey> keys = this.getImportedKeys();
        keys.addAll(this.getActiveKeyChain().getLeafKeys());
        candidates.addAll(utxoProvider.getOpenTransactionOutputs(keys));
        return candidates;
    }

    public CoinSelector getCoinSelector() {
        this.lock.lock();
        try {
            CoinSelector coinSelector = this.coinSelector;
            return coinSelector;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public UTXOProvider getUTXOProvider() {
        this.lock.lock();
        try {
            UTXOProvider uTXOProvider = this.vUTXOProvider;
            return uTXOProvider;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUTXOProvider(@Nullable UTXOProvider provider) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((provider == null || provider.getParams().equals(this.params) ? 1 : 0) != 0);
            this.vUTXOProvider = provider;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reorganize(StoredBlock splitPoint, List<StoredBlock> oldBlocks, List<StoredBlock> newBlocks) throws VerificationException {
        this.lock.lock();
        try {
            Preconditions.checkState((this.confidenceChanged.size() == 0 ? 1 : 0) != 0);
            Preconditions.checkState((!this.insideReorg ? 1 : 0) != 0);
            this.insideReorg = true;
            Preconditions.checkState((this.onWalletChangedSuppressions == 0 ? 1 : 0) != 0);
            ++this.onWalletChangedSuppressions;
            ArrayListMultimap mapBlockTx = ArrayListMultimap.create();
            for (Transaction tx : this.getTransactions(true)) {
                Map<Sha256Hash, Integer> map = tx.getAppearsInHashes();
                if (map == null) continue;
                for (Map.Entry<Sha256Hash, Integer> entry : map.entrySet()) {
                    mapBlockTx.put((Object)entry.getKey(), (Object)new TxOffsetPair(tx, entry.getValue()));
                }
            }
            for (Iterator<StoredBlock> blockHash : mapBlockTx.keySet()) {
                Collections.sort(mapBlockTx.get((Object)blockHash));
            }
            ArrayList<Sha256Hash> oldBlockHashes = new ArrayList<Sha256Hash>(oldBlocks.size());
            log.info("Old part of chain (top to bottom):");
            for (StoredBlock storedBlock : oldBlocks) {
                log.info("  {}", (Object)storedBlock.getHeader().getHashAsString());
                oldBlockHashes.add(storedBlock.getHeader().getHash());
            }
            log.info("New part of chain (top to bottom):");
            for (StoredBlock storedBlock : newBlocks) {
                log.info("  {}", (Object)storedBlock.getHeader().getHashAsString());
            }
            Collections.reverse(newBlocks);
            LinkedList<Transaction> oldChainTxns = new LinkedList<Transaction>();
            for (Sha256Hash sha256Hash : oldBlockHashes) {
                for (TxOffsetPair pair : mapBlockTx.get((Object)sha256Hash)) {
                    Transaction tx = pair.tx;
                    Sha256Hash txHash = tx.getTxId();
                    if (tx.isCoinBase()) {
                        log.warn("Coinbase killed by re-org: {}", (Object)tx.getTxId());
                        this.killTxns((Set<Transaction>)ImmutableSet.of((Object)tx), null);
                        continue;
                    }
                    for (TransactionOutput output : tx.getOutputs()) {
                        TransactionInput input = output.getSpentBy();
                        if (input == null) continue;
                        if (output.isMineOrWatched(this)) {
                            Preconditions.checkState((boolean)this.myUnspents.add(output));
                        }
                        input.disconnect();
                    }
                    oldChainTxns.add(tx);
                    this.unspent.remove(txHash);
                    this.spent.remove(txHash);
                    Preconditions.checkState((!this.pending.containsKey(txHash) ? 1 : 0) != 0);
                    Preconditions.checkState((!this.dead.containsKey(txHash) ? 1 : 0) != 0);
                }
            }
            for (Transaction transaction : oldChainTxns) {
                if (transaction.isCoinBase()) continue;
                log.info("  ->pending {}", (Object)transaction.getTxId());
                transaction.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
                this.confidenceChanged.put(transaction, TransactionConfidence.Listener.ChangeReason.TYPE);
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, transaction);
                this.updateForSpends(transaction, false);
            }
            int n = oldBlocks.size();
            log.info("depthToSubtract = " + n);
            this.subtractDepth(n, this.spent.values());
            this.subtractDepth(n, this.unspent.values());
            this.subtractDepth(n, this.dead.values());
            this.setLastBlockSeenHash(splitPoint.getHeader().getHash());
            for (StoredBlock storedBlock : newBlocks) {
                log.info("Replaying block {}", (Object)storedBlock.getHeader().getHashAsString());
                for (TxOffsetPair pair : mapBlockTx.get((Object)storedBlock.getHeader().getHash())) {
                    log.info("  tx {}", (Object)pair.tx.getTxId());
                    try {
                        this.receive(pair.tx, storedBlock, AbstractBlockChain.NewBlockType.BEST_CHAIN, pair.offset);
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.notifyNewBestBlock(storedBlock);
            }
            this.isConsistentOrThrow();
            Coin coin = this.getBalance();
            log.info("post-reorg balance is {}", (Object)coin.toFriendlyString());
            this.queueOnReorganize();
            this.insideReorg = false;
            --this.onWalletChangedSuppressions;
            this.maybeQueueOnWalletChanged();
            this.checkBalanceFuturesLocked(coin);
            this.informConfidenceListenersIfNotReorganizing();
            this.saveLater();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void subtractDepth(int depthToSubtract, Collection<Transaction> transactions) {
        for (Transaction tx : transactions) {
            if (tx.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) continue;
            tx.getConfidence().setDepthInBlocks(tx.getConfidence().getDepthInBlocks() - depthToSubtract);
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.DEPTH);
        }
    }

    @Override
    public void beginBloomFilterCalculation() {
        if (this.bloomFilterGuard.incrementAndGet() > 1) {
            return;
        }
        this.lock.lock();
        this.keyChainGroupLock.lock();
        this.calcBloomOutPointsLocked();
    }

    private void calcBloomOutPointsLocked() {
        this.bloomOutPoints.clear();
        HashSet<Transaction> all = new HashSet<Transaction>();
        all.addAll(this.unspent.values());
        all.addAll(this.spent.values());
        all.addAll(this.pending.values());
        for (Transaction tx : all) {
            for (TransactionOutput out : tx.getOutputs()) {
                try {
                    if (!this.isTxOutputBloomFilterable(out)) continue;
                    this.bloomOutPoints.add(out.getOutPointFor());
                }
                catch (ScriptException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    @GuardedBy(value="keyChainGroupLock")
    public void endBloomFilterCalculation() {
        if (this.bloomFilterGuard.decrementAndGet() > 0) {
            return;
        }
        this.bloomOutPoints.clear();
        this.keyChainGroupLock.unlock();
        this.lock.unlock();
    }

    @Override
    public int getBloomFilterElementCount() {
        this.beginBloomFilterCalculation();
        try {
            int size = this.bloomOutPoints.size();
            size += this.keyChainGroup.getBloomFilterElementCount();
            int n = size += this.watchedScripts.size();
            return n;
        }
        finally {
            this.endBloomFilterCalculation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BloomFilter getBloomFilter(double falsePositiveRate) {
        this.beginBloomFilterCalculation();
        try {
            BloomFilter bloomFilter = this.getBloomFilter(this.getBloomFilterElementCount(), falsePositiveRate, (long)(Math.random() * 9.223372036854776E18));
            return bloomFilter;
        }
        finally {
            this.endBloomFilterCalculation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="keyChainGroupLock")
    public BloomFilter getBloomFilter(int size, double falsePositiveRate, long nTweak) {
        this.beginBloomFilterCalculation();
        try {
            BloomFilter filter = this.keyChainGroup.getBloomFilter(size, falsePositiveRate, nTweak);
            for (Script script : this.watchedScripts) {
                for (ScriptChunk chunk : script.getChunks()) {
                    if (chunk.isOpCode() || chunk.data == null || chunk.data.length < 8) continue;
                    filter.insert(chunk.data);
                }
            }
            for (TransactionOutPoint point : this.bloomOutPoints) {
                filter.insert(point);
            }
            BloomFilter bloomFilter = filter;
            return bloomFilter;
        }
        finally {
            this.endBloomFilterCalculation();
        }
    }

    private boolean isTxOutputBloomFilterable(TransactionOutput out) {
        Script script = out.getScriptPubKey();
        boolean isScriptTypeSupported = ScriptPattern.isP2PK(script) || ScriptPattern.isP2SH(script) || ScriptPattern.isP2WPKH(script) || ScriptPattern.isP2WSH(script);
        return isScriptTypeSupported && out.isMine(this) || this.watchedScripts.contains(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForFilterExhaustion(FilteredBlock block) {
        this.keyChainGroupLock.lock();
        try {
            if (!this.keyChainGroup.isSupportsDeterministicChains()) {
                boolean bl = false;
                return bl;
            }
            int epoch = this.keyChainGroup.getCombinedKeyLookaheadEpochs();
            for (Transaction tx : block.getAssociatedTransactions().values()) {
                this.markKeysAsUsed(tx);
            }
            int newEpoch = this.keyChainGroup.getCombinedKeyLookaheadEpochs();
            Preconditions.checkState((newEpoch >= epoch ? 1 : 0) != 0);
            boolean bl = newEpoch > epoch;
            return bl;
        }
        finally {
            this.keyChainGroupLock.unlock();
        }
    }

    public void addExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            if (this.extensions.containsKey(id)) {
                throw new IllegalStateException("Cannot add two extensions with the same ID: " + id);
            }
            this.extensions.put(id, extension);
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalletExtension addOrGetExistingExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            WalletExtension previousExtension = this.extensions.get(id);
            if (previousExtension != null) {
                WalletExtension walletExtension = previousExtension;
                return walletExtension;
            }
            this.extensions.put(id, extension);
            this.saveNow();
            WalletExtension walletExtension = extension;
            return walletExtension;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addOrUpdateExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            this.extensions.put(id, extension);
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, WalletExtension> getExtensions() {
        this.lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.extensions);
            return immutableMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deserializeExtension(WalletExtension extension, byte[] data) throws Exception {
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            extension.deserializeWalletExtension(this, data);
            this.extensions.put(extension.getWalletExtensionID(), extension);
        }
        catch (Throwable throwable) {
            log.error("Error during extension deserialization", throwable);
            this.extensions.remove(extension.getWalletExtensionID());
            throw throwable;
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
    }

    @Override
    public void setTag(String tag, ByteString value) {
        super.setTag(tag, value);
        this.saveNow();
    }

    private FeeCalculation calculateFee(SendRequest req, Coin value, List<TransactionInput> originalInputs, boolean needAtLeastReferenceFee, List<TransactionOutput> candidates) throws InsufficientMoneyException {
        FeeCalculation result;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Coin fee = Coin.ZERO;
        while (true) {
            int vsize;
            Coin feeNeeded;
            CoinSelection selection;
            result = new FeeCalculation();
            Transaction tx = new Transaction(this.params);
            this.addSuppliedInputs(tx, req.tx.getInputs());
            Coin valueNeeded = value;
            if (!req.recipientsPayFees) {
                valueNeeded = valueNeeded.add(fee);
            }
            if (req.recipientsPayFees) {
                result.updatedOutputValues = new ArrayList<Coin>();
            }
            for (int i = 0; i < req.tx.getOutputs().size(); ++i) {
                TransactionOutput output = new TransactionOutput(this.params, tx, req.tx.getOutputs().get(i).bitcoinSerialize(), 0);
                if (req.recipientsPayFees) {
                    output.setValue(output.getValue().subtract(fee.divide(req.tx.getOutputs().size())));
                    if (i == 0) {
                        output.setValue(output.getValue().subtract(fee.divideAndRemainder(req.tx.getOutputs().size())[1]));
                    }
                    result.updatedOutputValues.add(output.getValue());
                    if (output.getMinNonDustValue().isGreaterThan(output.getValue())) {
                        throw new CouldNotAdjustDownwards();
                    }
                }
                tx.addOutput(output);
            }
            CoinSelector selector = req.coinSelector == null ? this.coinSelector : req.coinSelector;
            result.bestCoinSelection = selection = selector.select(valueNeeded, new LinkedList<TransactionOutput>(candidates));
            if (selection.valueGathered.compareTo(valueNeeded) < 0) {
                Coin valueMissing = valueNeeded.subtract(selection.valueGathered);
                throw new InsufficientMoneyException(valueMissing);
            }
            Coin change = selection.valueGathered.subtract(valueNeeded);
            if (change.isGreaterThan(Coin.ZERO)) {
                Object changeAddress = req.changeAddress;
                if (changeAddress == null) {
                    changeAddress = this.currentChangeAddress();
                }
                TransactionOutput changeOutput = new TransactionOutput(this.params, tx, change, (Address)changeAddress);
                if (req.recipientsPayFees && changeOutput.isDust()) {
                    Coin missingToNotBeDust = changeOutput.getMinNonDustValue().subtract(changeOutput.getValue());
                    changeOutput.setValue(changeOutput.getValue().add(missingToNotBeDust));
                    TransactionOutput firstOutput = tx.getOutputs().get(0);
                    firstOutput.setValue(firstOutput.getValue().subtract(missingToNotBeDust));
                    result.updatedOutputValues.set(0, firstOutput.getValue());
                    if (firstOutput.isDust()) {
                        throw new CouldNotAdjustDownwards();
                    }
                }
                if (changeOutput.isDust()) {
                    fee = fee.add(changeOutput.getValue());
                } else {
                    tx.addOutput(changeOutput);
                    result.bestChangeOutput = changeOutput;
                }
            }
            for (TransactionOutput selectedOutput : selection.gathered) {
                TransactionInput input = tx.addInput(selectedOutput);
                Preconditions.checkState((input.getScriptBytes().length == 0 ? 1 : 0) != 0);
                Preconditions.checkState((!input.hasWitness() ? 1 : 0) != 0);
            }
            Coin feePerKb = req.feePerKb;
            if (needAtLeastReferenceFee && feePerKb.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
                feePerKb = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
            }
            if (!fee.isLessThan(feeNeeded = feePerKb.multiply(vsize = tx.getVsize() + this.estimateVirtualBytesForSigning(selection)).divide(1000L))) break;
            fee = feeNeeded;
        }
        return result;
    }

    private void addSuppliedInputs(Transaction tx, List<TransactionInput> originalInputs) {
        for (TransactionInput input : originalInputs) {
            tx.addInput(new TransactionInput(this.params, tx, input.bitcoinSerialize()));
        }
    }

    private int estimateVirtualBytesForSigning(CoinSelection selection) {
        int vsize = 0;
        for (TransactionOutput output : selection.gathered) {
            try {
                Script script = output.getScriptPubKey();
                ECKey key = null;
                Script redeemScript = null;
                if (ScriptPattern.isP2PKH(script)) {
                    key = this.findKeyFromPubKeyHash(ScriptPattern.extractHashFromP2PKH(script), Script.ScriptType.P2PKH);
                    Preconditions.checkNotNull((Object)key, (Object)"Coin selection includes unspendable outputs");
                    vsize += script.getNumberOfBytesRequiredToSpend(key, redeemScript);
                    continue;
                }
                if (ScriptPattern.isP2WPKH(script)) {
                    key = this.findKeyFromPubKeyHash(ScriptPattern.extractHashFromP2WH(script), Script.ScriptType.P2WPKH);
                    Preconditions.checkNotNull((Object)key, (Object)"Coin selection includes unspendable outputs");
                    vsize += IntMath.divide((int)script.getNumberOfBytesRequiredToSpend(key, redeemScript), (int)4, (RoundingMode)RoundingMode.CEILING);
                    continue;
                }
                if (ScriptPattern.isP2SH(script)) {
                    redeemScript = this.findRedeemDataFromScriptHash((byte[])ScriptPattern.extractHashFromP2SH((Script)script)).redeemScript;
                    Preconditions.checkNotNull((Object)redeemScript, (Object)"Coin selection includes unspendable outputs");
                    vsize += script.getNumberOfBytesRequiredToSpend(key, redeemScript);
                    continue;
                }
                vsize += script.getNumberOfBytesRequiredToSpend(key, redeemScript);
            }
            catch (ScriptException e) {
                throw new IllegalStateException(e);
            }
        }
        return vsize;
    }

    public void setTransactionBroadcaster(@Nullable TransactionBroadcaster broadcaster) {
        Transaction[] toBroadcast = new Transaction[]{};
        this.lock.lock();
        try {
            if (this.vTransactionBroadcaster == broadcaster) {
                return;
            }
            this.vTransactionBroadcaster = broadcaster;
            if (broadcaster == null) {
                return;
            }
            toBroadcast = this.pending.values().toArray(toBroadcast);
        }
        finally {
            this.lock.unlock();
        }
        for (Transaction tx : toBroadcast) {
            TransactionConfidence.ConfidenceType confidenceType = tx.getConfidence().getConfidenceType();
            Preconditions.checkState((confidenceType == TransactionConfidence.ConfidenceType.PENDING || confidenceType == TransactionConfidence.ConfidenceType.IN_CONFLICT ? 1 : 0) != 0, (String)"Expected PENDING or IN_CONFLICT, was %s.", (Object)((Object)confidenceType));
            log.info("New broadcaster so uploading waiting tx {}", (Object)tx.getTxId());
            broadcaster.broadcastTransaction(tx);
        }
    }

    public void setKeyRotationTime(@Nullable Date time) {
        this.setKeyRotationTime(time != null ? time.getTime() / 1000L : 0L);
    }

    public void setKeyRotationTime(long unixTimeSeconds) {
        Preconditions.checkArgument((unixTimeSeconds <= Utils.currentTimeSeconds() ? 1 : 0) != 0, (String)"Given time (%s) cannot be in the future.", (Object)Utils.dateTimeFormat(unixTimeSeconds * 1000L));
        this.vKeyRotationTimestamp = unixTimeSeconds;
        this.saveNow();
    }

    @Nullable
    public Date getKeyRotationTime() {
        long keyRotationTimestamp = this.vKeyRotationTimestamp;
        if (keyRotationTimestamp != 0L) {
            return new Date(keyRotationTimestamp * 1000L);
        }
        return null;
    }

    public boolean isKeyRotating(ECKey key) {
        long time = this.vKeyRotationTimestamp;
        return time != 0L && key.getCreationTimeSeconds() < time;
    }

    public ListenableFuture<List<Transaction>> doMaintenance(@Nullable KeyParameter aesKey, boolean signAndSend) throws DeterministicUpgradeRequiresPassword {
        return this.doMaintenance(KeyChainGroupStructure.DEFAULT, aesKey, signAndSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<Transaction>> doMaintenance(KeyChainGroupStructure structure, @Nullable KeyParameter aesKey, boolean signAndSend) throws DeterministicUpgradeRequiresPassword {
        List<Transaction> txns;
        this.lock.lock();
        this.keyChainGroupLock.lock();
        try {
            txns = this.maybeRotateKeys(structure, aesKey, signAndSend);
            if (!signAndSend) {
                ListenableFuture listenableFuture = Futures.immediateFuture(txns);
                return listenableFuture;
            }
        }
        finally {
            this.keyChainGroupLock.unlock();
            this.lock.unlock();
        }
        Preconditions.checkState((!this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
        ArrayList<ListenableFuture<Transaction>> futures = new ArrayList<ListenableFuture<Transaction>>(txns.size());
        TransactionBroadcaster broadcaster = this.vTransactionBroadcaster;
        for (Transaction tx : txns) {
            try {
                ListenableFuture<Transaction> future = broadcaster.broadcastTransaction(tx).future();
                futures.add(future);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<Transaction>(){

                    public void onSuccess(Transaction transaction) {
                        log.info("Successfully broadcast key rotation tx: {}", (Object)transaction);
                    }

                    public void onFailure(Throwable throwable) {
                        log.error("Failed to broadcast key rotation tx", throwable);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
            catch (Exception e) {
                log.error("Failed to broadcast rekey tx", (Throwable)e);
            }
        }
        return Futures.allAsList(futures);
    }

    @GuardedBy(value="keyChainGroupLock")
    private List<Transaction> maybeRotateKeys(KeyChainGroupStructure structure, @Nullable KeyParameter aesKey, boolean sign) throws DeterministicUpgradeRequiresPassword {
        Transaction tx;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((boolean)this.keyChainGroupLock.isHeldByCurrentThread());
        LinkedList<Transaction> results = new LinkedList<Transaction>();
        long keyRotationTimestamp = this.vKeyRotationTimestamp;
        if (keyRotationTimestamp == 0L) {
            return results;
        }
        boolean allChainsRotating = true;
        Script.ScriptType preferredScriptType = Script.ScriptType.P2PKH;
        if (this.keyChainGroup.isSupportsDeterministicChains()) {
            for (DeterministicKeyChain chain : this.keyChainGroup.getDeterministicKeyChains()) {
                if (chain.getEarliestKeyCreationTime() >= keyRotationTimestamp) {
                    allChainsRotating = false;
                    continue;
                }
                preferredScriptType = chain.getOutputScriptType();
            }
        }
        if (allChainsRotating) {
            try {
                if (this.keyChainGroup.getImportedKeys().isEmpty()) {
                    log.info("All deterministic chains are currently rotating and we have no random keys, creating fresh {} chain: backup required after this.", (Object)preferredScriptType);
                    KeyChainGroup newChains = KeyChainGroup.builder(this.params, structure).fromRandom(preferredScriptType).build();
                    if (this.keyChainGroup.isEncrypted()) {
                        if (aesKey == null) {
                            throw new DeterministicUpgradeRequiresPassword();
                        }
                        KeyCrypter keyCrypter = this.keyChainGroup.getKeyCrypter();
                        this.keyChainGroup.decrypt(aesKey);
                        this.keyChainGroup.mergeActiveKeyChains(newChains, keyRotationTimestamp);
                        this.keyChainGroup.encrypt(keyCrypter, aesKey);
                    } else {
                        this.keyChainGroup.mergeActiveKeyChains(newChains, keyRotationTimestamp);
                    }
                } else {
                    log.info("All deterministic chains are currently rotating, creating a new {} one from the next oldest non-rotating key material...", (Object)preferredScriptType);
                    this.keyChainGroup.upgradeToDeterministic(preferredScriptType, structure, keyRotationTimestamp, aesKey);
                    log.info("...upgraded to HD again, based on next best oldest key.");
                }
            }
            catch (AllRandomKeysRotating rotating) {
                log.info("No non-rotating random keys available, generating entirely new {} tree: backup required after this.", (Object)preferredScriptType);
                KeyChainGroup newChains = KeyChainGroup.builder(this.params, structure).fromRandom(preferredScriptType).build();
                if (this.keyChainGroup.isEncrypted()) {
                    if (aesKey == null) {
                        throw new DeterministicUpgradeRequiresPassword();
                    }
                    KeyCrypter keyCrypter = this.keyChainGroup.getKeyCrypter();
                    this.keyChainGroup.decrypt(aesKey);
                    this.keyChainGroup.mergeActiveKeyChains(newChains, keyRotationTimestamp);
                    this.keyChainGroup.encrypt(keyCrypter, aesKey);
                }
                this.keyChainGroup.mergeActiveKeyChains(newChains, keyRotationTimestamp);
            }
            this.saveNow();
        }
        do {
            if ((tx = this.rekeyOneBatch(keyRotationTimestamp, aesKey, results, sign)) == null) continue;
            results.add(tx);
        } while (tx != null && tx.getInputs().size() == 600);
        return results;
    }

    @Nullable
    private Transaction rekeyOneBatch(long timeSecs, @Nullable KeyParameter aesKey, List<Transaction> others, boolean sign) {
        this.lock.lock();
        try {
            KeyTimeCoinSelector keyTimeSelector = new KeyTimeCoinSelector(this, timeSecs, true);
            FilteringCoinSelector selector = new FilteringCoinSelector(keyTimeSelector);
            for (Transaction other : others) {
                selector.excludeOutputsSpentBy(other);
            }
            CoinSelection toMove = selector.select(Coin.ZERO, this.calculateAllSpendCandidates());
            if (toMove.valueGathered.equals(Coin.ZERO)) {
                Transaction other;
                other = null;
                return other;
            }
            Transaction rekeyTx = new Transaction(this.params);
            for (TransactionOutput output : toMove.gathered) {
                rekeyTx.addInput(output);
            }
            rekeyTx.addOutput(toMove.valueGathered, sign ? this.freshReceiveAddress() : this.currentReceiveAddress());
            if (!this.adjustOutputDownwardsForFee(rekeyTx, toMove, Transaction.DEFAULT_TX_FEE, true)) {
                log.error("Failed to adjust rekey tx for fees.");
                Iterator<TransactionOutput> iterator = null;
                return iterator;
            }
            rekeyTx.getConfidence().setSource(TransactionConfidence.Source.SELF);
            rekeyTx.setPurpose(Transaction.Purpose.KEY_ROTATION);
            SendRequest req = SendRequest.forTx(rekeyTx);
            req.aesKey = aesKey;
            if (sign) {
                this.signTransaction(req);
            }
            Preconditions.checkState((rekeyTx.unsafeBitcoinSerialize().length < 100000 ? 1 : 0) != 0);
            Transaction transaction = rekeyTx;
            return transaction;
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class FeeCalculation {
        public CoinSelection bestCoinSelection;
        public TransactionOutput bestChangeOutput;
        public List<Coin> updatedOutputValues;

        private FeeCalculation() {
        }
    }

    private static class TxOffsetPair
    implements Comparable<TxOffsetPair> {
        public final Transaction tx;
        public final int offset;

        public TxOffsetPair(Transaction tx, int offset) {
            this.tx = tx;
            this.offset = offset;
        }

        @Override
        public int compareTo(TxOffsetPair o) {
            return Integer.compare(this.offset, o.offset);
        }
    }

    private class FreeStandingTransactionOutput
    extends TransactionOutput {
        private UTXO output;
        private int chainHeight;

        public FreeStandingTransactionOutput(NetworkParameters params, UTXO output, int chainHeight) {
            super(params, null, output.getValue(), output.getScript().getProgram());
            this.output = output;
            this.chainHeight = chainHeight;
        }

        public UTXO getUTXO() {
            return this.output;
        }

        @Override
        public int getParentTransactionDepthInBlocks() {
            return this.chainHeight - this.output.getHeight() + 1;
        }

        @Override
        public int getIndex() {
            return (int)this.output.getIndex();
        }

        @Override
        public Sha256Hash getParentTransactionHash() {
            return this.output.getHash();
        }
    }

    public static class BadWalletEncryptionKeyException
    extends CompletionException {
        public BadWalletEncryptionKeyException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class ExceededMaxTransactionSize
    extends CompletionException {
    }

    public static class CouldNotAdjustDownwards
    extends CompletionException {
    }

    public static class MultipleOpReturnRequested
    extends CompletionException {
    }

    public static class DustySendRequested
    extends CompletionException {
    }

    public static class CompletionException
    extends RuntimeException {
        public CompletionException() {
        }

        public CompletionException(Throwable throwable) {
            super(throwable);
        }
    }

    public static enum MissingSigsMode {
        USE_OP_ZERO,
        USE_DUMMY_SIG,
        THROW;

    }

    public static class SendResult {
        public final Transaction tx;
        public final ListenableFuture<Transaction> broadcastComplete;
        public final TransactionBroadcast broadcast;

        public SendResult(Transaction tx, TransactionBroadcast broadcast) {
            this.tx = tx;
            this.broadcast = broadcast;
            this.broadcastComplete = broadcast.future();
        }
    }

    private static class BalanceFutureRequest {
        public SettableFuture<Coin> future;
        public Coin value;
        public BalanceType type;

        private BalanceFutureRequest() {
        }
    }

    public static enum BalanceType {
        ESTIMATED,
        AVAILABLE,
        ESTIMATED_SPENDABLE,
        AVAILABLE_SPENDABLE;

    }
}

