/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.alarm.server.aspect;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="execution(public * com.ebaiyihui.alarm.server.controller.*.*(..))")
    public void LogAspect() {
    }

    @Around(value="LogAspect()")
    public Object deAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String ipaddress = request.getHeader("x-forwarded-for") == null ? request.getRemoteAddr() : request.getHeader("x-forwarded-for");
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String queryString = request.getQueryString();
        Object[] args = pjp.getArgs();
        String params = "";
        if (args.length > 0) {
            if ("POST".equals(method)) {
                Object object = args[0];
                Map map = LogAspect.getKeyAndValue((Object)object);
                params = JSON.toJSONString((Object)map);
            } else if ("GET".equals(method)) {
                params = queryString;
            }
        }
        Signature signature = pjp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        Method realMethod = pjp.getTarget().getClass().getDeclaredMethod(signature.getName(), targetMethod.getParameterTypes());
        ApiOperation operation = realMethod.getAnnotation(ApiOperation.class);
        if (null != operation) {
            log.info("\u8bf7\u6c42\u5f00\u59cb===\u65b9\u6cd5\u63cf\u8ff0:{},\u8bf7\u6c42\u65b9\u6cd5:{},\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42ip:{},\u8bf7\u6c42\u7c7b\u578b:{},\u8bf7\u6c42\u53c2\u6570:{}", new Object[]{operation.value(), realMethod.getName(), url, ipaddress, method, params});
        } else {
            log.info("\u8bf7\u6c42\u5f00\u59cb===\u8bf7\u6c42\u65b9\u6cd5:{},\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42ip:{},\u8bf7\u6c42\u7c7b\u578b:{},\u8bf7\u6c42\u53c2\u6570:{}", new Object[]{realMethod.getName(), url, ipaddress, method, params});
        }
        return pjp.proceed();
    }

    public static Map<String, Object> getKeyAndValue(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> userCla = obj.getClass();
        Field[] fs = userCla.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            try {
                Object val = f.get(obj);
                map.put(f.getName(), val);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

