/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.alarm.server.service.Impl;

import com.ebaiyihui.alarm.server.config.ProjProperties;
import com.ebaiyihui.alarm.server.entity.AlarmMessage;
import com.ebaiyihui.alarm.server.service.AlarmService;
import com.ebaiyihui.alarm.server.util.HttpKit;
import com.ebaiyihui.framework.utils.StringUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AlarmServiceImpl
implements AlarmService {
    @Value(value="${webHookUrl}")
    private String webHookUrl;
    @Value(value="${secret}")
    private String secret;
    @Autowired
    private ProjProperties projProperties;

    public String receive(List<AlarmMessage> alarmMessages) {
        for (AlarmMessage alarmMessage : alarmMessages) {
            String name = alarmMessage.getName();
            String message = alarmMessage.getAlarmMessage();
            String serviceNme = name.substring(name.indexOf("byh"), name.length());
            if (this.projProperties.getCloudBaseService().contains(serviceNme)) {
                message = message + "<at user_id=\\\"" + this.projProperties.getCloudBaseNotifyName() + "\\\"></at>";
                alarmMessage.setAlarmMessage(message);
            }
            String sendMessage = "{\"msg_type\":\"text\",\"content\":{\"text\":\"Apache SkyWalking Alarm: \\n %s.\"}}";
            String requestBody = this.getRequestBody(sendMessage, alarmMessage);
            try {
                HttpKit.jsonPost((String)this.webHookUrl, (String)requestBody);
            }
            catch (Exception e) {
                return "fail";
            }
        }
        return "success";
    }

    private String getRequestBody(String sendMessage, AlarmMessage alarmMessage) {
        String requestBody = String.format(sendMessage, alarmMessage.getAlarmMessage());
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(requestBody, JsonObject.class);
        Map content = this.buildContent(jsonObject);
        if (!StringUtil.isBlank((String)this.secret)) {
            Long timestamp = System.currentTimeMillis() / 1000L;
            content.put("timestamp", timestamp);
            try {
                content.put("sign", this.sign(timestamp, this.secret));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return gson.toJson((Object)content);
    }

    private Map<String, Object> buildContent(JsonObject jsonObject) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("msg_type", jsonObject.get("msg_type").getAsString());
        if (jsonObject.get("ats") != null) {
            String ats = jsonObject.get("ats").getAsString();
            List collect = Arrays.stream(ats.split(",")).map(String::trim).collect(Collectors.toList());
            String text = jsonObject.get("content").getAsJsonObject().get("text").getAsString();
            for (String userId : collect) {
                text = text + "<at user_id=\"" + userId + "\"></at>";
            }
            jsonObject.get("content").getAsJsonObject().addProperty("text", text);
        }
        content.put("content", jsonObject.get("content").getAsJsonObject());
        return content;
    }

    private String sign(Long timestamp, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        String stringToSign = timestamp + "\n" + secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(stringToSign.getBytes(), "HmacSHA256"));
        byte[] signData = mac.doFinal();
        return Base64.getEncoder().encodeToString(signData);
    }
}

