/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.FieldDescriptor;
import jodd.util.ClassUtil;

public class Fields {
    protected final ClassDescriptor classDescriptor;
    protected final HashMap<String, FieldDescriptor> fieldsMap;
    private FieldDescriptor[] allFields;

    public Fields(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.fieldsMap = this.inspectFields();
    }

    protected HashMap<String, FieldDescriptor> inspectFields() {
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        Class type = this.classDescriptor.getType();
        Field[] fields = scanAccessible ? ClassUtil.getAccessibleFields((Class)type) : ClassUtil.getSupportedFields((Class)type);
        HashMap<String, FieldDescriptor> map = new HashMap<String, FieldDescriptor>(fields.length);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (fieldName.equals("serialVersionUID")) continue;
            map.put(fieldName, this.createFieldDescriptor(field));
        }
        return map;
    }

    protected FieldDescriptor createFieldDescriptor(Field field) {
        return new FieldDescriptor(this.classDescriptor, field);
    }

    public FieldDescriptor getFieldDescriptor(String name) {
        return this.fieldsMap.get(name);
    }

    public FieldDescriptor[] getAllFieldDescriptors() {
        if (this.allFields == null) {
            FieldDescriptor[] allFields = new FieldDescriptor[this.fieldsMap.size()];
            int index = 0;
            Iterator<FieldDescriptor> iterator = this.fieldsMap.values().iterator();
            while (iterator.hasNext()) {
                FieldDescriptor fieldDescriptor;
                allFields[index] = fieldDescriptor = iterator.next();
                ++index;
            }
            Arrays.sort(allFields, new Comparator<FieldDescriptor>(){

                @Override
                public int compare(FieldDescriptor fd1, FieldDescriptor fd2) {
                    return fd1.getField().getName().compareTo(fd2.getField().getName());
                }
            });
            this.allFields = allFields;
        }
        return this.allFields;
    }
}

