/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.api.ExecutingQueryList;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.locking.ActiveLock;

class KernelTransactionImplementationHandle
implements KernelTransactionHandle {
    private final long txReuseCount;
    private final long lastTransactionIdWhenStarted;
    private final long lastTransactionTimestampWhenStarted;
    private final long startTime;
    private final long timeoutMillis;
    private final KernelTransactionImplementation tx;
    private final SecurityContext securityContext;
    private final Optional<Status> terminationReason;
    private final ExecutingQueryList executingQueries;

    KernelTransactionImplementationHandle(KernelTransactionImplementation tx) {
        this.txReuseCount = tx.getReuseCount();
        this.lastTransactionIdWhenStarted = tx.lastTransactionIdWhenStarted();
        this.lastTransactionTimestampWhenStarted = tx.lastTransactionTimestampWhenStarted();
        this.startTime = tx.startTime();
        this.timeoutMillis = tx.timeout();
        this.securityContext = tx.securityContext();
        this.terminationReason = tx.getReasonIfTerminated();
        this.executingQueries = tx.executingQueries();
        this.tx = tx;
    }

    @Override
    public long lastTransactionIdWhenStarted() {
        return this.lastTransactionIdWhenStarted;
    }

    @Override
    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long timeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public boolean isOpen() {
        return this.tx.isOpen() && this.txReuseCount == (long)this.tx.getReuseCount();
    }

    @Override
    public boolean markForTermination(Status reason) {
        return this.tx.markForTermination(this.txReuseCount, reason);
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public Optional<Status> terminationReason() {
        return this.terminationReason;
    }

    @Override
    public boolean isUnderlyingTransaction(KernelTransaction tx) {
        return this.tx == tx;
    }

    @Override
    public Stream<ExecutingQuery> executingQueries() {
        return this.executingQueries.queries();
    }

    @Override
    public Stream<? extends ActiveLock> activeLocks() {
        return this.tx.activeLocks();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KernelTransactionImplementationHandle that = (KernelTransactionImplementationHandle)o;
        return this.txReuseCount == that.txReuseCount && this.tx.equals(that.tx);
    }

    public int hashCode() {
        return 31 * (int)(this.txReuseCount ^ this.txReuseCount >>> 32) + this.tx.hashCode();
    }

    public String toString() {
        return "KernelTransactionImplementationHandle{txReuseCount=" + this.txReuseCount + ", tx=" + this.tx + "}";
    }
}

