/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.ribbon;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.ArrayList;
import java.util.List;

public class NacosServerList
extends AbstractServerList<NacosServer> {
    private NacosDiscoveryProperties discoveryProperties;
    private NacosServiceManager nacosServiceManager;
    private String serviceId;

    public NacosServerList(NacosDiscoveryProperties discoveryProperties, NacosServiceManager nacosServiceManager) {
        this.discoveryProperties = discoveryProperties;
        this.nacosServiceManager = nacosServiceManager;
    }

    public List<NacosServer> getInitialListOfServers() {
        return this.getServers();
    }

    public List<NacosServer> getUpdatedListOfServers() {
        return this.getServers();
    }

    private List<NacosServer> getServers() {
        try {
            String group = this.discoveryProperties.getGroup();
            List instances = this.nacosServiceManager.getNamingService(this.discoveryProperties.getNacosProperties()).selectInstances(this.serviceId, group, true);
            return this.instancesToServerList(instances);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not get service instances from nacos, serviceId=" + this.serviceId, e);
        }
    }

    private List<NacosServer> instancesToServerList(List<Instance> instances) {
        ArrayList<NacosServer> result = new ArrayList<NacosServer>();
        if (CollectionUtils.isEmpty(instances)) {
            return result;
        }
        for (Instance instance : instances) {
            result.add(new NacosServer(instance));
        }
        return result;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
        this.serviceId = iClientConfig.getClientName();
    }
}

