/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

abstract class FieldWriterEnum
extends FieldWriter {
    final byte[][] valueNameCacheUTF8;
    final char[][] valueNameCacheUTF16;
    final byte[][] utf8ValueCache;
    final char[][] utf16ValueCache;
    final Class enumType;
    final Enum[] enumConstants;
    final long[] hashCodes;

    protected FieldWriterEnum(String name, int ordinal, long features, String format, String label, Class<? extends Enum> enumType, Field field, Method method) {
        super(name, ordinal, features, format, label, enumType, enumType, field, method);
        this.enumType = enumType;
        this.enumConstants = enumType.getEnumConstants();
        this.hashCodes = new long[this.enumConstants.length];
        for (int i = 0; i < this.enumConstants.length; ++i) {
            this.hashCodes[i] = Fnv.hashCode64(this.enumConstants[i].name());
        }
        this.valueNameCacheUTF8 = new byte[this.enumConstants.length][];
        this.valueNameCacheUTF16 = new char[this.enumConstants.length][];
        this.utf8ValueCache = new byte[this.enumConstants.length][];
        this.utf16ValueCache = new char[this.enumConstants.length][];
    }

    @Override
    public final void writeEnumJSONB(JSONWriter jsonWriter, Enum e) {
        int namingOrdinal;
        if (e == null) {
            return;
        }
        long features = this.features | jsonWriter.getFeatures();
        boolean usingOrdinal = (features & (JSONWriter.Feature.WriteEnumUsingToString.mask | JSONWriter.Feature.WriteEnumsUsingName.mask)) == 0L;
        boolean usingToString = (features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L;
        int ordinal = e.ordinal();
        SymbolTable symbolTable = jsonWriter.getSymbolTable();
        if (symbolTable != null && usingOrdinal && !usingToString && (namingOrdinal = symbolTable.getOrdinalByHashCode(this.hashCodes[ordinal])) >= 0) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeRaw((byte)121);
            jsonWriter.writeInt32(-namingOrdinal);
            return;
        }
        if (usingToString) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(e.toString());
            return;
        }
        if (usingOrdinal) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt32(ordinal);
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(e.name());
    }

    @Override
    public final void writeEnum(JSONWriter jsonWriter, Enum e) {
        long features = this.features | jsonWriter.getFeatures();
        if ((features & JSONWriter.Feature.WriteEnumUsingToString.mask) != 0L) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(e.toString());
            return;
        }
        boolean usingOrdinal = (features & (JSONWriter.Feature.WriteEnumUsingToString.mask | JSONWriter.Feature.WriteEnumsUsingName.mask)) == 0L;
        boolean utf8 = jsonWriter.isUTF8();
        boolean utf16 = utf8 ? false : jsonWriter.isUTF16();
        int ordinal = e.ordinal();
        if (usingOrdinal) {
            if (utf8) {
                byte[] bytes = this.utf8ValueCache[ordinal];
                if (bytes == null) {
                    int size = IOUtils.stringSize(ordinal);
                    byte[] original = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + size);
                    bytes = Arrays.copyOf(original, original.length);
                    IOUtils.getChars(ordinal, bytes.length, bytes);
                    this.utf8ValueCache[ordinal] = bytes;
                }
                jsonWriter.writeNameRaw(bytes);
                return;
            }
            if (utf16) {
                char[] bytes = this.utf16ValueCache[ordinal];
                if (bytes == null) {
                    int size = IOUtils.stringSize(ordinal);
                    char[] original = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + size);
                    bytes = Arrays.copyOf(original, original.length);
                    IOUtils.getChars(ordinal, bytes.length, bytes);
                    this.utf16ValueCache[ordinal] = bytes;
                }
                jsonWriter.writeNameRaw(bytes);
                return;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt32(ordinal);
            return;
        }
        if (utf8) {
            byte[] bytes = this.valueNameCacheUTF8[ordinal];
            if (bytes == null) {
                String name = this.enumConstants[ordinal].name();
                bytes = Arrays.copyOf(this.nameWithColonUTF8, this.nameWithColonUTF8.length + name.length() + 2);
                bytes[this.nameWithColonUTF8.length] = 34;
                name.getBytes(0, name.length(), bytes, this.nameWithColonUTF8.length + 1);
                bytes[bytes.length - 1] = 34;
                this.valueNameCacheUTF8[ordinal] = bytes;
            }
            jsonWriter.writeNameRaw(bytes);
            return;
        }
        if (utf16) {
            char[] chars = this.valueNameCacheUTF16[ordinal];
            if (chars == null) {
                String name = this.enumConstants[ordinal].name();
                chars = Arrays.copyOf(this.nameWithColonUTF16, this.nameWithColonUTF16.length + name.length() + 2);
                chars[this.nameWithColonUTF16.length] = 34;
                name.getChars(0, name.length(), chars, this.nameWithColonUTF16.length + 1);
                chars[chars.length - 1] = 34;
                this.valueNameCacheUTF16[ordinal] = chars;
            }
            jsonWriter.writeNameRaw(chars);
            return;
        }
        if (jsonWriter.isJSONB()) {
            this.writeEnumJSONB(jsonWriter, e);
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeString(e.name());
    }
}

