/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectParam;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ObjectReaderNoneDefaultConstructor<T>
extends ObjectReaderAdapter<T> {
    final String[] paramNames;
    final FieldReader[] setterFieldReaders;
    private Function<Map<Long, Object>, T> creator;
    private List<Constructor> alternateConstructors;

    public ObjectReaderNoneDefaultConstructor(Class objectClass, String typeKey, String typeName, long features, Function<Map<Long, Object>, T> creator, List<Constructor> alternateConstructors, String[] paramNames, FieldReader[] paramFieldReaders, FieldReader[] setterFieldReaders, Class[] seeAlso, String[] seeAlsoNames) {
        super(objectClass, typeKey, typeName, features, null, null, null, seeAlso, seeAlsoNames, ObjectReaderNoneDefaultConstructor.concat(paramFieldReaders, setterFieldReaders));
        this.paramNames = paramNames;
        this.creator = creator;
        this.setterFieldReaders = setterFieldReaders;
        this.alternateConstructors = alternateConstructors;
    }

    static FieldReader[] concat(FieldReader[] a, FieldReader[] b) {
        if (b == null) {
            return a;
        }
        int alen = a.length;
        a = Arrays.copyOf(a, alen + b.length);
        System.arraycopy(b, 0, a, alen, b.length);
        return a;
    }

    @Override
    public T createInstanceNoneDefaultConstructor(Map<Long, Object> values) {
        return this.creator.apply(values);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        String reference;
        ObjectReader objectReader;
        byte type;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((type = jsonReader.getType()) == -81) {
            jsonReader.next();
            return null;
        }
        if (type == -110 && (objectReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features)) != this) {
            return objectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        LinkedHashMap<Long, Object> valueMap = null;
        HashMap<Long, String> references = null;
        if (jsonReader.isArray()) {
            if (!jsonReader.isSupportBeanArray()) throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
            int entryCnt = jsonReader.startArray();
            for (int i = 0; i < entryCnt; ++i) {
                FieldReader fieldReader = this.fieldReaders[i];
                Object object = fieldReader.readFieldValue(jsonReader);
                if (valueMap == null) {
                    valueMap = new LinkedHashMap<Long, Object>();
                }
                valueMap.put(fieldReader.fieldNameHash, object);
            }
        } else {
            jsonReader.nextIfObjectStart();
            int i = 0;
            while (!jsonReader.nextIfObjectEnd()) {
                long hashCode = jsonReader.readFieldNameHashCode();
                if (hashCode != 0L) {
                    if (hashCode == HASH_TYPE && i == 0) {
                        String typeName;
                        long l = jsonReader.readTypeHashCode();
                        JSONReader.Context context = jsonReader.getContext();
                        ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(l);
                        if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) == null) {
                            throw new JSONException(jsonReader.info("auotype not support : " + typeName));
                        }
                        Object object = autoTypeObjectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
                        jsonReader.nextIfMatch(',');
                        return object;
                    }
                    FieldReader fieldReader = this.getFieldReader(hashCode);
                    if (fieldReader == null) {
                        this.processExtra(jsonReader, null);
                    } else if (jsonReader.isReference()) {
                        jsonReader.next();
                        reference = jsonReader.readString();
                        if (references == null) {
                            references = new HashMap<Long, String>();
                        }
                        references.put(hashCode, reference);
                    } else {
                        Object fieldValue = fieldReader.readFieldValue(jsonReader);
                        if (valueMap == null) {
                            valueMap = new LinkedHashMap();
                        }
                        valueMap.put(fieldReader.fieldNameHash, fieldValue);
                    }
                }
                ++i;
            }
        }
        Map<Long, Object> args = valueMap == null ? Collections.emptyMap() : valueMap;
        T object = this.createInstanceNoneDefaultConstructor(args);
        if (this.setterFieldReaders != null) {
            for (FieldReader fieldReader : this.setterFieldReaders) {
                Object fieldValue = args.get(fieldReader.fieldNameHash);
                fieldReader.accept(object, fieldValue);
            }
        }
        if (references == null) return object;
        for (Map.Entry entry : references.entrySet()) {
            Long hashCode = (Long)entry.getKey();
            reference = (String)entry.getValue();
            FieldReader fieldReader = this.getFieldReader(hashCode);
            if ("..".equals(reference)) {
                fieldReader.accept(object, object);
                continue;
            }
            fieldReader.addResolveTask(jsonReader, object, reference);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
        }
        if (jsonReader.isSupportBeanArray(features | this.features) && jsonReader.nextIfMatch('[')) {
            LinkedHashMap<Long, Object> valueMap = null;
            for (int i = 0; i < this.fieldReaders.length; ++i) {
                Object fieldValue = this.fieldReaders[i].readFieldValue(jsonReader);
                if (valueMap == null) {
                    valueMap = new LinkedHashMap<Long, Object>();
                }
                long hash = this.fieldReaders[i].fieldNameHash;
                valueMap.put(hash, fieldValue);
            }
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException(jsonReader.info("array not end, " + jsonReader.current()));
            }
            jsonReader.nextIfMatch(',');
            return this.createInstanceNoneDefaultConstructor(valueMap == null ? Collections.emptyMap() : valueMap);
        }
        boolean objectStart = jsonReader.nextIfObjectStart();
        if (!objectStart) {
            if (jsonReader.isTypeRedirect()) {
                jsonReader.setTypeRedirect(false);
            } else if (jsonReader.nextIfNullOrEmptyString()) {
                return null;
            }
        }
        JSONReader.Context context = jsonReader.getContext();
        long featuresAll = this.features | features | context.getFeatures();
        LinkedHashMap<Long, Object> valueMap = null;
        int i = 0;
        while (!jsonReader.nextIfMatch('}')) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode != 0L) {
                if (hashCode == this.typeKeyHashCode && i == 0) {
                    long typeHash = jsonReader.readTypeHashCode();
                    if (typeHash != this.typeNameHash) {
                        String typeName;
                        ObjectReader autoTypeObjectReader;
                        boolean supportAutoType;
                        boolean bl = supportAutoType = (featuresAll & JSONReader.Feature.SupportAutoType.mask) != 0L;
                        if (supportAutoType) {
                            autoTypeObjectReader = this.autoType(context, typeHash);
                            if (autoTypeObjectReader == null) {
                                typeName = jsonReader.getString();
                                autoTypeObjectReader = context.getObjectReaderAutoType(typeName, this.objectClass, this.features);
                            }
                        } else {
                            typeName = jsonReader.getString();
                            autoTypeObjectReader = context.getObjectReaderAutoType(typeName, this.objectClass);
                        }
                        if (autoTypeObjectReader == null) {
                            typeName = jsonReader.getString();
                            autoTypeObjectReader = context.getObjectReaderAutoType(typeName, this.objectClass, this.features);
                        }
                        if (autoTypeObjectReader != null) {
                            Object object = autoTypeObjectReader.readObject(jsonReader, fieldType, fieldName, 0L);
                            jsonReader.nextIfMatch(',');
                            return object;
                        }
                    }
                } else {
                    long hashCodeLCase;
                    FieldReader fieldReader = this.getFieldReader(hashCode);
                    if (fieldReader == null && (featuresAll & JSONReader.Feature.SupportSmartMatch.mask) != 0L && (hashCodeLCase = jsonReader.getNameHashCodeLCase()) != hashCode) {
                        fieldReader = this.getFieldReaderLCase(hashCodeLCase);
                    }
                    if (fieldReader == null) {
                        this.processExtra(jsonReader, null);
                    } else {
                        Object fieldValue = fieldReader.readFieldValue(jsonReader);
                        if (valueMap == null) {
                            valueMap = new LinkedHashMap<Long, Object>();
                        }
                        long hash = fieldReader instanceof FieldReaderObjectParam ? ((FieldReaderObjectParam)fieldReader).paramNameHash : fieldReader.fieldNameHash;
                        valueMap.put(hash, fieldValue);
                    }
                }
            }
            ++i;
        }
        Map argsMap = valueMap == null ? Collections.emptyMap() : valueMap;
        T object = this.creator.apply(argsMap);
        if (this.setterFieldReaders != null && valueMap != null) {
            for (int i2 = 0; i2 < this.setterFieldReaders.length; ++i2) {
                FieldReader fieldReader = this.setterFieldReaders[i2];
                Object fieldValue = valueMap.get(fieldReader.fieldNameHash);
                if (fieldValue == null) continue;
                fieldReader.accept(object, fieldValue);
            }
        }
        jsonReader.nextIfMatch(',');
        return object;
    }

    public T readFromCSV(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        LinkedHashMap<Long, Object> valueMap = new LinkedHashMap<Long, Object>();
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            FieldReader fieldReader = this.fieldReaders[i];
            Object fieldValue = fieldReader.readFieldValue(jsonReader);
            valueMap.put(fieldReader.fieldNameHash, fieldValue);
        }
        jsonReader.nextIfMatch('\n');
        return this.createInstanceNoneDefaultConstructor(valueMap);
    }

    @Override
    public T createInstance(Collection collection) {
        int index = 0;
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        LinkedHashMap valueMap = new LinkedHashMap();
        for (Object fieldValue : collection) {
            Function typeConvert;
            Class fieldClass;
            Class<?> valueClass;
            if (index >= this.fieldReaders.length) break;
            FieldReader fieldReader = this.fieldReaders[index];
            if (fieldValue != null && (valueClass = fieldValue.getClass()) != (fieldClass = fieldReader.fieldClass) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                fieldValue = typeConvert.apply(fieldValue);
            }
            if (valueMap == null) {
                valueMap = new LinkedHashMap();
            }
            long hash = fieldReader instanceof FieldReaderObjectParam ? ((FieldReaderObjectParam)fieldReader).paramNameHash : fieldReader.fieldNameHash;
            valueMap.put(hash, fieldValue);
            ++index;
        }
        T object = this.createInstanceNoneDefaultConstructor(valueMap == null ? Collections.emptyMap() : valueMap);
        return object;
    }

    @Override
    public T createInstance(Map map, long features) {
        Object fieldValue;
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        LinkedHashMap valueMap = null;
        for (Map.Entry entry : map.entrySet()) {
            Function typeConvert;
            Class fieldClass;
            Class<?> valueClass;
            String fieldName = entry.getKey().toString();
            fieldValue = entry.getValue();
            FieldReader fieldReader = this.getFieldReader(fieldName);
            if (fieldReader == null) continue;
            if (fieldValue != null && (valueClass = fieldValue.getClass()) != (fieldClass = fieldReader.fieldClass) && (typeConvert = provider.getTypeConvert(valueClass, fieldClass)) != null) {
                fieldValue = typeConvert.apply(fieldValue);
            }
            if (valueMap == null) {
                valueMap = new LinkedHashMap();
            }
            long hash = fieldReader instanceof FieldReaderObjectParam ? ((FieldReaderObjectParam)fieldReader).paramNameHash : fieldReader.fieldNameHash;
            valueMap.put(hash, fieldValue);
        }
        T object = this.createInstanceNoneDefaultConstructor(valueMap == null ? Collections.emptyMap() : valueMap);
        for (int i = 0; i < this.setterFieldReaders.length; ++i) {
            Class fieldClass;
            FieldReader fieldReader = this.setterFieldReaders[i];
            fieldValue = map.get(fieldReader.fieldName);
            if (fieldValue == null) continue;
            Class<?> valueClass = fieldValue.getClass();
            if (valueClass != (fieldClass = fieldReader.fieldClass)) {
                Function typeConvert = provider.getTypeConvert(valueClass, fieldClass);
                if (typeConvert != null) {
                    fieldValue = typeConvert.apply(fieldValue);
                } else if (fieldValue instanceof Map) {
                    ObjectReader objectReader = fieldReader.getObjectReader(JSONFactory.createReadContext(provider, new JSONReader.Feature[0]));
                    fieldValue = objectReader.createInstance((Map)fieldValue, features | fieldReader.features);
                }
            }
            fieldReader.accept(object, fieldValue);
        }
        return object;
    }
}

