/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load;

import android.support.annotation.Nullable;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public final class ImageHeaderParserUtils {
    private static final int MARK_POSITION = 0x500000;

    private ImageHeaderParserUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageHeaderParser.ImageType getType(List<ImageHeaderParser> parsers, @Nullable InputStream is, ArrayPool byteArrayPool) throws IOException {
        if (is == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        if (!is.markSupported()) {
            is = new RecyclableBufferedInputStream(is, byteArrayPool);
        }
        is.mark(0x500000);
        for (ImageHeaderParser parser : parsers) {
            try {
                ImageHeaderParser.ImageType type = parser.getType(is);
                if (type == ImageHeaderParser.ImageType.UNKNOWN) continue;
                ImageHeaderParser.ImageType imageType = type;
                return imageType;
            }
            finally {
                is.reset();
            }
        }
        return ImageHeaderParser.ImageType.UNKNOWN;
    }

    public static ImageHeaderParser.ImageType getType(List<ImageHeaderParser> parsers, @Nullable ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        for (ImageHeaderParser parser : parsers) {
            ImageHeaderParser.ImageType type = parser.getType(buffer);
            if (type == ImageHeaderParser.ImageType.UNKNOWN) continue;
            return type;
        }
        return ImageHeaderParser.ImageType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOrientation(List<ImageHeaderParser> parsers, @Nullable InputStream is, ArrayPool byteArrayPool) throws IOException {
        if (is == null) {
            return -1;
        }
        if (!is.markSupported()) {
            is = new RecyclableBufferedInputStream(is, byteArrayPool);
        }
        is.mark(0x500000);
        for (ImageHeaderParser parser : parsers) {
            try {
                int orientation = parser.getOrientation(is, byteArrayPool);
                if (orientation == -1) continue;
                int n = orientation;
                return n;
            }
            finally {
                is.reset();
            }
        }
        return -1;
    }
}

