/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.data.mediastore;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.ImageHeaderParserUtils;
import com.bumptech.glide.load.data.mediastore.FileService;
import com.bumptech.glide.load.data.mediastore.ThumbnailQuery;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

class ThumbnailStreamOpener {
    private static final String TAG = "ThumbStreamOpener";
    private static final FileService DEFAULT_SERVICE = new FileService();
    private final FileService service;
    private final ThumbnailQuery query;
    private final ArrayPool byteArrayPool;
    private final ContentResolver contentResolver;
    private final List<ImageHeaderParser> parsers;

    public ThumbnailStreamOpener(List<ImageHeaderParser> parsers, ThumbnailQuery query, ArrayPool byteArrayPool, ContentResolver contentResolver) {
        this(parsers, DEFAULT_SERVICE, query, byteArrayPool, contentResolver);
    }

    public ThumbnailStreamOpener(List<ImageHeaderParser> parsers, FileService service, ThumbnailQuery query, ArrayPool byteArrayPool, ContentResolver contentResolver) {
        this.service = service;
        this.query = query;
        this.byteArrayPool = byteArrayPool;
        this.contentResolver = contentResolver;
        this.parsers = parsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrientation(Uri uri) {
        InputStream is = null;
        try {
            is = this.contentResolver.openInputStream(uri);
            int n = ImageHeaderParserUtils.getOrientation(this.parsers, is, this.byteArrayPool);
            return n;
        }
        catch (IOException | NullPointerException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Failed to open uri: " + uri), (Throwable)e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open(Uri uri) throws FileNotFoundException {
        Uri thumbnailUri = null;
        InputStream inputStream = null;
        try (Cursor cursor = this.query.query(uri);){
            if (cursor == null || !cursor.moveToFirst()) {
                InputStream inputStream2 = null;
                return inputStream2;
            }
            String path = cursor.getString(0);
            if (TextUtils.isEmpty((CharSequence)path)) {
                InputStream inputStream3 = null;
                return inputStream3;
            }
            File file = this.service.get(path);
            if (this.service.exists(file) && this.service.length(file) > 0L) {
                thumbnailUri = Uri.fromFile((File)file);
            }
        }
        if (thumbnailUri != null) {
            try {
                inputStream = this.contentResolver.openInputStream(thumbnailUri);
            }
            catch (NullPointerException e) {
                throw (FileNotFoundException)new FileNotFoundException("NPE opening uri: " + thumbnailUri).initCause(e);
            }
        }
        return inputStream;
    }
}

