/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import android.content.Context;
import android.os.Build;
import android.support.v4.os.TraceCompat;
import android.support.v4.util.Pools;
import android.util.Log;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.Priority;
import com.bumptech.glide.Registry;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.EncodeStrategy;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceEncoder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.data.DataRewinder;
import com.bumptech.glide.load.engine.DataCacheGenerator;
import com.bumptech.glide.load.engine.DataCacheKey;
import com.bumptech.glide.load.engine.DataCacheWriter;
import com.bumptech.glide.load.engine.DataFetcherGenerator;
import com.bumptech.glide.load.engine.DecodeHelper;
import com.bumptech.glide.load.engine.DecodePath;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.EngineKey;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.Initializable;
import com.bumptech.glide.load.engine.LoadPath;
import com.bumptech.glide.load.engine.LockedResource;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.ResourceCacheGenerator;
import com.bumptech.glide.load.engine.ResourceCacheKey;
import com.bumptech.glide.load.engine.SourceGenerator;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.pool.FactoryPools;
import com.bumptech.glide.util.pool.StateVerifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class DecodeJob<R>
implements DataFetcherGenerator.FetcherReadyCallback,
Runnable,
Comparable<DecodeJob<?>>,
FactoryPools.Poolable {
    private static final String TAG = "DecodeJob";
    final DecodeHelper<R> decodeHelper = new DecodeHelper();
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private final StateVerifier stateVerifier = StateVerifier.newInstance();
    private final DiskCacheProvider diskCacheProvider;
    private final Pools.Pool<DecodeJob<?>> pool;
    final DeferredEncodeManager<?> deferredEncodeManager = new DeferredEncodeManager();
    private final ReleaseManager releaseManager = new ReleaseManager();
    private GlideContext glideContext;
    Key signature;
    private Priority priority;
    private EngineKey loadKey;
    int width;
    int height;
    DiskCacheStrategy diskCacheStrategy;
    Options options;
    private Callback<R> callback;
    private int order;
    private Stage stage;
    private RunReason runReason;
    private long startFetchTime;
    private boolean onlyRetrieveFromCache;
    private Thread currentThread;
    Key currentSourceKey;
    private Key currentAttemptingKey;
    private Object currentData;
    private DataSource currentDataSource;
    private DataFetcher<?> currentFetcher;
    private volatile DataFetcherGenerator currentGenerator;
    private volatile boolean isCallbackNotified;
    private volatile boolean isCancelled;

    DecodeJob(DiskCacheProvider diskCacheProvider, Pools.Pool<DecodeJob<?>> pool) {
        this.diskCacheProvider = diskCacheProvider;
        this.pool = pool;
    }

    DecodeJob<R> init(GlideContext glideContext, Object model, EngineKey loadKey, Key signature, int width, int height, Class<?> resourceClass, Class<R> transcodeClass, Priority priority, DiskCacheStrategy diskCacheStrategy, Map<Class<?>, Transformation<?>> transformations, boolean isTransformationRequired, boolean isScaleOnlyOrNoTransform, boolean onlyRetrieveFromCache, Options options, Callback<R> callback, int order) {
        this.decodeHelper.init(glideContext, model, signature, width, height, diskCacheStrategy, resourceClass, transcodeClass, priority, options, transformations, isTransformationRequired, isScaleOnlyOrNoTransform, this.diskCacheProvider);
        this.glideContext = glideContext;
        this.signature = signature;
        this.priority = priority;
        this.loadKey = loadKey;
        this.width = width;
        this.height = height;
        this.diskCacheStrategy = diskCacheStrategy;
        this.onlyRetrieveFromCache = onlyRetrieveFromCache;
        this.options = options;
        this.callback = callback;
        this.order = order;
        this.runReason = RunReason.INITIALIZE;
        return this;
    }

    boolean willDecodeFromCache() {
        Stage firstStage = this.getNextStage(Stage.INITIALIZE);
        return firstStage == Stage.RESOURCE_CACHE || firstStage == Stage.DATA_CACHE;
    }

    void release(boolean isRemovedFromQueue) {
        if (this.releaseManager.release(isRemovedFromQueue)) {
            this.releaseInternal();
        }
    }

    private void onEncodeComplete() {
        if (this.releaseManager.onEncodeComplete()) {
            this.releaseInternal();
        }
    }

    private void onLoadFailed() {
        if (this.releaseManager.onFailed()) {
            this.releaseInternal();
        }
    }

    private void releaseInternal() {
        this.releaseManager.reset();
        this.deferredEncodeManager.clear();
        this.decodeHelper.clear();
        this.isCallbackNotified = false;
        this.glideContext = null;
        this.signature = null;
        this.options = null;
        this.priority = null;
        this.loadKey = null;
        this.callback = null;
        this.stage = null;
        this.currentGenerator = null;
        this.currentThread = null;
        this.currentSourceKey = null;
        this.currentData = null;
        this.currentDataSource = null;
        this.currentFetcher = null;
        this.startFetchTime = 0L;
        this.isCancelled = false;
        this.exceptions.clear();
        this.pool.release((Object)this);
    }

    @Override
    public int compareTo(DecodeJob<?> other) {
        int result = this.getPriority() - super.getPriority();
        if (result == 0) {
            result = this.order - other.order;
        }
        return result;
    }

    private int getPriority() {
        return this.priority.ordinal();
    }

    public void cancel() {
        this.isCancelled = true;
        DataFetcherGenerator local = this.currentGenerator;
        if (local != null) {
            local.cancel();
        }
    }

    @Override
    public void run() {
        TraceCompat.beginSection((String)"DecodeJob#run");
        try {
            if (this.isCancelled) {
                this.notifyFailed();
                return;
            }
            this.runWrapped();
        }
        catch (RuntimeException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("DecodeJob threw unexpectedly, isCancelled: " + this.isCancelled + ", stage: " + (Object)((Object)this.stage)), (Throwable)e);
            }
            if (this.stage != Stage.ENCODE) {
                this.notifyFailed();
            }
            if (!this.isCancelled) {
                throw e;
            }
        }
        finally {
            if (this.currentFetcher != null) {
                this.currentFetcher.cleanup();
            }
            TraceCompat.endSection();
        }
    }

    private void runWrapped() {
        switch (this.runReason) {
            case INITIALIZE: {
                this.stage = this.getNextStage(Stage.INITIALIZE);
                this.currentGenerator = this.getNextGenerator();
                this.runGenerators();
                break;
            }
            case SWITCH_TO_SOURCE_SERVICE: {
                this.runGenerators();
                break;
            }
            case DECODE_DATA: {
                this.decodeFromRetrievedData();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized run reason: " + (Object)((Object)this.runReason));
            }
        }
    }

    private DataFetcherGenerator getNextGenerator() {
        switch (this.stage) {
            case RESOURCE_CACHE: {
                return new ResourceCacheGenerator(this.decodeHelper, this);
            }
            case DATA_CACHE: {
                return new DataCacheGenerator(this.decodeHelper, this);
            }
            case SOURCE: {
                return new SourceGenerator(this.decodeHelper, this);
            }
            case FINISHED: {
                return null;
            }
        }
        throw new IllegalStateException("Unrecognized stage: " + (Object)((Object)this.stage));
    }

    private void runGenerators() {
        this.currentThread = Thread.currentThread();
        this.startFetchTime = LogTime.getLogTime();
        boolean isStarted = false;
        while (!this.isCancelled && this.currentGenerator != null && !(isStarted = this.currentGenerator.startNext())) {
            this.stage = this.getNextStage(this.stage);
            this.currentGenerator = this.getNextGenerator();
            if (this.stage != Stage.SOURCE) continue;
            this.reschedule();
            return;
        }
        if ((this.stage == Stage.FINISHED || this.isCancelled) && !isStarted) {
            this.notifyFailed();
        }
    }

    private void notifyFailed() {
        this.setNotifiedOrThrow();
        GlideException e = new GlideException("Failed to load resource", new ArrayList<Exception>(this.exceptions));
        this.callback.onLoadFailed(e);
        this.onLoadFailed();
    }

    private void notifyComplete(Resource<R> resource, DataSource dataSource) {
        this.setNotifiedOrThrow();
        this.callback.onResourceReady(resource, dataSource);
    }

    private void setNotifiedOrThrow() {
        this.stateVerifier.throwIfRecycled();
        if (this.isCallbackNotified) {
            throw new IllegalStateException("Already notified");
        }
        this.isCallbackNotified = true;
    }

    private Stage getNextStage(Stage current) {
        switch (current) {
            case INITIALIZE: {
                return this.diskCacheStrategy.decodeCachedResource() ? Stage.RESOURCE_CACHE : this.getNextStage(Stage.RESOURCE_CACHE);
            }
            case RESOURCE_CACHE: {
                return this.diskCacheStrategy.decodeCachedData() ? Stage.DATA_CACHE : this.getNextStage(Stage.DATA_CACHE);
            }
            case DATA_CACHE: {
                return this.onlyRetrieveFromCache ? Stage.FINISHED : Stage.SOURCE;
            }
            case SOURCE: 
            case FINISHED: {
                return Stage.FINISHED;
            }
        }
        throw new IllegalArgumentException("Unrecognized stage: " + (Object)((Object)current));
    }

    @Override
    public void reschedule() {
        this.runReason = RunReason.SWITCH_TO_SOURCE_SERVICE;
        this.callback.reschedule(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataFetcherReady(Key sourceKey, Object data, DataFetcher<?> fetcher, DataSource dataSource, Key attemptedKey) {
        this.currentSourceKey = sourceKey;
        this.currentData = data;
        this.currentFetcher = fetcher;
        this.currentDataSource = dataSource;
        this.currentAttemptingKey = attemptedKey;
        if (Thread.currentThread() != this.currentThread) {
            this.runReason = RunReason.DECODE_DATA;
            this.callback.reschedule(this);
        } else {
            TraceCompat.beginSection((String)"DecodeJob.decodeFromRetrievedData");
            try {
                this.decodeFromRetrievedData();
            }
            finally {
                TraceCompat.endSection();
            }
        }
    }

    @Override
    public void onDataFetcherFailed(Key attemptedKey, Exception e, DataFetcher<?> fetcher, DataSource dataSource) {
        fetcher.cleanup();
        GlideException exception = new GlideException("Fetching data failed", e);
        exception.setLoggingDetails(attemptedKey, dataSource, fetcher.getDataClass());
        this.exceptions.add(exception);
        if (Thread.currentThread() != this.currentThread) {
            this.runReason = RunReason.SWITCH_TO_SOURCE_SERVICE;
            this.callback.reschedule(this);
        } else {
            this.runGenerators();
        }
    }

    private void decodeFromRetrievedData() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Retrieved data", this.startFetchTime, "data: " + this.currentData + ", cache key: " + this.currentSourceKey + ", fetcher: " + this.currentFetcher);
        }
        Resource<R> resource = null;
        try {
            resource = this.decodeFromData(this.currentFetcher, this.currentData, this.currentDataSource);
        }
        catch (GlideException e) {
            e.setLoggingDetails(this.currentAttemptingKey, this.currentDataSource);
            this.exceptions.add(e);
        }
        if (resource != null) {
            this.notifyEncodeAndRelease(resource, this.currentDataSource);
        } else {
            this.runGenerators();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEncodeAndRelease(Resource<R> resource, DataSource dataSource) {
        if (resource instanceof Initializable) {
            ((Initializable)((Object)resource)).initialize();
        }
        Resource<R> result = resource;
        LockedResource<R> lockedResource = null;
        if (this.deferredEncodeManager.hasResourceToEncode()) {
            lockedResource = LockedResource.obtain(resource);
            result = lockedResource;
        }
        this.notifyComplete(result, dataSource);
        this.stage = Stage.ENCODE;
        try {
            if (this.deferredEncodeManager.hasResourceToEncode()) {
                this.deferredEncodeManager.encode(this.diskCacheProvider, this.options);
            }
        }
        finally {
            if (lockedResource != null) {
                lockedResource.unlock();
            }
            this.onEncodeComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Data> Resource<R> decodeFromData(DataFetcher<?> fetcher, Data data, DataSource dataSource) throws GlideException {
        try {
            if (data == null) {
                Resource<R> resource = null;
                return resource;
            }
            long startTime = LogTime.getLogTime();
            Resource<R> result = this.decodeFromFetcher(data, dataSource);
            if (Log.isLoggable((String)TAG, (int)2)) {
                this.logWithTimeAndKey("Decoded result " + result, startTime);
            }
            Resource<R> resource = result;
            return resource;
        }
        finally {
            fetcher.cleanup();
        }
    }

    private <Data> Resource<R> decodeFromFetcher(Data data, DataSource dataSource) throws GlideException {
        LoadPath<?, ?, R> path = this.decodeHelper.getLoadPath(data.getClass());
        return this.runLoadPath(data, dataSource, path);
    }

    private Options getOptionsWithHardwareConfig(DataSource dataSource) {
        Options options = this.options;
        if (Build.VERSION.SDK_INT < 26) {
            return options;
        }
        if (options.get(Downsampler.ALLOW_HARDWARE_CONFIG) != null) {
            return options;
        }
        if (dataSource == DataSource.RESOURCE_DISK_CACHE || this.decodeHelper.isScaleOnlyOrNoTransform()) {
            options = new Options();
            options.putAll(this.options);
            options.set(Downsampler.ALLOW_HARDWARE_CONFIG, true);
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Data, ResourceType> Resource<R> runLoadPath(Data data, DataSource dataSource, LoadPath<Data, ResourceType, R> path) throws GlideException {
        Options options = this.getOptionsWithHardwareConfig(dataSource);
        DataRewinder<Data> rewinder = this.glideContext.getRegistry().getRewinder(data);
        try {
            Resource<R> resource = path.load(rewinder, options, this.width, this.height, new DecodeCallback(dataSource));
            return resource;
        }
        finally {
            rewinder.cleanup();
        }
    }

    private void logWithTimeAndKey(String message, long startTime) {
        this.logWithTimeAndKey(message, startTime, null);
    }

    private void logWithTimeAndKey(String message, long startTime, String extraArgs) {
        Log.v((String)TAG, (String)(message + " in " + LogTime.getElapsedMillis(startTime) + ", load key: " + this.loadKey + (extraArgs != null ? ", " + extraArgs : "") + ", thread: " + Thread.currentThread().getName()));
    }

    @Override
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }

    private static enum Stage {
        INITIALIZE,
        RESOURCE_CACHE,
        DATA_CACHE,
        SOURCE,
        ENCODE,
        FINISHED;

    }

    private static enum RunReason {
        INITIALIZE,
        SWITCH_TO_SOURCE_SERVICE,
        DECODE_DATA;

    }

    static interface DiskCacheProvider {
        public DiskCache getDiskCache();
    }

    static interface Callback<R> {
        public void onResourceReady(Resource<R> var1, DataSource var2);

        public void onLoadFailed(GlideException var1);

        public void reschedule(DecodeJob<?> var1);
    }

    private static class DeferredEncodeManager<Z> {
        private Key key;
        private ResourceEncoder<Z> encoder;
        private LockedResource<Z> toEncode;

        DeferredEncodeManager() {
        }

        <X> void init(Key key, ResourceEncoder<X> encoder, LockedResource<X> toEncode) {
            this.key = key;
            this.encoder = encoder;
            this.toEncode = toEncode;
        }

        void encode(DiskCacheProvider diskCacheProvider, Options options) {
            TraceCompat.beginSection((String)"DecodeJob.encode");
            try {
                diskCacheProvider.getDiskCache().put(this.key, new DataCacheWriter<LockedResource<Z>>(this.encoder, this.toEncode, options));
            }
            finally {
                this.toEncode.unlock();
                TraceCompat.endSection();
            }
        }

        boolean hasResourceToEncode() {
            return this.toEncode != null;
        }

        void clear() {
            this.key = null;
            this.encoder = null;
            this.toEncode = null;
        }
    }

    private static class ReleaseManager {
        private boolean isReleased;
        private boolean isEncodeComplete;
        private boolean isFailed;

        ReleaseManager() {
        }

        synchronized boolean release(boolean isRemovedFromQueue) {
            this.isReleased = true;
            return this.isComplete(isRemovedFromQueue);
        }

        synchronized boolean onEncodeComplete() {
            this.isEncodeComplete = true;
            return this.isComplete(false);
        }

        synchronized boolean onFailed() {
            this.isFailed = true;
            return this.isComplete(false);
        }

        synchronized void reset() {
            this.isEncodeComplete = false;
            this.isReleased = false;
            this.isFailed = false;
        }

        private boolean isComplete(boolean isRemovedFromQueue) {
            return (this.isFailed || isRemovedFromQueue || this.isEncodeComplete) && this.isReleased;
        }
    }

    private final class DecodeCallback<Z>
    implements DecodePath.DecodeCallback<Z> {
        private final DataSource dataSource;

        DecodeCallback(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Resource<Z> onResourceDecoded(Resource<Z> decoded) {
            boolean isFromAlternateCacheKey;
            EncodeStrategy encodeStrategy;
            ResourceEncoder<Z> encoder;
            Class<Z> resourceSubClass = this.getResourceClass(decoded);
            Transformation<Z> appliedTransformation = null;
            Resource<Z> transformed = decoded;
            if (this.dataSource != DataSource.RESOURCE_DISK_CACHE) {
                appliedTransformation = DecodeJob.this.decodeHelper.getTransformation(resourceSubClass);
                transformed = appliedTransformation.transform((Context)DecodeJob.this.glideContext, decoded, DecodeJob.this.width, DecodeJob.this.height);
            }
            if (!decoded.equals(transformed)) {
                decoded.recycle();
            }
            if (DecodeJob.this.decodeHelper.isResourceEncoderAvailable(transformed)) {
                encoder = DecodeJob.this.decodeHelper.getResultEncoder(transformed);
                encodeStrategy = encoder.getEncodeStrategy(DecodeJob.this.options);
            } else {
                encoder = null;
                encodeStrategy = EncodeStrategy.NONE;
            }
            Resource<Z> result = transformed;
            boolean bl = isFromAlternateCacheKey = !DecodeJob.this.decodeHelper.isSourceKey(DecodeJob.this.currentSourceKey);
            if (DecodeJob.this.diskCacheStrategy.isResourceCacheable(isFromAlternateCacheKey, this.dataSource, encodeStrategy)) {
                Key key;
                if (encoder == null) {
                    throw new Registry.NoResultEncoderAvailableException(transformed.get().getClass());
                }
                if (encodeStrategy == EncodeStrategy.SOURCE) {
                    key = new DataCacheKey(DecodeJob.this.currentSourceKey, DecodeJob.this.signature);
                } else if (encodeStrategy == EncodeStrategy.TRANSFORMED) {
                    key = new ResourceCacheKey(DecodeJob.this.currentSourceKey, DecodeJob.this.signature, DecodeJob.this.width, DecodeJob.this.height, appliedTransformation, resourceSubClass, DecodeJob.this.options);
                } else {
                    throw new IllegalArgumentException("Unknown strategy: " + (Object)((Object)encodeStrategy));
                }
                LockedResource<Z> lockedResult = LockedResource.obtain(transformed);
                DecodeJob.this.deferredEncodeManager.init(key, encoder, lockedResult);
                result = lockedResult;
            }
            return result;
        }

        private Class<Z> getResourceClass(Resource<Z> resource) {
            return resource.get().getClass();
        }
    }
}

