/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.util.LruCache;
import com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

final class ResourceCacheKey
implements Key {
    private static final LruCache<Class<?>, byte[]> RESOURCE_CLASS_BYTES = new LruCache(50);
    private final Key sourceKey;
    private final Key signature;
    private final int width;
    private final int height;
    private final Class<?> decodedResourceClass;
    private final Options options;
    private final Transformation<?> transformation;

    public ResourceCacheKey(Key sourceKey, Key signature, int width, int height, Transformation<?> appliedTransformation, Class<?> decodedResourceClass, Options options) {
        this.sourceKey = sourceKey;
        this.signature = signature;
        this.width = width;
        this.height = height;
        this.transformation = appliedTransformation;
        this.decodedResourceClass = decodedResourceClass;
        this.options = options;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ResourceCacheKey) {
            ResourceCacheKey other = (ResourceCacheKey)o;
            return this.height == other.height && this.width == other.width && Util.bothNullOrEqual(this.transformation, other.transformation) && this.decodedResourceClass.equals(other.decodedResourceClass) && this.sourceKey.equals(other.sourceKey) && this.signature.equals(other.signature) && this.options.equals(other.options);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.sourceKey.hashCode();
        result = 31 * result + this.signature.hashCode();
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        if (this.transformation != null) {
            result = 31 * result + this.transformation.hashCode();
        }
        result = 31 * result + this.decodedResourceClass.hashCode();
        result = 31 * result + this.options.hashCode();
        return result;
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        byte[] dimensions = ByteBuffer.allocate(8).putInt(this.width).putInt(this.height).array();
        this.signature.updateDiskCacheKey(messageDigest);
        this.sourceKey.updateDiskCacheKey(messageDigest);
        messageDigest.update(dimensions);
        if (this.transformation != null) {
            this.transformation.updateDiskCacheKey(messageDigest);
        }
        this.options.updateDiskCacheKey(messageDigest);
        messageDigest.update(this.getResourceClassBytes());
    }

    private byte[] getResourceClassBytes() {
        byte[] result = RESOURCE_CLASS_BYTES.get(this.decodedResourceClass);
        if (result == null) {
            result = this.decodedResourceClass.getName().getBytes(CHARSET);
            RESOURCE_CLASS_BYTES.put(this.decodedResourceClass, result);
        }
        return result;
    }

    public String toString() {
        return "ResourceCacheKey{sourceKey=" + this.sourceKey + ", signature=" + this.signature + ", width=" + this.width + ", height=" + this.height + ", decodedResourceClass=" + this.decodedResourceClass + ", transformation='" + this.transformation + '\'' + ", options=" + this.options + '}';
    }
}

