/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.support.v4.util.Pools;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.util.LruCache;
import com.bumptech.glide.util.Util;
import com.bumptech.glide.util.pool.FactoryPools;
import com.bumptech.glide.util.pool.StateVerifier;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SafeKeyGenerator {
    private final LruCache<Key, String> loadIdToSafeHash = new LruCache(1000);
    private final Pools.Pool<PoolableDigestContainer> digestPool = FactoryPools.threadSafe(10, new FactoryPools.Factory<PoolableDigestContainer>(){

        @Override
        public PoolableDigestContainer create() {
            try {
                return new PoolableDigestContainer(MessageDigest.getInstance("SHA-256"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSafeKey(Key key) {
        String safeKey;
        LruCache<Key, String> lruCache = this.loadIdToSafeHash;
        synchronized (lruCache) {
            safeKey = this.loadIdToSafeHash.get(key);
        }
        if (safeKey == null) {
            safeKey = this.calculateHexStringDigest(key);
        }
        lruCache = this.loadIdToSafeHash;
        synchronized (lruCache) {
            this.loadIdToSafeHash.put(key, safeKey);
        }
        return safeKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateHexStringDigest(Key key) {
        PoolableDigestContainer container = (PoolableDigestContainer)this.digestPool.acquire();
        try {
            key.updateDiskCacheKey(container.messageDigest);
            String string = Util.sha256BytesToHex(container.messageDigest.digest());
            return string;
        }
        finally {
            this.digestPool.release((Object)container);
        }
    }

    private static final class PoolableDigestContainer
    implements FactoryPools.Poolable {
        final MessageDigest messageDigest;
        private final StateVerifier stateVerifier = StateVerifier.newInstance();

        PoolableDigestContainer(MessageDigest messageDigest) {
            this.messageDigest = messageDigest;
        }

        @Override
        public StateVerifier getVerifier() {
            return this.stateVerifier;
        }
    }
}

