/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.executor;

import android.os.Process;
import android.os.StrictMode;
import android.support.annotation.NonNull;
import android.util.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class GlideExecutor
extends ThreadPoolExecutor {
    public static final String DEFAULT_SOURCE_EXECUTOR_NAME = "source";
    public static final String DEFAULT_DISK_CACHE_EXECUTOR_NAME = "disk-cache";
    public static final int DEFAULT_DISK_CACHE_EXECUTOR_THREADS = 1;
    private static final String TAG = "GlideExecutor";
    private static final String CPU_NAME_REGEX = "cpu[0-9]+";
    private static final String CPU_LOCATION = "/sys/devices/system/cpu/";
    private static final int MAXIMUM_AUTOMATIC_THREAD_COUNT = 4;
    private final boolean executeSynchronously;
    private static final String SOURCE_UNLIMITED_EXECUTOR_NAME = "source-unlimited";
    private static final long SOURCE_UNLIMITED_EXECUTOR_KEEP_ALIVE_TIME_MS = TimeUnit.SECONDS.toMillis(10L);

    public static GlideExecutor newDiskCacheExecutor() {
        return GlideExecutor.newDiskCacheExecutor(1, DEFAULT_DISK_CACHE_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT);
    }

    public static GlideExecutor newDiskCacheExecutor(int threadCount, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return new GlideExecutor(threadCount, name, uncaughtThrowableStrategy, true, false);
    }

    public static GlideExecutor newSourceExecutor() {
        return GlideExecutor.newSourceExecutor(GlideExecutor.calculateBestThreadCount(), DEFAULT_SOURCE_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT);
    }

    public static GlideExecutor newSourceExecutor(int threadCount, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return new GlideExecutor(threadCount, name, uncaughtThrowableStrategy, false, false);
    }

    public static GlideExecutor newUnlimitedSourceExecutor() {
        return new GlideExecutor(0, Integer.MAX_VALUE, SOURCE_UNLIMITED_EXECUTOR_KEEP_ALIVE_TIME_MS, SOURCE_UNLIMITED_EXECUTOR_NAME, UncaughtThrowableStrategy.DEFAULT, false, false, new SynchronousQueue<Runnable>());
    }

    GlideExecutor(int poolSize, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean preventNetworkOperations, boolean executeSynchronously) {
        this(poolSize, poolSize, 0L, name, uncaughtThrowableStrategy, preventNetworkOperations, executeSynchronously);
    }

    GlideExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTimeInMs, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean preventNetworkOperations, boolean executeSynchronously) {
        this(corePoolSize, maximumPoolSize, keepAliveTimeInMs, name, uncaughtThrowableStrategy, preventNetworkOperations, executeSynchronously, new PriorityBlockingQueue<Runnable>());
    }

    GlideExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTimeInMs, String name, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean preventNetworkOperations, boolean executeSynchronously, BlockingQueue<Runnable> queue) {
        super(corePoolSize, maximumPoolSize, keepAliveTimeInMs, TimeUnit.MILLISECONDS, queue, new DefaultThreadFactory(name, uncaughtThrowableStrategy, preventNetworkOperations));
        this.executeSynchronously = executeSynchronously;
    }

    @Override
    public void execute(Runnable command) {
        if (this.executeSynchronously) {
            command.run();
        } else {
            super.execute(command);
        }
    }

    @Override
    @NonNull
    public Future<?> submit(Runnable task) {
        return this.maybeWait(super.submit(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Future<T> maybeWait(Future<T> future) {
        if (this.executeSynchronously) {
            boolean interrupted = false;
            try {
                while (!future.isDone()) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return future;
    }

    @Override
    @NonNull
    public <T> Future<T> submit(Runnable task, T result) {
        return this.maybeWait(super.submit(task, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.maybeWait(super.submit(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calculateBestThreadCount() {
        StrictMode.ThreadPolicy originalPolicy = StrictMode.allowThreadDiskReads();
        File[] cpus = null;
        try {
            File cpuInfo = new File(CPU_LOCATION);
            final Pattern cpuNamePattern = Pattern.compile(CPU_NAME_REGEX);
            cpus = cpuInfo.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return cpuNamePattern.matcher(s).matches();
                }
            });
        }
        catch (Throwable t) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"Failed to calculate accurate cpu count", (Throwable)t);
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalPolicy);
        }
        int cpuCount = cpus != null ? cpus.length : 0;
        int availableProcessors = Math.max(1, Runtime.getRuntime().availableProcessors());
        return Math.min(4, Math.max(availableProcessors, cpuCount));
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final String name;
        final UncaughtThrowableStrategy uncaughtThrowableStrategy;
        final boolean preventNetworkOperations;
        private int threadNum;

        DefaultThreadFactory(String name, UncaughtThrowableStrategy uncaughtThrowableStrategy, boolean preventNetworkOperations) {
            this.name = name;
            this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
            this.preventNetworkOperations = preventNetworkOperations;
        }

        @Override
        public synchronized Thread newThread(@NonNull Runnable runnable) {
            Thread result = new Thread(runnable, "glide-" + this.name + "-thread-" + this.threadNum){

                @Override
                public void run() {
                    Process.setThreadPriority((int)9);
                    if (DefaultThreadFactory.this.preventNetworkOperations) {
                        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectNetwork().penaltyDeath().build());
                    }
                    try {
                        super.run();
                    }
                    catch (Throwable t) {
                        DefaultThreadFactory.this.uncaughtThrowableStrategy.handle(t);
                    }
                }
            };
            ++this.threadNum;
            return result;
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                if (t != null && Log.isLoggable((String)GlideExecutor.TAG, (int)6)) {
                    Log.e((String)GlideExecutor.TAG, (String)"Request threw uncaught throwable", (Throwable)t);
                }
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                if (t != null) {
                    throw new RuntimeException("Request threw uncaught throwable", t);
                }
            }
        };

        public static final UncaughtThrowableStrategy DEFAULT;

        protected void handle(Throwable t) {
        }

        static {
            DEFAULT = LOG;
        }
    }
}

