/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.support.annotation.NonNull;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.bumptech.glide.signature.EmptySignature;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteArrayLoader<Data>
implements ModelLoader<byte[], Data> {
    private final Converter<Data> converter;

    public ByteArrayLoader(Converter<Data> converter) {
        this.converter = converter;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(byte[] model, int width, int height, Options options) {
        return new ModelLoader.LoadData<Data>(EmptySignature.obtain(), new Fetcher<Data>(model, this.converter));
    }

    @Override
    public boolean handles(byte[] model) {
        return true;
    }

    public static class StreamFactory
    implements ModelLoaderFactory<byte[], InputStream> {
        @Override
        public ModelLoader<byte[], InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new ByteArrayLoader<InputStream>(new Converter<InputStream>(){

                @Override
                public InputStream convert(byte[] model) {
                    return new ByteArrayInputStream(model);
                }

                @Override
                public Class<InputStream> getDataClass() {
                    return InputStream.class;
                }
            });
        }

        @Override
        public void teardown() {
        }
    }

    public static class ByteBufferFactory
    implements ModelLoaderFactory<byte[], ByteBuffer> {
        @Override
        public ModelLoader<byte[], ByteBuffer> build(MultiModelLoaderFactory multiFactory) {
            return new ByteArrayLoader<ByteBuffer>(new Converter<ByteBuffer>(){

                @Override
                public ByteBuffer convert(byte[] model) {
                    return ByteBuffer.wrap(model);
                }

                @Override
                public Class<ByteBuffer> getDataClass() {
                    return ByteBuffer.class;
                }
            });
        }

        @Override
        public void teardown() {
        }
    }

    private static class Fetcher<Data>
    implements DataFetcher<Data> {
        private final byte[] model;
        private final Converter<Data> converter;

        public Fetcher(byte[] model, Converter<Data> converter) {
            this.model = model;
            this.converter = converter;
        }

        @Override
        public void loadData(Priority priority, DataFetcher.DataCallback<? super Data> callback) {
            Data result = this.converter.convert(this.model);
            callback.onDataReady(result);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<Data> getDataClass() {
            return this.converter.getDataClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }

    public static interface Converter<Data> {
        public Data convert(byte[] var1);

        public Class<Data> getDataClass();
    }
}

