/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import android.support.annotation.NonNull;
import android.util.Log;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.bumptech.glide.signature.ObjectKey;
import com.bumptech.glide.util.ByteBufferUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferFileLoader
implements ModelLoader<File, ByteBuffer> {
    private static final String TAG = "ByteBufferFileLoader";

    @Override
    public ModelLoader.LoadData<ByteBuffer> buildLoadData(File file, int width, int height, Options options) {
        return new ModelLoader.LoadData<ByteBuffer>(new ObjectKey(file), new ByteBufferFetcher(file));
    }

    @Override
    public boolean handles(File file) {
        return true;
    }

    private static class ByteBufferFetcher
    implements DataFetcher<ByteBuffer> {
        private final File file;

        public ByteBufferFetcher(File file) {
            this.file = file;
        }

        @Override
        public void loadData(Priority priority, DataFetcher.DataCallback<? super ByteBuffer> callback) {
            ByteBuffer result = null;
            try {
                result = ByteBufferUtil.fromFile(this.file);
            }
            catch (IOException e) {
                if (Log.isLoggable((String)ByteBufferFileLoader.TAG, (int)3)) {
                    Log.d((String)ByteBufferFileLoader.TAG, (String)"Failed to obtain ByteBuffer for file", (Throwable)e);
                }
                callback.onLoadFailed(e);
                return;
            }
            callback.onDataReady(result);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<ByteBuffer> getDataClass() {
            return ByteBuffer.class;
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }

    public static class Factory
    implements ModelLoaderFactory<File, ByteBuffer> {
        @Override
        public ModelLoader<File, ByteBuffer> build(MultiModelLoaderFactory multiFactory) {
            return new ByteBufferFileLoader();
        }

        @Override
        public void teardown() {
        }
    }
}

