/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.LazyBitmapDrawableResource;
import com.bumptech.glide.util.Preconditions;
import java.security.MessageDigest;

public class BitmapDrawableTransformation
implements Transformation<BitmapDrawable> {
    private final Transformation<Bitmap> wrapped;

    public BitmapDrawableTransformation(Transformation<Bitmap> wrapped) {
        this.wrapped = Preconditions.checkNotNull(wrapped);
    }

    @Deprecated
    public BitmapDrawableTransformation(Context context, Transformation<Bitmap> wrapped) {
        this(wrapped);
    }

    @Deprecated
    public BitmapDrawableTransformation(Context context, BitmapPool bitmapPool, Transformation<Bitmap> wrapped) {
        this(wrapped);
    }

    @Override
    public Resource<BitmapDrawable> transform(Context context, Resource<BitmapDrawable> drawableResourceToTransform, int outWidth, int outHeight) {
        BitmapPool bitmapPool;
        BitmapDrawable drawableToTransform = drawableResourceToTransform.get();
        Bitmap bitmapToTransform = drawableToTransform.getBitmap();
        BitmapResource bitmapResourceToTransform = BitmapResource.obtain(bitmapToTransform, bitmapPool = Glide.get(context).getBitmapPool());
        Resource<Bitmap> transformedBitmapResource = this.wrapped.transform(context, bitmapResourceToTransform, outWidth, outHeight);
        if (transformedBitmapResource.equals(bitmapResourceToTransform)) {
            return drawableResourceToTransform;
        }
        return LazyBitmapDrawableResource.obtain(context, transformedBitmapResource.get());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BitmapDrawableTransformation) {
            BitmapDrawableTransformation other = (BitmapDrawableTransformation)o;
            return this.wrapped.equals(other.wrapped);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        this.wrapped.updateDiskCacheKey(messageDigest);
    }
}

