/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.util.Log;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public final class DefaultImageHeaderParser
implements ImageHeaderParser {
    private static final String TAG = "DfltImageHeaderParser";
    private static final int GIF_HEADER = 4671814;
    private static final int PNG_HEADER = -1991225785;
    static final int EXIF_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    static final byte[] JPEG_EXIF_SEGMENT_PREAMBLE_BYTES = "Exif\u0000\u0000".getBytes(Charset.forName("UTF-8"));
    private static final int SEGMENT_SOS = 218;
    private static final int MARKER_EOI = 217;
    static final int SEGMENT_START_ID = 255;
    static final int EXIF_SEGMENT_TYPE = 225;
    private static final int ORIENTATION_TAG_TYPE = 274;
    private static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int RIFF_HEADER = 1380533830;
    private static final int WEBP_HEADER = 1464156752;
    private static final int VP8_HEADER = 1448097792;
    private static final int VP8_HEADER_MASK = -256;
    private static final int VP8_HEADER_TYPE_MASK = 255;
    private static final int VP8_HEADER_TYPE_EXTENDED = 88;
    private static final int VP8_HEADER_TYPE_LOSSLESS = 76;
    private static final int WEBP_EXTENDED_ALPHA_FLAG = 16;
    private static final int WEBP_LOSSLESS_ALPHA_FLAG = 8;

    @Override
    public ImageHeaderParser.ImageType getType(InputStream is) throws IOException {
        return this.getType(new StreamReader(Preconditions.checkNotNull(is)));
    }

    @Override
    public ImageHeaderParser.ImageType getType(ByteBuffer byteBuffer) throws IOException {
        return this.getType(new ByteBufferReader(Preconditions.checkNotNull(byteBuffer)));
    }

    @Override
    public int getOrientation(InputStream is, ArrayPool byteArrayPool) throws IOException {
        return this.getOrientation(new StreamReader(Preconditions.checkNotNull(is)), Preconditions.checkNotNull(byteArrayPool));
    }

    @Override
    public int getOrientation(ByteBuffer byteBuffer, ArrayPool byteArrayPool) throws IOException {
        return this.getOrientation(new ByteBufferReader(Preconditions.checkNotNull(byteBuffer)), Preconditions.checkNotNull(byteArrayPool));
    }

    private ImageHeaderParser.ImageType getType(Reader reader) throws IOException {
        int firstTwoBytes = reader.getUInt16();
        if (firstTwoBytes == 65496) {
            return ImageHeaderParser.ImageType.JPEG;
        }
        int firstFourBytes = firstTwoBytes << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if (firstFourBytes == -1991225785) {
            reader.skip(21L);
            int alpha = reader.getByte();
            return alpha >= 3 ? ImageHeaderParser.ImageType.PNG_A : ImageHeaderParser.ImageType.PNG;
        }
        if (firstFourBytes >> 8 == 4671814) {
            return ImageHeaderParser.ImageType.GIF;
        }
        if (firstFourBytes != 1380533830) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        reader.skip(4L);
        int thirdFourBytes = reader.getUInt16() << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if (thirdFourBytes != 1464156752) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        int fourthFourBytes = reader.getUInt16() << 16 & 0xFFFF0000 | reader.getUInt16() & 0xFFFF;
        if ((fourthFourBytes & 0xFFFFFF00) != 1448097792) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        if ((fourthFourBytes & 0xFF) == 88) {
            reader.skip(4L);
            return (reader.getByte() & 0x10) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
        }
        if ((fourthFourBytes & 0xFF) == 76) {
            reader.skip(4L);
            return (reader.getByte() & 8) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
        }
        return ImageHeaderParser.ImageType.WEBP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOrientation(Reader reader, ArrayPool byteArrayPool) throws IOException {
        int magicNumber = reader.getUInt16();
        if (!DefaultImageHeaderParser.handles(magicNumber)) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Parser doesn't handle magic number: " + magicNumber));
            }
            return -1;
        }
        int exifSegmentLength = this.moveToExifSegmentAndGetLength(reader);
        if (exifSegmentLength == -1) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to parse exif segment length, or exif segment not found");
            }
            return -1;
        }
        byte[] exifData = byteArrayPool.get(exifSegmentLength, byte[].class);
        try {
            int n = this.parseExifSegment(reader, exifData, exifSegmentLength);
            return n;
        }
        finally {
            byteArrayPool.put(exifData, byte[].class);
        }
    }

    private int parseExifSegment(Reader reader, byte[] tempArray, int exifSegmentLength) throws IOException {
        int read = reader.read(tempArray, exifSegmentLength);
        if (read != exifSegmentLength) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to read exif segment data, length: " + exifSegmentLength + ", actually read: " + read));
            }
            return -1;
        }
        boolean hasJpegExifPreamble = this.hasJpegExifPreamble(tempArray, exifSegmentLength);
        if (hasJpegExifPreamble) {
            return DefaultImageHeaderParser.parseExifSegment(new RandomAccessReader(tempArray, exifSegmentLength));
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Missing jpeg exif preamble");
        }
        return -1;
    }

    private boolean hasJpegExifPreamble(byte[] exifData, int exifSegmentLength) {
        boolean result;
        boolean bl = result = exifData != null && exifSegmentLength > JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length;
        if (result) {
            for (int i = 0; i < JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length; ++i) {
                if (exifData[i] == JPEG_EXIF_SEGMENT_PREAMBLE_BYTES[i]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private int moveToExifSegmentAndGetLength(Reader reader) throws IOException {
        int segmentLength;
        block7: {
            short segmentType;
            long skipped;
            do {
                short segmentId;
                if ((segmentId = reader.getUInt8()) != 255) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)("Unknown segmentId=" + segmentId));
                    }
                    return -1;
                }
                segmentType = reader.getUInt8();
                if (segmentType == 218) {
                    return -1;
                }
                if (segmentType == 217) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)"Found MARKER_EOI in exif segment");
                    }
                    return -1;
                }
                segmentLength = reader.getUInt16() - 2;
                if (segmentType == 225) break block7;
            } while ((skipped = reader.skip(segmentLength)) == (long)segmentLength);
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to skip enough data, type: " + segmentType + ", wanted to skip: " + segmentLength + ", but actually skipped: " + skipped));
            }
            return -1;
        }
        return segmentLength;
    }

    private static int parseExifSegment(RandomAccessReader segmentData) {
        ByteOrder byteOrder;
        int headerOffsetSize = JPEG_EXIF_SEGMENT_PREAMBLE.length();
        short byteOrderIdentifier = segmentData.getInt16(headerOffsetSize);
        if (byteOrderIdentifier == 19789) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if (byteOrderIdentifier == 18761) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unknown endianness = " + byteOrderIdentifier));
            }
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        segmentData.order(byteOrder);
        int firstIfdOffset = segmentData.getInt32(headerOffsetSize + 4) + headerOffsetSize;
        int tagCount = segmentData.getInt16(firstIfdOffset);
        for (int i = 0; i < tagCount; ++i) {
            int byteCount;
            int tagOffset = DefaultImageHeaderParser.calcTagOffset(firstIfdOffset, i);
            short tagType = segmentData.getInt16(tagOffset);
            if (tagType != 274) continue;
            short formatCode = segmentData.getInt16(tagOffset + 2);
            if (formatCode < 1 || formatCode > 12) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Got invalid format code = " + formatCode));
                continue;
            }
            int componentCount = segmentData.getInt32(tagOffset + 4);
            if (componentCount < 0) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)"Negative tiff component count");
                continue;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Got tagIndex=" + i + " tagType=" + tagType + " formatCode=" + formatCode + " componentCount=" + componentCount));
            }
            if ((byteCount = componentCount + BYTES_PER_FORMAT[formatCode]) > 4) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Got byte count > 4, not orientation, continuing, formatCode=" + formatCode));
                continue;
            }
            int tagValueOffset = tagOffset + 8;
            if (tagValueOffset < 0 || tagValueOffset > segmentData.length()) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Illegal tagValueOffset=" + tagValueOffset + " tagType=" + tagType));
                continue;
            }
            if (byteCount < 0 || tagValueOffset + byteCount > segmentData.length()) {
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                Log.d((String)TAG, (String)("Illegal number of bytes for TI tag data tagType=" + tagType));
                continue;
            }
            return segmentData.getInt16(tagValueOffset);
        }
        return -1;
    }

    private static int calcTagOffset(int ifdOffset, int tagIndex) {
        return ifdOffset + 2 + 12 * tagIndex;
    }

    private static boolean handles(int imageMagicNumber) {
        return (imageMagicNumber & 0xFFD8) == 65496 || imageMagicNumber == 19789 || imageMagicNumber == 18761;
    }

    private static final class StreamReader
    implements Reader {
        private final InputStream is;

        StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public int getUInt16() throws IOException {
            return this.is.read() << 8 & 0xFF00 | this.is.read() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.is.read() & 0xFF);
        }

        @Override
        public long skip(long total) throws IOException {
            if (total < 0L) {
                return 0L;
            }
            long toSkip = total;
            while (toSkip > 0L) {
                long skipped = this.is.skip(toSkip);
                if (skipped > 0L) {
                    toSkip -= skipped;
                    continue;
                }
                int testEofByte = this.is.read();
                if (testEofByte == -1) break;
                --toSkip;
            }
            return total - toSkip;
        }

        @Override
        public int read(byte[] buffer, int byteCount) throws IOException {
            int toRead;
            int read;
            for (toRead = byteCount; toRead > 0 && (read = this.is.read(buffer, byteCount - toRead, toRead)) != -1; toRead -= read) {
            }
            return byteCount - toRead;
        }

        @Override
        public int getByte() throws IOException {
            return this.is.read();
        }
    }

    private static final class ByteBufferReader
    implements Reader {
        private final ByteBuffer byteBuffer;

        ByteBufferReader(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public int getUInt16() throws IOException {
            return this.getByte() << 8 & 0xFF00 | this.getByte() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.getByte() & 0xFF);
        }

        @Override
        public long skip(long total) throws IOException {
            int toSkip = (int)Math.min((long)this.byteBuffer.remaining(), total);
            this.byteBuffer.position(this.byteBuffer.position() + toSkip);
            return toSkip;
        }

        @Override
        public int read(byte[] buffer, int byteCount) throws IOException {
            int toRead = Math.min(byteCount, this.byteBuffer.remaining());
            if (toRead == 0) {
                return -1;
            }
            this.byteBuffer.get(buffer, 0, toRead);
            return toRead;
        }

        @Override
        public int getByte() throws IOException {
            if (this.byteBuffer.remaining() < 1) {
                return -1;
            }
            return this.byteBuffer.get();
        }
    }

    private static interface Reader {
        public int getUInt16() throws IOException;

        public short getUInt8() throws IOException;

        public long skip(long var1) throws IOException;

        public int read(byte[] var1, int var2) throws IOException;

        public int getByte() throws IOException;
    }

    private static final class RandomAccessReader {
        private final ByteBuffer data;

        RandomAccessReader(byte[] data, int length) {
            this.data = (ByteBuffer)ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN).limit(length);
        }

        void order(ByteOrder byteOrder) {
            this.data.order(byteOrder);
        }

        int length() {
            return this.data.remaining();
        }

        int getInt32(int offset) {
            return this.isAvailable(offset, 4) ? this.data.getInt(offset) : -1;
        }

        short getInt16(int offset) {
            return this.isAvailable(offset, 2) ? this.data.getShort(offset) : (short)-1;
        }

        private boolean isAvailable(int offset, int byteSize) {
            return this.data.remaining() - offset >= byteSize;
        }
    }
}

