/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.util.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class TransformationUtils {
    private static final String TAG = "TransformationUtils";
    public static final int PAINT_FLAGS = 6;
    private static final Paint DEFAULT_PAINT = new Paint(6);
    private static final int CIRCLE_CROP_PAINT_FLAGS = 7;
    private static final Paint CIRCLE_CROP_SHAPE_PAINT = new Paint(7);
    private static final Paint CIRCLE_CROP_BITMAP_PAINT;
    private static final List<String> MODELS_REQUIRING_BITMAP_LOCK;
    private static final Lock BITMAP_DRAWABLE_LOCK;

    private TransformationUtils() {
    }

    public static Lock getBitmapDrawableLock() {
        return BITMAP_DRAWABLE_LOCK;
    }

    public static Bitmap centerCrop(@NonNull BitmapPool pool, @NonNull Bitmap inBitmap, int width, int height) {
        float scale;
        if (inBitmap.getWidth() == width && inBitmap.getHeight() == height) {
            return inBitmap;
        }
        float dx = 0.0f;
        float dy = 0.0f;
        Matrix m = new Matrix();
        if (inBitmap.getWidth() * height > width * inBitmap.getHeight()) {
            scale = (float)height / (float)inBitmap.getHeight();
            dx = ((float)width - (float)inBitmap.getWidth() * scale) * 0.5f;
        } else {
            scale = (float)width / (float)inBitmap.getWidth();
            dy = ((float)height - (float)inBitmap.getHeight() * scale) * 0.5f;
        }
        m.setScale(scale, scale);
        m.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        Bitmap result = pool.get(width, height, TransformationUtils.getSafeConfig(inBitmap));
        TransformationUtils.setAlpha(inBitmap, result);
        TransformationUtils.applyMatrix(inBitmap, result, m);
        return result;
    }

    public static Bitmap fitCenter(@NonNull BitmapPool pool, @NonNull Bitmap inBitmap, int width, int height) {
        if (inBitmap.getWidth() == width && inBitmap.getHeight() == height) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"requested target size matches input, returning input");
            }
            return inBitmap;
        }
        float widthPercentage = (float)width / (float)inBitmap.getWidth();
        float heightPercentage = (float)height / (float)inBitmap.getHeight();
        float minPercentage = Math.min(widthPercentage, heightPercentage);
        int targetWidth = (int)(minPercentage * (float)inBitmap.getWidth());
        int targetHeight = (int)(minPercentage * (float)inBitmap.getHeight());
        if (inBitmap.getWidth() == targetWidth && inBitmap.getHeight() == targetHeight) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"adjusted target size matches input, returning input");
            }
            return inBitmap;
        }
        Bitmap.Config config = TransformationUtils.getSafeConfig(inBitmap);
        Bitmap toReuse = pool.get(targetWidth, targetHeight, config);
        TransformationUtils.setAlpha(inBitmap, toReuse);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("request: " + width + "x" + height));
            Log.v((String)TAG, (String)("toFit:   " + inBitmap.getWidth() + "x" + inBitmap.getHeight()));
            Log.v((String)TAG, (String)("toReuse: " + toReuse.getWidth() + "x" + toReuse.getHeight()));
            Log.v((String)TAG, (String)("minPct:   " + minPercentage));
        }
        Matrix matrix = new Matrix();
        matrix.setScale(minPercentage, minPercentage);
        TransformationUtils.applyMatrix(inBitmap, toReuse, matrix);
        return toReuse;
    }

    public static Bitmap centerInside(@NonNull BitmapPool pool, @NonNull Bitmap inBitmap, int width, int height) {
        if (inBitmap.getWidth() <= width && inBitmap.getHeight() <= height) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"requested target size larger or equal to input, returning input");
            }
            return inBitmap;
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)"requested target size too big for input, fit centering instead");
        }
        return TransformationUtils.fitCenter(pool, inBitmap, width, height);
    }

    public static void setAlpha(Bitmap inBitmap, Bitmap outBitmap) {
        outBitmap.setHasAlpha(inBitmap.hasAlpha());
    }

    public static Bitmap rotateImage(@NonNull Bitmap imageToOrient, int degreesToRotate) {
        Bitmap result;
        block3: {
            result = imageToOrient;
            try {
                if (degreesToRotate != 0) {
                    Matrix matrix = new Matrix();
                    matrix.setRotate((float)degreesToRotate);
                    result = Bitmap.createBitmap((Bitmap)imageToOrient, (int)0, (int)0, (int)imageToOrient.getWidth(), (int)imageToOrient.getHeight(), (Matrix)matrix, (boolean)true);
                }
            }
            catch (Exception e) {
                if (!Log.isLoggable((String)TAG, (int)6)) break block3;
                Log.e((String)TAG, (String)"Exception when trying to orient image", (Throwable)e);
            }
        }
        return result;
    }

    public static int getExifOrientationDegrees(int exifOrientation) {
        int degreesToRotate;
        switch (exifOrientation) {
            case 5: 
            case 6: {
                degreesToRotate = 90;
                break;
            }
            case 3: 
            case 4: {
                degreesToRotate = 180;
                break;
            }
            case 7: 
            case 8: {
                degreesToRotate = 270;
                break;
            }
            default: {
                degreesToRotate = 0;
            }
        }
        return degreesToRotate;
    }

    public static Bitmap rotateImageExif(@NonNull BitmapPool pool, @NonNull Bitmap inBitmap, int exifOrientation) {
        if (!TransformationUtils.isExifOrientationRequired(exifOrientation)) {
            return inBitmap;
        }
        Matrix matrix = new Matrix();
        TransformationUtils.initializeMatrixForRotation(exifOrientation, matrix);
        RectF newRect = new RectF(0.0f, 0.0f, (float)inBitmap.getWidth(), (float)inBitmap.getHeight());
        matrix.mapRect(newRect);
        int newWidth = Math.round(newRect.width());
        int newHeight = Math.round(newRect.height());
        Bitmap.Config config = TransformationUtils.getSafeConfig(inBitmap);
        Bitmap result = pool.get(newWidth, newHeight, config);
        matrix.postTranslate(-newRect.left, -newRect.top);
        TransformationUtils.applyMatrix(inBitmap, result, matrix);
        return result;
    }

    public static boolean isExifOrientationRequired(int exifOrientation) {
        switch (exifOrientation) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap circleCrop(@NonNull BitmapPool pool, @NonNull Bitmap inBitmap, int destWidth, int destHeight) {
        int destMinEdge = Math.min(destWidth, destHeight);
        float radius = (float)destMinEdge / 2.0f;
        int srcWidth = inBitmap.getWidth();
        int srcHeight = inBitmap.getHeight();
        float scaleX = (float)destMinEdge / (float)srcWidth;
        float scaleY = (float)destMinEdge / (float)srcHeight;
        float maxScale = Math.max(scaleX, scaleY);
        float scaledWidth = maxScale * (float)srcWidth;
        float scaledHeight = maxScale * (float)srcHeight;
        float left = ((float)destMinEdge - scaledWidth) / 2.0f;
        float top = ((float)destMinEdge - scaledHeight) / 2.0f;
        RectF destRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        Bitmap toTransform = TransformationUtils.getAlphaSafeBitmap(pool, inBitmap);
        Bitmap result = pool.get(destMinEdge, destMinEdge, Bitmap.Config.ARGB_8888);
        result.setHasAlpha(true);
        BITMAP_DRAWABLE_LOCK.lock();
        try {
            Canvas canvas = new Canvas(result);
            canvas.drawCircle(radius, radius, radius, CIRCLE_CROP_SHAPE_PAINT);
            canvas.drawBitmap(toTransform, null, destRect, CIRCLE_CROP_BITMAP_PAINT);
            TransformationUtils.clear(canvas);
        }
        finally {
            BITMAP_DRAWABLE_LOCK.unlock();
        }
        if (!toTransform.equals(inBitmap)) {
            pool.put(toTransform);
        }
        return result;
    }

    private static Bitmap getAlphaSafeBitmap(@NonNull BitmapPool pool, @NonNull Bitmap maybeAlphaSafe) {
        if (Bitmap.Config.ARGB_8888.equals((Object)maybeAlphaSafe.getConfig())) {
            return maybeAlphaSafe;
        }
        Bitmap argbBitmap = pool.get(maybeAlphaSafe.getWidth(), maybeAlphaSafe.getHeight(), Bitmap.Config.ARGB_8888);
        new Canvas(argbBitmap).drawBitmap(maybeAlphaSafe, 0.0f, 0.0f, null);
        return argbBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap roundedCorners(@NonNull BitmapPool pool, @NonNull Bitmap inBitmap, int width, int height, int roundingRadius) {
        Preconditions.checkArgument(width > 0, "width must be greater than 0.");
        Preconditions.checkArgument(height > 0, "height must be greater than 0.");
        Preconditions.checkArgument(roundingRadius > 0, "roundingRadius must be greater than 0.");
        Bitmap toTransform = TransformationUtils.getAlphaSafeBitmap(pool, inBitmap);
        Bitmap result = pool.get(width, height, Bitmap.Config.ARGB_8888);
        result.setHasAlpha(true);
        BitmapShader shader = new BitmapShader(toTransform, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)shader);
        RectF rect = new RectF(0.0f, 0.0f, (float)result.getWidth(), (float)result.getHeight());
        BITMAP_DRAWABLE_LOCK.lock();
        try {
            Canvas canvas = new Canvas(result);
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            canvas.drawRoundRect(rect, (float)roundingRadius, (float)roundingRadius, paint);
            TransformationUtils.clear(canvas);
        }
        finally {
            BITMAP_DRAWABLE_LOCK.unlock();
        }
        if (!toTransform.equals(inBitmap)) {
            pool.put(toTransform);
        }
        return result;
    }

    private static void clear(Canvas canvas) {
        canvas.setBitmap(null);
    }

    private static Bitmap.Config getSafeConfig(Bitmap bitmap) {
        return bitmap.getConfig() != null ? bitmap.getConfig() : Bitmap.Config.ARGB_8888;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyMatrix(@NonNull Bitmap inBitmap, @NonNull Bitmap targetBitmap, Matrix matrix) {
        BITMAP_DRAWABLE_LOCK.lock();
        try {
            Canvas canvas = new Canvas(targetBitmap);
            canvas.drawBitmap(inBitmap, matrix, DEFAULT_PAINT);
            TransformationUtils.clear(canvas);
        }
        finally {
            BITMAP_DRAWABLE_LOCK.unlock();
        }
    }

    static void initializeMatrixForRotation(int exifOrientation, Matrix matrix) {
        switch (exifOrientation) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix.setRotate(90.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 8: {
                matrix.setRotate(-90.0f);
                break;
            }
        }
    }

    static {
        MODELS_REQUIRING_BITMAP_LOCK = Arrays.asList("XT1097", "XT1085");
        BITMAP_DRAWABLE_LOCK = MODELS_REQUIRING_BITMAP_LOCK.contains(Build.MODEL) && Build.VERSION.SDK_INT == 22 ? new ReentrantLock() : new NoLock();
        CIRCLE_CROP_BITMAP_PAINT = new Paint(7);
        CIRCLE_CROP_BITMAP_PAINT.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }

    private static final class NoLock
    implements Lock {
        NoLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, @NonNull TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        @NonNull
        public Condition newCondition() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

