/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;

public final class GifBitmapProvider
implements GifDecoder.BitmapProvider {
    private final BitmapPool bitmapPool;
    @Nullable
    private final ArrayPool arrayPool;

    public GifBitmapProvider(BitmapPool bitmapPool) {
        this(bitmapPool, null);
    }

    public GifBitmapProvider(BitmapPool bitmapPool, ArrayPool arrayPool) {
        this.bitmapPool = bitmapPool;
        this.arrayPool = arrayPool;
    }

    @NonNull
    public Bitmap obtain(int width, int height, Bitmap.Config config) {
        return this.bitmapPool.getDirty(width, height, config);
    }

    public void release(Bitmap bitmap) {
        this.bitmapPool.put(bitmap);
    }

    public byte[] obtainByteArray(int size) {
        if (this.arrayPool == null) {
            return new byte[size];
        }
        return this.arrayPool.get(size, byte[].class);
    }

    public void release(byte[] bytes) {
        if (this.arrayPool == null) {
            return;
        }
        this.arrayPool.put(bytes, byte[].class);
    }

    public int[] obtainIntArray(int size) {
        if (this.arrayPool == null) {
            return new int[size];
        }
        return this.arrayPool.get(size, int[].class);
    }

    public void release(int[] array) {
        if (this.arrayPool == null) {
            return;
        }
        this.arrayPool.put(array, int[].class);
    }
}

