/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.provider;

import android.support.annotation.Nullable;
import com.bumptech.glide.load.Encoder;
import java.util.ArrayList;
import java.util.List;

public class EncoderRegistry {
    private final List<Entry<?>> encoders = new ArrayList();

    @Nullable
    public synchronized <T> Encoder<T> getEncoder(Class<T> dataClass) {
        for (Entry<T> entry : this.encoders) {
            if (!entry.handles(dataClass)) continue;
            return entry.encoder;
        }
        return null;
    }

    public synchronized <T> void add(Class<T> dataClass, Encoder<T> encoder) {
        this.encoders.add(new Entry<T>(dataClass, encoder));
    }

    private static final class Entry<T> {
        private final Class<T> dataClass;
        final Encoder<T> encoder;

        public Entry(Class<T> dataClass, Encoder<T> encoder) {
            this.dataClass = dataClass;
            this.encoder = encoder;
        }

        public boolean handles(Class<?> dataClass) {
            return this.dataClass.isAssignableFrom(dataClass);
        }
    }
}

