/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.target.BaseTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class ViewTarget<T extends View, Z>
extends BaseTarget<Z> {
    private static final String TAG = "ViewTarget";
    private static boolean isTagUsedAtLeastOnce = false;
    @Nullable
    private static Integer tagId = null;
    protected final T view;
    private final SizeDeterminer sizeDeterminer;

    public ViewTarget(T view) {
        this.view = (View)Preconditions.checkNotNull(view);
        this.sizeDeterminer = new SizeDeterminer((View)view);
    }

    public T getView() {
        return this.view;
    }

    @Override
    public void getSize(SizeReadyCallback cb) {
        this.sizeDeterminer.getSize(cb);
    }

    @Override
    public void removeCallback(SizeReadyCallback cb) {
        this.sizeDeterminer.removeCallback(cb);
    }

    @Override
    public void onLoadCleared(Drawable placeholder) {
        super.onLoadCleared(placeholder);
        this.sizeDeterminer.clearCallbacksAndListener();
    }

    @Override
    public void setRequest(@Nullable Request request) {
        this.setTag(request);
    }

    @Override
    @Nullable
    public Request getRequest() {
        Object tag = this.getTag();
        Request request = null;
        if (tag != null) {
            if (tag instanceof Request) {
                request = (Request)tag;
            } else {
                throw new IllegalArgumentException("You must not call setTag() on a view Glide is targeting");
            }
        }
        return request;
    }

    public String toString() {
        return "Target for: " + this.view;
    }

    private void setTag(@Nullable Object tag) {
        if (tagId == null) {
            isTagUsedAtLeastOnce = true;
            this.view.setTag(tag);
        } else {
            this.view.setTag(tagId.intValue(), tag);
        }
    }

    @Nullable
    private Object getTag() {
        if (tagId == null) {
            return this.view.getTag();
        }
        return this.view.getTag(tagId.intValue());
    }

    public static void setTagId(int tagId) {
        if (ViewTarget.tagId != null || isTagUsedAtLeastOnce) {
            throw new IllegalArgumentException("You cannot set the tag id more than once or change the tag id after the first request has been made");
        }
        ViewTarget.tagId = tagId;
    }

    private static class SizeDeterminer {
        private static final int PENDING_SIZE = 0;
        private final View view;
        private final List<SizeReadyCallback> cbs = new ArrayList<SizeReadyCallback>();
        @Nullable
        private SizeDeterminerLayoutListener layoutListener;

        SizeDeterminer(View view) {
            this.view = view;
        }

        private void notifyCbs(int width, int height) {
            for (SizeReadyCallback cb : new ArrayList<SizeReadyCallback>(this.cbs)) {
                cb.onSizeReady(width, height);
            }
        }

        void checkCurrentDimens() {
            int currentHeight;
            if (this.cbs.isEmpty()) {
                return;
            }
            int currentWidth = this.getTargetWidth();
            if (!this.isViewStateAndSizeValid(currentWidth, currentHeight = this.getTargetHeight())) {
                return;
            }
            this.notifyCbs(currentWidth, currentHeight);
            this.clearCallbacksAndListener();
        }

        void getSize(SizeReadyCallback cb) {
            int currentHeight;
            int currentWidth = this.getTargetWidth();
            if (this.isViewStateAndSizeValid(currentWidth, currentHeight = this.getTargetHeight())) {
                cb.onSizeReady(currentWidth, currentHeight);
                return;
            }
            if (!this.cbs.contains(cb)) {
                this.cbs.add(cb);
            }
            if (this.layoutListener == null) {
                ViewTreeObserver observer = this.view.getViewTreeObserver();
                this.layoutListener = new SizeDeterminerLayoutListener(this);
                observer.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
            }
        }

        void removeCallback(SizeReadyCallback cb) {
            this.cbs.remove(cb);
        }

        void clearCallbacksAndListener() {
            ViewTreeObserver observer = this.view.getViewTreeObserver();
            if (observer.isAlive()) {
                observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
            }
            this.layoutListener = null;
            this.cbs.clear();
        }

        private boolean isViewStateAndSizeValid(int width, int height) {
            return this.isViewStateValid() && this.isSizeValid(width) && this.isSizeValid(height);
        }

        private boolean isViewStateValid() {
            if (this.view.getLayoutParams() != null && this.view.getLayoutParams().width > 0 && this.view.getLayoutParams().height > 0) {
                return true;
            }
            return !this.view.isLayoutRequested();
        }

        private int getTargetHeight() {
            int verticalPadding = this.view.getPaddingTop() + this.view.getPaddingBottom();
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            int layoutParamSize = layoutParams != null ? layoutParams.height : 0;
            return this.getTargetDimen(this.view.getHeight(), layoutParamSize, verticalPadding);
        }

        private int getTargetWidth() {
            int horizontalPadding = this.view.getPaddingLeft() + this.view.getPaddingRight();
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            int layoutParamSize = layoutParams != null ? layoutParams.width : 0;
            return this.getTargetDimen(this.view.getWidth(), layoutParamSize, horizontalPadding);
        }

        private int getTargetDimen(int viewSize, int paramSize, int paddingSize) {
            int adjustedViewSize = viewSize - paddingSize;
            if (this.isSizeValid(adjustedViewSize)) {
                return adjustedViewSize;
            }
            if (paramSize == 0) {
                return 0;
            }
            if (paramSize == -2) {
                return Integer.MIN_VALUE;
            }
            if (paramSize > 0) {
                return paramSize - paddingSize;
            }
            return 0;
        }

        private boolean isSizeValid(int size) {
            return size > 0 || size == Integer.MIN_VALUE;
        }

        private static class SizeDeterminerLayoutListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final WeakReference<SizeDeterminer> sizeDeterminerRef;

            SizeDeterminerLayoutListener(SizeDeterminer sizeDeterminer) {
                this.sizeDeterminerRef = new WeakReference<SizeDeterminer>(sizeDeterminer);
            }

            public boolean onPreDraw() {
                SizeDeterminer sizeDeterminer;
                if (Log.isLoggable((String)ViewTarget.TAG, (int)2)) {
                    Log.v((String)ViewTarget.TAG, (String)("OnGlobalLayoutListener called listener=" + this));
                }
                if ((sizeDeterminer = (SizeDeterminer)this.sizeDeterminerRef.get()) != null) {
                    sizeDeterminer.checkCurrentDimens();
                }
                return true;
            }
        }
    }
}

