/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.transition;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.request.transition.TransitionFactory;

public abstract class BitmapContainerTransitionFactory<R>
implements TransitionFactory<R> {
    private final TransitionFactory<Drawable> realFactory;

    public BitmapContainerTransitionFactory(TransitionFactory<Drawable> realFactory) {
        this.realFactory = realFactory;
    }

    @Override
    public Transition<R> build(DataSource dataSource, boolean isFirstResource) {
        Transition<Drawable> transition = this.realFactory.build(dataSource, isFirstResource);
        return new BitmapGlideAnimation(transition);
    }

    protected abstract Bitmap getBitmap(R var1);

    private class BitmapGlideAnimation
    implements Transition<R> {
        private final Transition<Drawable> transition;

        public BitmapGlideAnimation(Transition<Drawable> transition) {
            this.transition = transition;
        }

        @Override
        public boolean transition(R current, Transition.ViewAdapter adapter) {
            Resources resources = adapter.getView().getResources();
            BitmapDrawable currentBitmap = new BitmapDrawable(resources, BitmapContainerTransitionFactory.this.getBitmap(current));
            return this.transition.transition((Drawable)currentBitmap, adapter);
        }
    }
}

