/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.support.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<T, Y> {
    private final LinkedHashMap<T, Y> cache = new LinkedHashMap(100, 0.75f, true);
    private final int initialMaxSize;
    private int maxSize;
    private int currentSize = 0;

    public LruCache(int size) {
        this.initialMaxSize = size;
        this.maxSize = size;
    }

    public synchronized void setSizeMultiplier(float multiplier) {
        if (multiplier < 0.0f) {
            throw new IllegalArgumentException("Multiplier must be >= 0");
        }
        this.maxSize = Math.round((float)this.initialMaxSize * multiplier);
        this.evict();
    }

    protected int getSize(Y item) {
        return 1;
    }

    protected synchronized int getCount() {
        return this.cache.size();
    }

    protected void onItemEvicted(T key, Y item) {
    }

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    public synchronized int getCurrentSize() {
        return this.currentSize;
    }

    public synchronized boolean contains(T key) {
        return this.cache.containsKey(key);
    }

    @Nullable
    public synchronized Y get(T key) {
        return this.cache.get(key);
    }

    public synchronized Y put(T key, Y item) {
        int itemSize = this.getSize(item);
        if (itemSize >= this.maxSize) {
            this.onItemEvicted(key, item);
            return null;
        }
        Y result = this.cache.put(key, item);
        if (item != null) {
            this.currentSize += this.getSize(item);
        }
        if (result != null) {
            this.currentSize -= this.getSize(result);
        }
        this.evict();
        return result;
    }

    @Nullable
    public synchronized Y remove(T key) {
        Object value = this.cache.remove(key);
        if (value != null) {
            this.currentSize -= this.getSize(value);
        }
        return (Y)value;
    }

    public void clearMemory() {
        this.trimToSize(0);
    }

    protected synchronized void trimToSize(int size) {
        while (this.currentSize > size) {
            Map.Entry<T, Y> last = this.cache.entrySet().iterator().next();
            Y toRemove = last.getValue();
            this.currentSize -= this.getSize(toRemove);
            T key = last.getKey();
            this.cache.remove(key);
            this.onItemEvicted(key, toRemove);
        }
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }
}

