/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public final class Util {
    private static final int HASH_MULTIPLIER = 31;
    private static final int HASH_ACCUMULATOR = 17;
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] SHA_256_CHARS = new char[64];

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha256BytesToHex(byte[] bytes) {
        char[] cArray = SHA_256_CHARS;
        synchronized (SHA_256_CHARS) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Util.bytesToHex(bytes, SHA_256_CHARS);
        }
    }

    private static String bytesToHex(byte[] bytes, char[] hexChars) {
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHAR_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHAR_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    @Deprecated
    public static int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    @TargetApi(value=19)
    public static int getBitmapByteSize(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new IllegalStateException("Cannot obtain size for recycled Bitmap: " + bitmap + "[" + bitmap.getWidth() + "x" + bitmap.getHeight() + "] " + bitmap.getConfig());
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bitmap.getHeight() * bitmap.getRowBytes();
    }

    public static int getBitmapByteSize(int width, int height, Bitmap.Config config) {
        return width * height * Util.getBytesPerPixel(config);
    }

    private static int getBytesPerPixel(Bitmap.Config config) {
        int bytesPerPixel;
        if (config == null) {
            config = Bitmap.Config.ARGB_8888;
        }
        switch (config) {
            case ALPHA_8: {
                bytesPerPixel = 1;
                break;
            }
            case RGB_565: 
            case ARGB_4444: {
                bytesPerPixel = 2;
                break;
            }
            default: {
                bytesPerPixel = 4;
            }
        }
        return bytesPerPixel;
    }

    public static boolean isValidDimensions(int width, int height) {
        return Util.isValidDimension(width) && Util.isValidDimension(height);
    }

    private static boolean isValidDimension(int dimen) {
        return dimen > 0 || dimen == Integer.MIN_VALUE;
    }

    public static void assertMainThread() {
        if (!Util.isOnMainThread()) {
            throw new IllegalArgumentException("You must call this method on the main thread");
        }
    }

    public static void assertBackgroundThread() {
        if (!Util.isOnBackgroundThread()) {
            throw new IllegalArgumentException("You must call this method on a background thread");
        }
    }

    public static boolean isOnMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isOnBackgroundThread() {
        return !Util.isOnMainThread();
    }

    public static <T> Queue<T> createQueue(int size) {
        return new ArrayDeque(size);
    }

    public static <T> List<T> getSnapshot(Collection<T> other) {
        ArrayList<T> result = new ArrayList<T>(other.size());
        for (T item : other) {
            result.add(item);
        }
        return result;
    }

    public static boolean bothNullOrEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static int hashCode(int value) {
        return Util.hashCode(value, 17);
    }

    public static int hashCode(int value, int accumulator) {
        return accumulator * 31 + value;
    }

    public static int hashCode(float value) {
        return Util.hashCode(value, 17);
    }

    public static int hashCode(float value, int accumulator) {
        return Util.hashCode(Float.floatToIntBits(value), accumulator);
    }

    public static int hashCode(Object object, int accumulator) {
        return Util.hashCode(object == null ? 0 : object.hashCode(), accumulator);
    }

    public static int hashCode(boolean value, int accumulator) {
        return Util.hashCode(value ? 1 : 0, accumulator);
    }

    public static int hashCode(boolean value) {
        return Util.hashCode(value, 17);
    }
}

