/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheWrapper;
import java.io.File;

public class DiskLruCacheFactory
implements DiskCache.Factory {
    private final long diskCacheSize;
    private final CacheDirectoryGetter cacheDirectoryGetter;

    public DiskLruCacheFactory(final String diskCacheFolder, long diskCacheSize) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(diskCacheFolder);
            }
        }, diskCacheSize);
    }

    public DiskLruCacheFactory(final String diskCacheFolder, final String diskCacheName, long diskCacheSize) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(diskCacheFolder, diskCacheName);
            }
        }, diskCacheSize);
    }

    public DiskLruCacheFactory(CacheDirectoryGetter cacheDirectoryGetter, long diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
        this.cacheDirectoryGetter = cacheDirectoryGetter;
    }

    @Override
    public DiskCache build() {
        File cacheDir = this.cacheDirectoryGetter.getCacheDirectory();
        if (cacheDir == null) {
            return null;
        }
        if (cacheDir.isDirectory() || cacheDir.mkdirs()) {
            return DiskLruCacheWrapper.create(cacheDir, this.diskCacheSize);
        }
        return null;
    }

    public static interface CacheDirectoryGetter {
        public File getCacheDirectory();
    }
}

