/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.manager;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.manager.ConnectivityMonitor;
import com.bumptech.glide.util.GlideSuppliers;
import com.bumptech.glide.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

final class SingletonConnectivityReceiver {
    private static volatile SingletonConnectivityReceiver instance;
    private static final String TAG = "ConnectivityMonitor";
    private final FrameworkConnectivityMonitor frameworkConnectivityMonitor;
    @GuardedBy(value="this")
    final Set<ConnectivityMonitor.ConnectivityListener> listeners = new HashSet<ConnectivityMonitor.ConnectivityListener>();
    @GuardedBy(value="this")
    private boolean isRegistered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static SingletonConnectivityReceiver get(@NonNull Context context) {
        if (instance != null) return instance;
        Class<SingletonConnectivityReceiver> clazz = SingletonConnectivityReceiver.class;
        synchronized (SingletonConnectivityReceiver.class) {
            if (instance != null) return instance;
            instance = new SingletonConnectivityReceiver(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    static void reset() {
        instance = null;
    }

    private SingletonConnectivityReceiver(final @NonNull Context context) {
        GlideSuppliers.GlideSupplier<ConnectivityManager> connectivityManager = GlideSuppliers.memorize(new GlideSuppliers.GlideSupplier<ConnectivityManager>(){

            @Override
            public ConnectivityManager get() {
                return (ConnectivityManager)context.getSystemService("connectivity");
            }
        });
        ConnectivityMonitor.ConnectivityListener connectivityListener = new ConnectivityMonitor.ConnectivityListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectivityChanged(boolean isConnected) {
                ArrayList<ConnectivityMonitor.ConnectivityListener> toNotify;
                SingletonConnectivityReceiver singletonConnectivityReceiver = SingletonConnectivityReceiver.this;
                synchronized (singletonConnectivityReceiver) {
                    toNotify = new ArrayList<ConnectivityMonitor.ConnectivityListener>(SingletonConnectivityReceiver.this.listeners);
                }
                for (ConnectivityMonitor.ConnectivityListener listener : toNotify) {
                    listener.onConnectivityChanged(isConnected);
                }
            }
        };
        this.frameworkConnectivityMonitor = Build.VERSION.SDK_INT >= 24 ? new FrameworkConnectivityMonitorPostApi24(connectivityManager, connectivityListener) : new FrameworkConnectivityMonitorPreApi24(context, connectivityManager, connectivityListener);
    }

    synchronized void register(ConnectivityMonitor.ConnectivityListener listener) {
        this.listeners.add(listener);
        this.maybeRegisterReceiver();
    }

    synchronized void unregister(ConnectivityMonitor.ConnectivityListener listener) {
        this.listeners.remove(listener);
        this.maybeUnregisterReceiver();
    }

    @GuardedBy(value="this")
    private void maybeRegisterReceiver() {
        if (this.isRegistered || this.listeners.isEmpty()) {
            return;
        }
        this.isRegistered = this.frameworkConnectivityMonitor.register();
    }

    @GuardedBy(value="this")
    private void maybeUnregisterReceiver() {
        if (!this.isRegistered || !this.listeners.isEmpty()) {
            return;
        }
        this.frameworkConnectivityMonitor.unregister();
        this.isRegistered = false;
    }

    private static final class FrameworkConnectivityMonitorPreApi24
    implements FrameworkConnectivityMonitor {
        private final Context context;
        final ConnectivityMonitor.ConnectivityListener listener;
        private final GlideSuppliers.GlideSupplier<ConnectivityManager> connectivityManager;
        boolean isConnected;
        private final BroadcastReceiver connectivityReceiver = new BroadcastReceiver(){

            public void onReceive(@NonNull Context context, Intent intent) {
                boolean wasConnected = FrameworkConnectivityMonitorPreApi24.this.isConnected;
                FrameworkConnectivityMonitorPreApi24.this.isConnected = FrameworkConnectivityMonitorPreApi24.this.isConnected();
                if (wasConnected != FrameworkConnectivityMonitorPreApi24.this.isConnected) {
                    if (Log.isLoggable((String)SingletonConnectivityReceiver.TAG, (int)3)) {
                        Log.d((String)SingletonConnectivityReceiver.TAG, (String)("connectivity changed, isConnected: " + FrameworkConnectivityMonitorPreApi24.this.isConnected));
                    }
                    FrameworkConnectivityMonitorPreApi24.this.listener.onConnectivityChanged(FrameworkConnectivityMonitorPreApi24.this.isConnected);
                }
            }
        };

        FrameworkConnectivityMonitorPreApi24(Context context, GlideSuppliers.GlideSupplier<ConnectivityManager> connectivityManager, ConnectivityMonitor.ConnectivityListener listener) {
            this.context = context.getApplicationContext();
            this.connectivityManager = connectivityManager;
            this.listener = listener;
        }

        @Override
        public boolean register() {
            this.isConnected = this.isConnected();
            try {
                this.context.registerReceiver(this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                return true;
            }
            catch (SecurityException e) {
                if (Log.isLoggable((String)SingletonConnectivityReceiver.TAG, (int)5)) {
                    Log.w((String)SingletonConnectivityReceiver.TAG, (String)"Failed to register", (Throwable)e);
                }
                return false;
            }
        }

        @Override
        public void unregister() {
            this.context.unregisterReceiver(this.connectivityReceiver);
        }

        @SuppressLint(value={"MissingPermission"})
        boolean isConnected() {
            NetworkInfo networkInfo;
            try {
                networkInfo = this.connectivityManager.get().getActiveNetworkInfo();
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)SingletonConnectivityReceiver.TAG, (int)5)) {
                    Log.w((String)SingletonConnectivityReceiver.TAG, (String)"Failed to determine connectivity status when connectivity changed", (Throwable)e);
                }
                return true;
            }
            return networkInfo != null && networkInfo.isConnected();
        }
    }

    @RequiresApi(value=24)
    private static final class FrameworkConnectivityMonitorPostApi24
    implements FrameworkConnectivityMonitor {
        boolean isConnected;
        final ConnectivityMonitor.ConnectivityListener listener;
        private final GlideSuppliers.GlideSupplier<ConnectivityManager> connectivityManager;
        private final ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(@NonNull Network network) {
                this.postOnConnectivityChange(true);
            }

            public void onLost(@NonNull Network network) {
                this.postOnConnectivityChange(false);
            }

            private void postOnConnectivityChange(final boolean newState) {
                Util.postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        this.onConnectivityChange(newState);
                    }
                });
            }

            void onConnectivityChange(boolean newState) {
                Util.assertMainThread();
                boolean wasConnected = FrameworkConnectivityMonitorPostApi24.this.isConnected;
                FrameworkConnectivityMonitorPostApi24.this.isConnected = newState;
                if (wasConnected != newState) {
                    FrameworkConnectivityMonitorPostApi24.this.listener.onConnectivityChanged(newState);
                }
            }
        };

        FrameworkConnectivityMonitorPostApi24(GlideSuppliers.GlideSupplier<ConnectivityManager> connectivityManager, ConnectivityMonitor.ConnectivityListener listener) {
            this.connectivityManager = connectivityManager;
            this.listener = listener;
        }

        @Override
        @SuppressLint(value={"MissingPermission"})
        public boolean register() {
            this.isConnected = this.connectivityManager.get().getActiveNetwork() != null;
            try {
                this.connectivityManager.get().registerDefaultNetworkCallback(this.networkCallback);
                return true;
            }
            catch (RuntimeException e) {
                if (Log.isLoggable((String)SingletonConnectivityReceiver.TAG, (int)5)) {
                    Log.w((String)SingletonConnectivityReceiver.TAG, (String)"Failed to register callback", (Throwable)e);
                }
                return false;
            }
        }

        @Override
        public void unregister() {
            this.connectivityManager.get().unregisterNetworkCallback(this.networkCallback);
        }
    }

    private static interface FrameworkConnectivityMonitor {
        public boolean register();

        public void unregister();
    }
}

