/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.signature;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.signature.ObjectKey;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ApplicationVersionSignature {
    private static final String TAG = "AppVersionSignature";
    private static final ConcurrentMap<String, Key> PACKAGE_NAME_TO_KEY = new ConcurrentHashMap<String, Key>();

    @NonNull
    public static Key obtain(@NonNull Context context) {
        Key toAdd;
        String packageName = context.getPackageName();
        Key result = (Key)PACKAGE_NAME_TO_KEY.get(packageName);
        if (result == null && (result = PACKAGE_NAME_TO_KEY.putIfAbsent(packageName, toAdd = ApplicationVersionSignature.obtainVersionSignature(context))) == null) {
            result = toAdd;
        }
        return result;
    }

    @VisibleForTesting
    static void reset() {
        PACKAGE_NAME_TO_KEY.clear();
    }

    @NonNull
    private static Key obtainVersionSignature(@NonNull Context context) {
        PackageInfo packageInfo = ApplicationVersionSignature.getPackageInfo(context);
        String versionCode = ApplicationVersionSignature.getVersionCode(packageInfo);
        return new ObjectKey(versionCode);
    }

    @NonNull
    private static String getVersionCode(@Nullable PackageInfo packageInfo) {
        String versionCode = packageInfo != null ? String.valueOf(packageInfo.versionCode) : UUID.randomUUID().toString();
        return versionCode;
    }

    @Nullable
    private static PackageInfo getPackageInfo(@NonNull Context context) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("Cannot resolve info for" + context.getPackageName()), (Throwable)e);
            return null;
        }
    }

    private ApplicationVersionSignature() {
    }
}

