/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.config;

import com.jfinal.aop.Aop;
import com.jfinal.aop.AopManager;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.core.Controller;
import com.jfinal.core.PathScanner;
import com.jfinal.kit.StrKit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public abstract class Routes {
    private static List<Routes> routesList = new ArrayList<Routes>();
    static final boolean DEFAULT_MAPPING_SUPER_CLASS = false;
    Boolean mappingSuperClass = null;
    private String baseViewPath = null;
    private List<Route> routeItemList = new ArrayList<Route>();
    private List<Interceptor> interList = new ArrayList<Interceptor>();
    private boolean clearAfterMapping = false;

    public abstract void config();

    public Routes setMappingSuperClass(boolean mappingSuperClass) {
        this.mappingSuperClass = mappingSuperClass;
        return this;
    }

    public boolean getMappingSuperClass() {
        return this.mappingSuperClass != null ? this.mappingSuperClass : false;
    }

    public Routes scan(String basePackage, Predicate<String> skip) {
        new PathScanner(basePackage, this, skip).scan();
        return this;
    }

    public Routes scan(String basePackage) {
        return this.scan(basePackage, null);
    }

    public Routes add(Routes routes) {
        routes.config();
        if (routes.mappingSuperClass == null) {
            routes.mappingSuperClass = this.mappingSuperClass;
        }
        routesList.add(routes);
        return this;
    }

    public Routes add(String controllerPath, Class<? extends Controller> controllerClass, String viewPath) {
        this.routeItemList.add(new Route(controllerPath, controllerClass, viewPath));
        return this;
    }

    public Routes add(String controllerPath, Class<? extends Controller> controllerClass) {
        return this.add(controllerPath, controllerClass, controllerPath);
    }

    public Routes addInterceptor(Interceptor interceptor) {
        if (AopManager.me().isInjectDependency()) {
            Aop.inject(interceptor);
        }
        this.interList.add(interceptor);
        return this;
    }

    public Routes setBaseViewPath(String baseViewPath) {
        if (StrKit.isBlank(baseViewPath)) {
            throw new IllegalArgumentException("baseViewPath can not be blank");
        }
        if (!(baseViewPath = baseViewPath.trim()).startsWith("/")) {
            baseViewPath = "/" + baseViewPath;
        }
        if (baseViewPath.endsWith("/")) {
            baseViewPath = baseViewPath.substring(0, baseViewPath.length() - 1);
        }
        this.baseViewPath = baseViewPath;
        return this;
    }

    public String getBaseViewPath() {
        return this.baseViewPath;
    }

    public List<Route> getRouteItemList() {
        return this.routeItemList;
    }

    public Interceptor[] getInterceptors() {
        return this.interList.size() > 0 ? this.interList.toArray(new Interceptor[this.interList.size()]) : InterceptorManager.NULL_INTERS;
    }

    public static List<Routes> getRoutesList() {
        return routesList;
    }

    public void setClearAfterMapping(boolean clearAfterMapping) {
        this.clearAfterMapping = clearAfterMapping;
    }

    public void clear() {
        if (this.clearAfterMapping) {
            routesList = null;
            this.baseViewPath = null;
            this.routeItemList = null;
            this.interList = null;
        }
    }

    public static class Route {
        private String controllerPath;
        private Class<? extends Controller> controllerClass;
        private String viewPath;

        public Route(String controllerPath, Class<? extends Controller> controllerClass, String viewPath) {
            if (StrKit.isBlank(controllerPath)) {
                throw new IllegalArgumentException("controllerPath can not be blank");
            }
            if (controllerClass == null) {
                throw new IllegalArgumentException("controllerClass can not be null");
            }
            if (StrKit.isBlank(viewPath)) {
                viewPath = "/";
            }
            this.controllerPath = this.processControllerPath(controllerPath);
            this.controllerClass = controllerClass;
            this.viewPath = this.processViewPath(viewPath);
        }

        private String processControllerPath(String controllerPath) {
            if (!(controllerPath = controllerPath.trim()).startsWith("/")) {
                controllerPath = "/" + controllerPath;
            }
            return controllerPath;
        }

        private String processViewPath(String viewPath) {
            if (!(viewPath = viewPath.trim()).startsWith("/")) {
                viewPath = "/" + viewPath;
            }
            if (!viewPath.endsWith("/")) {
                viewPath = viewPath + "/";
            }
            return viewPath;
        }

        public String getControllerPath() {
            return this.controllerPath;
        }

        public Class<? extends Controller> getControllerClass() {
            return this.controllerClass;
        }

        public String getFinalViewPath(String baseViewPath) {
            return baseViewPath != null ? baseViewPath + this.viewPath : this.viewPath;
        }
    }
}

