/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.captcha.CaptchaRender;
import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.Config;
import com.jfinal.core.ForwardActionRender;
import com.jfinal.core.Injector;
import com.jfinal.core.converter.TypeConverter;
import com.jfinal.kit.HttpKit;
import com.jfinal.kit.Kv;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.render.ContentType;
import com.jfinal.render.JsonRender;
import com.jfinal.render.Render;
import com.jfinal.render.RenderManager;
import com.jfinal.token.TokenManager;
import com.jfinal.upload.MultipartRequest;
import com.jfinal.upload.UploadFile;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class Controller {
    Action action;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String urlPara;
    private String[] urlParaArray;
    private String rawData;
    private Render render;
    private static final RenderManager renderManager = RenderManager.me();
    private static final String[] NULL_URL_PARA_ARRAY = new String[0];
    private static final String URL_PARA_SEPARATOR = Config.getConstants().getUrlParaSeparator();

    void _init_(Action action, HttpServletRequest request, HttpServletResponse response, String urlPara) {
        this.action = action;
        this.request = request;
        this.response = response;
        this.urlPara = urlPara;
        this.urlParaArray = null;
        this.render = null;
    }

    protected void _clear_() {
        this.action = null;
        this.request = null;
        this.response = null;
        this.urlPara = null;
        this.urlParaArray = null;
        this.render = null;
        this.rawData = null;
    }

    public String getRawData() {
        if (this.rawData == null) {
            this.rawData = HttpKit.readData(this.request);
        }
        return this.rawData;
    }

    public String getControllerPath() {
        return this.action.getControllerPath();
    }

    @Deprecated
    public String getControllerKey() {
        return this.action.getControllerPath();
    }

    public String getViewPath() {
        return this.action.getViewPath();
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setHttpServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setUrlPara(String urlPara) {
        this.urlPara = urlPara;
        this.urlParaArray = null;
    }

    public Controller setAttr(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public Controller removeAttr(String name) {
        this.request.removeAttribute(name);
        return this;
    }

    public Controller setAttrs(Map<String, Object> attrMap) {
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            this.request.setAttribute(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String getPara(String name) {
        String result = this.request.getParameter(name);
        return result != null && result.length() != 0 ? result : null;
    }

    public String getPara(String name, String defaultValue) {
        String result = this.request.getParameter(name);
        return result != null && result.length() != 0 ? result : defaultValue;
    }

    public Map<String, String[]> getParaMap() {
        return this.request.getParameterMap();
    }

    public Enumeration<String> getParaNames() {
        return this.request.getParameterNames();
    }

    public String[] getParaValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Integer[] getParaValuesToInt(String name) {
        String[] values = this.request.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        Integer[] result = new Integer[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StrKit.isBlank(values[i]) ? null : Integer.valueOf(Integer.parseInt(values[i]));
        }
        return result;
    }

    public Long[] getParaValuesToLong(String name) {
        String[] values = this.request.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        Long[] result = new Long[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = StrKit.isBlank(values[i]) ? null : Long.valueOf(Long.parseLong(values[i]));
        }
        return result;
    }

    public Enumeration<String> getAttrNames() {
        return this.request.getAttributeNames();
    }

    public <T> T getAttr(String name) {
        return (T)this.request.getAttribute(name);
    }

    public <T> T getAttr(String name, T defaultValue) {
        Object result = this.request.getAttribute(name);
        return (T)(result != null ? result : defaultValue);
    }

    public String getAttrForStr(String name) {
        return (String)this.request.getAttribute(name);
    }

    public Integer getAttrForInt(String name) {
        return (Integer)this.request.getAttribute(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    private Integer toInt(String value, Integer defaultValue) {
        try {
            if (StrKit.isBlank(value)) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return -Integer.parseInt(value.substring(1));
            }
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ActionException(400, renderManager.getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to Integer value.");
        }
    }

    public Integer getParaToInt(String name) {
        return this.toInt(this.request.getParameter(name), null);
    }

    public Integer getParaToInt(String name, Integer defaultValue) {
        return this.toInt(this.request.getParameter(name), defaultValue);
    }

    private Long toLong(String value, Long defaultValue) {
        try {
            if (StrKit.isBlank(value)) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return -Long.parseLong(value.substring(1));
            }
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new ActionException(400, renderManager.getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to Long value.");
        }
    }

    public Long getParaToLong(String name) {
        return this.toLong(this.request.getParameter(name), null);
    }

    public Long getParaToLong(String name, Long defaultValue) {
        return this.toLong(this.request.getParameter(name), defaultValue);
    }

    private Boolean toBoolean(String value, Boolean defaultValue) {
        if (StrKit.isBlank(value)) {
            return defaultValue;
        }
        if ("1".equals(value = value.trim().toLowerCase()) || "true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return Boolean.FALSE;
        }
        throw new ActionException(400, renderManager.getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to Boolean value.");
    }

    public Boolean getParaToBoolean(String name) {
        return this.toBoolean(this.request.getParameter(name), null);
    }

    public Boolean getParaToBoolean(String name, Boolean defaultValue) {
        return this.toBoolean(this.request.getParameter(name), defaultValue);
    }

    public Boolean getParaToBoolean() {
        return this.toBoolean(this.getPara(), null);
    }

    public Boolean getParaToBoolean(int index) {
        return this.toBoolean(this.getPara(index), null);
    }

    public Boolean getParaToBoolean(int index, Boolean defaultValue) {
        return this.toBoolean(this.getPara(index), defaultValue);
    }

    private Date toDate(String value, Date defaultValue) {
        try {
            if (StrKit.isBlank(value)) {
                return defaultValue;
            }
            return (Date)TypeConverter.me().convert(Date.class, value);
        }
        catch (Exception e) {
            throw new ActionException(400, renderManager.getRenderFactory().getErrorRender(400), "Can not parse the parameter \"" + value + "\" to Date value.");
        }
    }

    public Date getParaToDate(String name) {
        return this.toDate(this.request.getParameter(name), null);
    }

    public Date getParaToDate(String name, Date defaultValue) {
        return this.toDate(this.request.getParameter(name), defaultValue);
    }

    public Date getParaToDate() {
        return this.toDate(this.getPara(), null);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public <T> T getSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        return (T)(session != null ? session.getAttribute(key) : null);
    }

    public <T> T getSessionAttr(String key, T defaultValue) {
        T result = this.getSessionAttr(key);
        return result != null ? result : defaultValue;
    }

    public Controller setSessionAttr(String key, Object value) {
        this.request.getSession(true).setAttribute(key, value);
        return this;
    }

    public Controller removeSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(key);
        }
        return this;
    }

    public String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    public Integer getCookieToInt(String name) {
        String result = this.getCookie(name);
        return result != null ? Integer.valueOf(Integer.parseInt(result)) : null;
    }

    public Integer getCookieToInt(String name, Integer defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Integer.parseInt(result) : defaultValue;
    }

    public Long getCookieToLong(String name) {
        String result = this.getCookie(name);
        return result != null ? Long.valueOf(Long.parseLong(result)) : null;
    }

    public Long getCookieToLong(String name, Long defaultValue) {
        String result = this.getCookie(name);
        return result != null ? Long.parseLong(result) : defaultValue;
    }

    public Cookie getCookieObject(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public Cookie[] getCookieObjects() {
        Cookie[] result = this.request.getCookies();
        return result != null ? result : new Cookie[]{};
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, boolean isHttpOnly) {
        return this.doSetCookie(name, value, maxAgeInSeconds, null, null, isHttpOnly);
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds) {
        return this.doSetCookie(name, value, maxAgeInSeconds, null, null, null);
    }

    public Controller setCookie(Cookie cookie) {
        this.response.addCookie(cookie);
        return this;
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path, boolean isHttpOnly) {
        return this.doSetCookie(name, value, maxAgeInSeconds, path, null, isHttpOnly);
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path) {
        return this.doSetCookie(name, value, maxAgeInSeconds, path, null, null);
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, String path, String domain, boolean isHttpOnly) {
        return this.doSetCookie(name, value, maxAgeInSeconds, path, domain, isHttpOnly);
    }

    public Controller removeCookie(String name) {
        return this.doSetCookie(name, null, 0, null, null, null);
    }

    public Controller removeCookie(String name, String path) {
        return this.doSetCookie(name, null, 0, path, null, null);
    }

    public Controller removeCookie(String name, String path, String domain) {
        return this.doSetCookie(name, null, 0, path, domain, null);
    }

    protected Controller doSetCookie(String name, String value, int maxAgeInSeconds, String path, String domain, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAgeInSeconds);
        if (StrKit.isBlank(path)) {
            path = "/";
        }
        cookie.setPath(path);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (isHttpOnly != null) {
            cookie.setHttpOnly(isHttpOnly.booleanValue());
        }
        this.response.addCookie(cookie);
        return this;
    }

    public String getPara() {
        if ("".equals(this.urlPara)) {
            this.urlPara = null;
        }
        return this.urlPara;
    }

    public String getPara(int index) {
        if (index < 0) {
            return this.getPara();
        }
        if (this.urlParaArray == null) {
            this.urlParaArray = this.urlPara == null || "".equals(this.urlPara) ? NULL_URL_PARA_ARRAY : this.urlPara.split(URL_PARA_SEPARATOR);
            for (int i = 0; i < this.urlParaArray.length; ++i) {
                if (!"".equals(this.urlParaArray[i])) continue;
                this.urlParaArray[i] = null;
            }
        }
        return this.urlParaArray.length > index ? this.urlParaArray[index] : null;
    }

    public String getPara(int index, String defaultValue) {
        String result = this.getPara(index);
        return result != null && result.length() != 0 ? result : defaultValue;
    }

    public Integer getParaToInt(int index) {
        return this.toInt(this.getPara(index), null);
    }

    public Integer getParaToInt(int index, Integer defaultValue) {
        return this.toInt(this.getPara(index), defaultValue);
    }

    public Long getParaToLong(int index) {
        return this.toLong(this.getPara(index), null);
    }

    public Long getParaToLong(int index, Long defaultValue) {
        return this.toLong(this.getPara(index), defaultValue);
    }

    public Integer getParaToInt() {
        return this.toInt(this.getPara(), null);
    }

    public Long getParaToLong() {
        return this.toLong(this.getPara(), null);
    }

    public <T> T getModel(Class<T> modelClass) {
        return Injector.injectModel(modelClass, this.request, false);
    }

    public <T> T getModel(Class<T> modelClass, boolean skipConvertError) {
        return Injector.injectModel(modelClass, this.request, skipConvertError);
    }

    public <T> T getModel(Class<T> modelClass, String modelName) {
        return Injector.injectModel(modelClass, modelName, this.request, false);
    }

    public <T> T getModel(Class<T> modelClass, String modelName, boolean skipConvertError) {
        return Injector.injectModel(modelClass, modelName, this.request, skipConvertError);
    }

    public <T> T getBean(Class<T> beanClass) {
        return Injector.injectBean(beanClass, this.request, false);
    }

    public <T> T getBean(Class<T> beanClass, boolean skipConvertError) {
        return Injector.injectBean(beanClass, this.request, skipConvertError);
    }

    public <T> T getBean(Class<T> beanClass, String beanName) {
        return Injector.injectBean(beanClass, beanName, this.request, false);
    }

    public <T> T getBean(Class<T> beanClass, String beanName, boolean skipConvertError) {
        return Injector.injectBean(beanClass, beanName, this.request, skipConvertError);
    }

    public Kv getKv() {
        Kv kv = new Kv();
        Map paraMap = this.request.getParameterMap();
        for (Map.Entry entry : paraMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            String value = values != null && values.length > 0 ? values[0] : null;
            kv.put(entry.getKey(), "".equals(value) ? null : value);
        }
        return kv;
    }

    public List<UploadFile> getFiles(String uploadPath, long maxPostSize, String encoding) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, uploadPath, maxPostSize, encoding);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String uploadPath, long maxPostSize, String encoding) {
        this.getFiles(uploadPath, maxPostSize, encoding);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles(String uploadPath, long maxPostSize) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, uploadPath, maxPostSize);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String uploadPath, long maxPostSize) {
        this.getFiles(uploadPath, maxPostSize);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles(String uploadPath) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request, uploadPath);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile(String parameterName, String uploadPath) {
        this.getFiles(uploadPath);
        return this.getFile(parameterName);
    }

    public List<UploadFile> getFiles() {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultipartRequest(this.request);
        }
        return ((MultipartRequest)this.request).getFiles();
    }

    public UploadFile getFile() {
        List<UploadFile> uploadFiles = this.getFiles();
        return uploadFiles.size() > 0 ? uploadFiles.get(0) : null;
    }

    public UploadFile getFile(String parameterName) {
        List<UploadFile> uploadFiles = this.getFiles();
        for (UploadFile uploadFile : uploadFiles) {
            if (!uploadFile.getParameterName().equals(parameterName)) continue;
            return uploadFile;
        }
        return null;
    }

    public Controller keepPara() {
        Map map = this.request.getParameterMap();
        for (Map.Entry e : map.entrySet()) {
            String[] values = (String[])e.getValue();
            if (values.length == 1) {
                this.request.setAttribute((String)e.getKey(), (Object)values[0]);
                continue;
            }
            this.request.setAttribute((String)e.getKey(), (Object)values);
        }
        return this;
    }

    public Controller keepPara(String ... names) {
        for (String name : names) {
            String[] values = this.request.getParameterValues(name);
            if (values == null) continue;
            if (values.length == 1) {
                this.request.setAttribute(name, (Object)values[0]);
                continue;
            }
            this.request.setAttribute(name, (Object)values);
        }
        return this;
    }

    public Controller keepPara(Class type, String name) {
        String[] values = this.request.getParameterValues(name);
        if (values != null) {
            if (values.length == 1) {
                try {
                    this.request.setAttribute(name, TypeConverter.me().convert(type, values[0]));
                }
                catch (ParseException e) {
                    LogKit.logNothing(e);
                }
            } else {
                this.request.setAttribute(name, (Object)values);
            }
        }
        return this;
    }

    public Controller keepPara(Class type, String ... names) {
        if (type == String.class) {
            return this.keepPara(names);
        }
        if (names != null) {
            for (String name : names) {
                this.keepPara(type, name);
            }
        }
        return this;
    }

    public Controller keepModel(Class<? extends Model> modelClass, String modelName) {
        if (StrKit.notBlank(modelName)) {
            Model model = Injector.injectModel(modelClass, modelName, this.request, true);
            this.request.setAttribute(modelName, (Object)model);
        } else {
            this.keepPara();
        }
        return this;
    }

    public Controller keepModel(Class<? extends Model> modelClass) {
        String modelName = StrKit.firstCharToLowerCase(modelClass.getSimpleName());
        this.keepModel(modelClass, modelName);
        return this;
    }

    public Controller keepBean(Class<?> beanClass, String beanName) {
        if (StrKit.notBlank(beanName)) {
            Object bean = Injector.injectBean(beanClass, beanName, this.request, true);
            this.request.setAttribute(beanName, bean);
        } else {
            this.keepPara();
        }
        return this;
    }

    public Controller keepBean(Class<?> beanClass) {
        String beanName = StrKit.firstCharToLowerCase(beanClass.getSimpleName());
        this.keepBean(beanClass, beanName);
        return this;
    }

    public String createToken(String tokenName, int secondsOfTimeOut) {
        return TokenManager.createToken(this, tokenName, secondsOfTimeOut);
    }

    public String createToken() {
        return this.createToken("_jfinal_token", 900);
    }

    public String createToken(String tokenName) {
        return this.createToken(tokenName, 900);
    }

    public boolean validateToken(String tokenName) {
        return TokenManager.validateToken(this, tokenName);
    }

    public boolean validateToken() {
        return this.validateToken("_jfinal_token");
    }

    public boolean isParaBlank(String paraName) {
        return StrKit.isBlank(this.request.getParameter(paraName));
    }

    public boolean isParaBlank(int index) {
        return StrKit.isBlank(this.getPara(index));
    }

    public boolean isParaExists(String paraName) {
        return this.request.getParameterMap().containsKey(paraName);
    }

    public boolean isParaExists(int index) {
        return this.getPara(index) != null;
    }

    public Render getRender() {
        return this.render;
    }

    public void render(Render render) {
        this.render = render;
    }

    public void render(String view) {
        this.render = renderManager.getRenderFactory().getRender(view);
    }

    public String renderToString(String template, Map data) {
        if (template.charAt(0) != '/') {
            template = this.action.getViewPath() + template;
        }
        return renderManager.getEngine().getTemplate(template).renderToString(data);
    }

    public void renderTemplate(String template) {
        this.render = renderManager.getRenderFactory().getTemplateRender(template);
    }

    public void renderJsp(String view) {
        this.render = renderManager.getRenderFactory().getJspRender(view);
    }

    public void renderFreeMarker(String view) {
        this.render = renderManager.getRenderFactory().getFreeMarkerRender(view);
    }

    public void renderVelocity(String view) {
        this.render = renderManager.getRenderFactory().getVelocityRender(view);
    }

    public void renderJson(String key, Object value) {
        this.render = renderManager.getRenderFactory().getJsonRender(key, value);
    }

    public void renderJson() {
        this.render = renderManager.getRenderFactory().getJsonRender();
    }

    public void renderJson(String[] attrs) {
        this.render = renderManager.getRenderFactory().getJsonRender(attrs);
    }

    public void renderJson(String jsonText) {
        this.render = renderManager.getRenderFactory().getJsonRender(jsonText);
    }

    public void renderJson(Object object) {
        this.render = object instanceof JsonRender ? (JsonRender)object : renderManager.getRenderFactory().getJsonRender(object);
    }

    public void renderText(String text) {
        this.render = renderManager.getRenderFactory().getTextRender(text);
    }

    public void renderText(String text, String contentType) {
        this.render = renderManager.getRenderFactory().getTextRender(text, contentType);
    }

    public void renderText(String text, ContentType contentType) {
        this.render = renderManager.getRenderFactory().getTextRender(text, contentType);
    }

    public void forwardAction(String actionUrl) {
        this.render = new ForwardActionRender(actionUrl);
    }

    public void renderFile(String fileName) {
        this.render = renderManager.getRenderFactory().getFileRender(fileName);
    }

    public void renderFile(String fileName, String downloadFileName) {
        this.render = renderManager.getRenderFactory().getFileRender(fileName, downloadFileName);
    }

    public void renderFile(File file) {
        this.render = renderManager.getRenderFactory().getFileRender(file);
    }

    public void renderFile(File file, String downloadFileName) {
        this.render = renderManager.getRenderFactory().getFileRender(file, downloadFileName);
    }

    public void redirect(String url) {
        this.render = renderManager.getRenderFactory().getRedirectRender(url);
    }

    public void redirect(String url, boolean withQueryString) {
        this.render = renderManager.getRenderFactory().getRedirectRender(url, withQueryString);
    }

    public void render(String view, int status) {
        this.render = renderManager.getRenderFactory().getRender(view);
        this.response.setStatus(status);
    }

    public void redirect301(String url) {
        this.render = renderManager.getRenderFactory().getRedirect301Render(url);
    }

    public void redirect301(String url, boolean withQueryString) {
        this.render = renderManager.getRenderFactory().getRedirect301Render(url, withQueryString);
    }

    public void renderError(int errorCode, String view) {
        throw new ActionException(errorCode, renderManager.getRenderFactory().getErrorRender(errorCode, view));
    }

    public void renderError(int errorCode, Render render) {
        throw new ActionException(errorCode, render);
    }

    public void renderError(int errorCode) {
        throw new ActionException(errorCode, renderManager.getRenderFactory().getErrorRender(errorCode));
    }

    public void renderNull() {
        this.render = renderManager.getRenderFactory().getNullRender();
    }

    public void renderJavascript(String javascriptText) {
        this.render = renderManager.getRenderFactory().getJavascriptRender(javascriptText);
    }

    public void renderHtml(String htmlText) {
        this.render = renderManager.getRenderFactory().getHtmlRender(htmlText);
    }

    public void renderXml(String view) {
        this.render = renderManager.getRenderFactory().getXmlRender(view);
    }

    public void renderCaptcha() {
        this.render = renderManager.getRenderFactory().getCaptchaRender();
    }

    public void renderQrCode(String content, int width, int height) {
        this.render = renderManager.getRenderFactory().getQrCodeRender(content, width, height);
    }

    public void renderQrCode(String content, int width, int height, char errorCorrectionLevel) {
        this.render = renderManager.getRenderFactory().getQrCodeRender(content, width, height, errorCorrectionLevel);
    }

    public boolean validateCaptcha(String paraName) {
        return CaptchaRender.validate(this, this.getPara(paraName));
    }

    public void checkUrlPara(int minLength, int maxLength) {
        this.getPara(0);
        if (this.urlParaArray.length < minLength || this.urlParaArray.length > maxLength) {
            this.renderError(404);
        }
    }

    public void checkUrlPara(int length) {
        this.checkUrlPara(length, length);
    }

    public Controller set(String attributeName, Object attributeValue) {
        this.request.setAttribute(attributeName, attributeValue);
        return this;
    }

    public String get(String name) {
        return this.getPara(name);
    }

    public String get(String name, String defaultValue) {
        return this.getPara(name, defaultValue);
    }

    public Integer getInt(String name) {
        return this.getParaToInt(name);
    }

    public Integer getInt(String name, Integer defaultValue) {
        return this.getParaToInt(name, defaultValue);
    }

    public Long getLong(String name) {
        return this.getParaToLong(name);
    }

    public Long getLong(String name, Long defaultValue) {
        return this.getParaToLong(name, defaultValue);
    }

    public Boolean getBoolean(String name) {
        return this.getParaToBoolean(name);
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.getParaToBoolean(name, defaultValue);
    }

    public Date getDate(String name) {
        return this.getParaToDate(name);
    }

    public Date getDate(String name, Date defaultValue) {
        return this.getParaToDate(name, defaultValue);
    }

    public String get(int index) {
        return this.getPara(index);
    }

    public String get(int index, String defaultValue) {
        return this.getPara(index, defaultValue);
    }

    public Integer getInt() {
        return this.getParaToInt();
    }

    public Integer getInt(int index) {
        return this.getParaToInt(index);
    }

    public Integer getInt(int index, Integer defaultValue) {
        return this.getParaToInt(index, defaultValue);
    }

    public Long getLong() {
        return this.getParaToLong();
    }

    public Long getLong(int index) {
        return this.getParaToLong(index);
    }

    public Long getLong(int index, Long defaultValue) {
        return this.getParaToLong(index, defaultValue);
    }

    public Boolean getBoolean() {
        return this.getParaToBoolean();
    }

    public Boolean getBoolean(int index) {
        return this.getParaToBoolean(index);
    }

    public Boolean getBoolean(int index, Boolean defaultValue) {
        return this.getParaToBoolean(index, defaultValue);
    }
}

