/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jfinal.json.Json;
import com.jfinal.kit.TimeKit;
import java.text.DateFormat;

public class Jackson
extends Json {
    private static boolean defaultGenerateNullValue = true;
    protected Boolean generateNullValue = null;
    protected ObjectMapper objectMapper = new ObjectMapper();

    public Jackson() {
        this.config();
    }

    protected void config() {
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public static void setDefaultGenerateNullValue(boolean defaultGenerateNullValue) {
        Jackson.defaultGenerateNullValue = defaultGenerateNullValue;
    }

    public Jackson setGenerateNullValue(boolean generateNullValue) {
        this.generateNullValue = generateNullValue;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static Jackson getJson() {
        return new Jackson();
    }

    @Override
    public String toJson(Object object) {
        try {
            Boolean pnv;
            String dp;
            String string = dp = this.datePattern != null ? this.datePattern : this.getDefaultDatePattern();
            if (dp != null) {
                this.objectMapper.setDateFormat((DateFormat)TimeKit.getSimpleDateFormat(dp));
            }
            if (!(pnv = Boolean.valueOf(this.generateNullValue != null ? this.generateNullValue : defaultGenerateNullValue)).booleanValue()) {
                this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @Override
    public <T> T parse(String jsonString, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(jsonString, type);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }
}

