/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.kit.StrKit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;

public class HttpKit {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static String CHARSET = "UTF-8";
    private static int connectTimeout = 19000;
    private static int readTimeout = 19000;
    private static final SSLSocketFactory sslSocketFactory = HttpKit.initSSLSocketFactory();
    private static final TrustAnyHostnameVerifier trustAnyHostnameVerifier = new TrustAnyHostnameVerifier();

    private HttpKit() {
    }

    private static SSLSocketFactory initSSLSocketFactory() {
        try {
            TrustManager[] tm = new TrustManager[]{new TrustAnyTrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tm, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setCharSet(String charSet) {
        if (StrKit.isBlank(charSet)) {
            throw new IllegalArgumentException("charSet can not be blank.");
        }
        CHARSET = charSet;
    }

    public static void setConnectTimeout(int connectTimeout) {
        HttpKit.connectTimeout = connectTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        HttpKit.readTimeout = readTimeout;
    }

    private static HttpURLConnection getHttpConnection(String url, String method, Map<String, String> headers) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        URL _url = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)_url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)conn).setHostnameVerifier(trustAnyHostnameVerifier);
        }
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static String get(String url, Map<String, String> queryParas, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            conn = HttpKit.getHttpConnection(HttpKit.buildUrlWithQueryString(url, queryParas), GET, headers);
            conn.connect();
            String string = HttpKit.readResponseString(conn);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static String get(String url, Map<String, String> queryParas) {
        return HttpKit.get(url, queryParas, null);
    }

    public static String get(String url) {
        return HttpKit.get(url, null, null);
    }

    public static String post(String url, Map<String, String> queryParas, String data, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            Object out;
            conn = HttpKit.getHttpConnection(HttpKit.buildUrlWithQueryString(url, queryParas), POST, headers);
            conn.connect();
            if (data != null) {
                out = conn.getOutputStream();
                ((OutputStream)out).write(data.getBytes(CHARSET));
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            out = HttpKit.readResponseString(conn);
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static String post(String url, Map<String, String> queryParas, String data) {
        return HttpKit.post(url, queryParas, data, null);
    }

    public static String post(String url, String data, Map<String, String> headers) {
        return HttpKit.post(url, null, data, headers);
    }

    public static String post(String url, String data) {
        return HttpKit.post(url, null, data, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readResponseString(HttpURLConnection conn) {
        try (InputStreamReader isr = new InputStreamReader(conn.getInputStream(), CHARSET);){
            int num;
            StringBuilder ret = new StringBuilder();
            char[] buf = new char[1024];
            while ((num = isr.read(buf, 0, buf.length)) != -1) {
                ret.append(buf, 0, num);
            }
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildUrlWithQueryString(String url, Map<String, String> queryParas) {
        boolean isFirst;
        if (queryParas == null || queryParas.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf(63) == -1) {
            isFirst = true;
            sb.append('?');
        } else {
            isFirst = false;
        }
        for (Map.Entry<String, String> entry : queryParas.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('&');
            }
            String key = entry.getKey();
            String value = entry.getValue();
            if (StrKit.notBlank(value)) {
                try {
                    value = URLEncoder.encode(value, CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            sb.append(key).append('=').append(value);
        }
        return sb.toString();
    }

    public static String readData(HttpServletRequest request) {
        try {
            int num;
            String ce = request.getCharacterEncoding();
            InputStreamReader isr = new InputStreamReader((InputStream)request.getInputStream(), ce != null ? ce : CHARSET);
            StringBuilder ret = new StringBuilder();
            char[] buf = new char[1024];
            while ((num = isr.read(buf, 0, buf.length)) != -1) {
                ret.append(buf, 0, num);
            }
            return ret.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String readIncommingRequestData(HttpServletRequest request) {
        return HttpKit.readData(request);
    }

    public static boolean isHttps(HttpServletRequest request) {
        return "https".equalsIgnoreCase(request.getHeader("X-Forwarded-Proto")) || "https".equalsIgnoreCase(request.getScheme());
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

