/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.json.Json;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import java.util.Map;

public class Ret
extends HashMap {
    private static final long serialVersionUID = -3021472182023759198L;
    static String STATE = "state";
    static Object STATE_OK = "ok";
    static Object STATE_FAIL = "fail";
    static String MSG = "msg";

    public static Ret by(Object key, Object value) {
        return new Ret().set(key, value);
    }

    public static Ret create(Object key, Object value) {
        return new Ret().set(key, value);
    }

    public static Ret create() {
        return new Ret();
    }

    public static Ret ok() {
        return new Ret().setOk();
    }

    public static Ret ok(Object key, Object value) {
        return Ret.ok().set(key, value);
    }

    public static Ret ok(String msg) {
        return Ret.ok().set(MSG, msg);
    }

    public static Ret fail() {
        return new Ret().setFail();
    }

    public static Ret fail(Object key, Object value) {
        return Ret.fail().set(key, value);
    }

    public static Ret fail(String msg) {
        return Ret.fail().set(MSG, msg);
    }

    public Ret setOk() {
        super.put(STATE, STATE_OK);
        return this;
    }

    public Ret setFail() {
        super.put(STATE, STATE_FAIL);
        return this;
    }

    public boolean isOk() {
        Object state = this.get(STATE);
        if (STATE_OK.equals(state)) {
            return true;
        }
        if (STATE_FAIL.equals(state)) {
            return false;
        }
        throw new IllegalStateException("\u8c03\u7528 isOk() \u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u8c03\u7528 ok()\u3001fail() \u6216\u8005 setOk()\u3001setFail() \u65b9\u6cd5");
    }

    public boolean isFail() {
        Object state = this.get(STATE);
        if (STATE_FAIL.equals(state)) {
            return true;
        }
        if (STATE_OK.equals(state)) {
            return false;
        }
        throw new IllegalStateException("\u8c03\u7528 isFail() \u4e4b\u524d\uff0c\u5fc5\u987b\u5148\u8c03\u7528 ok()\u3001fail() \u6216\u8005 setOk()\u3001setFail() \u65b9\u6cd5");
    }

    public Ret set(Object key, Object value) {
        super.put(key, value);
        return this;
    }

    public Ret setIfNotBlank(Object key, String value) {
        if (StrKit.notBlank(value)) {
            this.set(key, value);
        }
        return this;
    }

    public Ret setIfNotNull(Object key, Object value) {
        if (value != null) {
            this.set(key, value);
        }
        return this;
    }

    public Ret set(Map map) {
        super.putAll(map);
        return this;
    }

    public Ret set(Ret ret) {
        super.putAll(ret);
        return this;
    }

    public Ret delete(Object key) {
        super.remove(key);
        return this;
    }

    public <T> T getAs(Object key) {
        return (T)this.get(key);
    }

    public String getStr(Object key) {
        Object s = this.get(key);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Integer.valueOf(n.intValue()) : null;
    }

    public Long getLong(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Long.valueOf(n.longValue()) : null;
    }

    public Double getDouble(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Double.valueOf(n.doubleValue()) : null;
    }

    public Float getFloat(Object key) {
        Number n = (Number)this.get(key);
        return n != null ? Float.valueOf(n.floatValue()) : null;
    }

    public Number getNumber(Object key) {
        return (Number)this.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.get(key);
    }

    public boolean notNull(Object key) {
        return this.get(key) != null;
    }

    public boolean isNull(Object key) {
        return this.get(key) == null;
    }

    public boolean isTrue(Object key) {
        Object value = this.get(key);
        return value instanceof Boolean && (Boolean)value == true;
    }

    public boolean isFalse(Object key) {
        Object value = this.get(key);
        return value instanceof Boolean && (Boolean)value == false;
    }

    public String toJson() {
        return Json.getJson().toJson(this);
    }

    @Override
    public boolean equals(Object ret) {
        return ret instanceof Ret && super.equals(ret);
    }
}

