/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.log.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledKit {
    private static ScheduledExecutorService executor = null;

    private ScheduledKit() {
    }

    public static synchronized void init(int corePoolSize) {
        if (executor == null) {
            executor = Executors.newScheduledThreadPool(corePoolSize);
        } else {
            Log.getLog(ScheduledKit.class).warn(ScheduledKit.class.getName() + " \u5df2\u7ecf\u521d\u59cb\u5316");
        }
    }

    public static synchronized void init(ScheduledExecutorService executor) {
        if (ScheduledKit.executor == null) {
            ScheduledKit.executor = executor;
        } else {
            Log.getLog(ScheduledKit.class).warn(ScheduledKit.class.getName() + " \u5df2\u7ecf\u521d\u59cb\u5316");
        }
    }

    public static ScheduledExecutorService getExecutor() {
        if (executor == null) {
            ScheduledKit.init(5);
        }
        return executor;
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return ScheduledKit.getExecutor().scheduleWithFixedDelay(task, initialDelay, delay, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return ScheduledKit.getExecutor().scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    public static ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return ScheduledKit.getExecutor().schedule(task, delay, unit);
    }

    public static <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return ScheduledKit.getExecutor().schedule(task, delay, unit);
    }

    public static void shutdown() {
        if (executor != null) {
            executor.shutdown();
        }
    }

    public static void shutdownNow() {
        if (executor != null) {
            executor.shutdownNow();
        }
    }
}

