/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.log.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadPoolKit {
    private static ExecutorService executor = null;

    private ThreadPoolKit() {
    }

    public static synchronized void init(int nThreads) {
        if (executor == null) {
            executor = Executors.newFixedThreadPool(nThreads);
        } else {
            Log.getLog(ThreadPoolKit.class).warn(ThreadPoolKit.class.getName() + " \u5df2\u7ecf\u521d\u59cb\u5316");
        }
    }

    public static synchronized void init(ExecutorService executor) {
        if (ThreadPoolKit.executor == null) {
            ThreadPoolKit.executor = executor;
        } else {
            Log.getLog(ThreadPoolKit.class).warn(ThreadPoolKit.class.getName() + " \u5df2\u7ecf\u521d\u59cb\u5316");
        }
    }

    public static ExecutorService getExecutor() {
        if (executor == null) {
            ThreadPoolKit.init(3);
        }
        return executor;
    }

    public static void execute(Runnable task) {
        ThreadPoolKit.getExecutor().execute(task);
    }

    public static Future<?> submit(Runnable task) {
        return ThreadPoolKit.getExecutor().submit(task);
    }

    public static <T> Future<T> submit(Runnable task, T result) {
        return ThreadPoolKit.getExecutor().submit(task, result);
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return ThreadPoolKit.getExecutor().submit(task);
    }

    public static void shutdown() {
        if (executor != null) {
            executor.shutdown();
        }
    }

    public static void shutdownNow() {
        if (executor != null) {
            executor.shutdownNow();
        }
    }
}

