/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.log;

import com.jfinal.log.ILogFactory;
import com.jfinal.log.JdkLogFactory;
import com.jfinal.log.LogInfo;

public abstract class Log {
    private static ILogFactory defaultLogFactory = null;

    static void init() {
        if (defaultLogFactory == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                Class<?> log4jLogFactoryClass = Class.forName("com.jfinal.log.Log4jLogFactory");
                defaultLogFactory = (ILogFactory)log4jLogFactoryClass.newInstance();
            }
            catch (Exception e) {
                defaultLogFactory = new JdkLogFactory();
            }
        }
    }

    static void setDefaultLogFactory(ILogFactory defaultLogFactory) {
        if (defaultLogFactory == null) {
            throw new IllegalArgumentException("defaultLogFactory can not be null.");
        }
        Log.defaultLogFactory = defaultLogFactory;
    }

    public static Log getLog(Class<?> clazz) {
        return defaultLogFactory.getLog(clazz);
    }

    public static Log getLog(String name) {
        return defaultLogFactory.getLog(name);
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract void fatal(String var1);

    public abstract void fatal(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(String message) {
        this.debug(message);
    }

    public void trace(String message, Throwable t) {
        this.debug(message, t);
    }

    protected boolean endsWithThrowable(Object ... args) {
        return args != null && args.length != 0 && args[args.length - 1] instanceof Throwable;
    }

    protected LogInfo parse(String format, Object ... args) {
        LogInfo li = new LogInfo();
        li.throwable = (Throwable)args[args.length - 1];
        if (args.length > 1) {
            Object[] temp = new Object[args.length - 1];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = args[i];
            }
            li.message = String.format(format, temp);
        } else {
            li.message = format;
        }
        return li;
    }

    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.trace(li.message, li.throwable);
            } else {
                this.trace(String.format(format, args));
            }
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.debug(li.message, li.throwable);
            } else {
                this.debug(String.format(format, args));
            }
        }
    }

    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.info(li.message, li.throwable);
            } else {
                this.info(String.format(format, args));
            }
        }
    }

    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.warn(li.message, li.throwable);
            } else {
                this.warn(String.format(format, args));
            }
        }
    }

    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.error(li.message, li.throwable);
            } else {
                this.error(String.format(format, args));
            }
        }
    }

    public void fatal(String format, Object ... args) {
        if (this.isFatalEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.fatal(li.message, li.throwable);
            } else {
                this.fatal(String.format(format, args));
            }
        }
    }

    static {
        Log.init();
    }
}

