/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.log;

import com.jfinal.log.Log;
import com.jfinal.log.LogInfo;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
extends Log {
    private Logger log;
    private static final String callerFQCN = Log4jLog.class.getName();

    Log4jLog(Class<?> clazz) {
        this.log = Logger.getLogger(clazz);
    }

    Log4jLog(String name) {
        this.log = Logger.getLogger((String)name);
    }

    public static Log4jLog getLog(Class<?> clazz) {
        return new Log4jLog(clazz);
    }

    public static Log4jLog getLog(String name) {
        return new Log4jLog(name);
    }

    @Override
    public void trace(String message) {
        this.log.log(callerFQCN, (Priority)Level.TRACE, (Object)message, null);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.TRACE, (Object)message, t);
    }

    @Override
    public void debug(String message) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)message, null);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.DEBUG, (Object)message, t);
    }

    @Override
    public void info(String message) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.INFO, (Object)message, t);
    }

    @Override
    public void warn(String message) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)message, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.WARN, (Object)message, t);
    }

    @Override
    public void error(String message) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.ERROR, (Object)message, t);
    }

    @Override
    public void fatal(String message) {
        this.log.log(callerFQCN, (Priority)Level.FATAL, (Object)message, null);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log.log(callerFQCN, (Priority)Level.FATAL, (Object)message, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.trace(li.message, li.throwable);
            } else {
                this.trace(String.format(format, args));
            }
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.debug(li.message, li.throwable);
            } else {
                this.debug(String.format(format, args));
            }
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.info(li.message, li.throwable);
            } else {
                this.info(String.format(format, args));
            }
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.warn(li.message, li.throwable);
            } else {
                this.warn(String.format(format, args));
            }
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.error(li.message, li.throwable);
            } else {
                this.error(String.format(format, args));
            }
        }
    }

    @Override
    public void fatal(String format, Object ... args) {
        if (this.isFatalEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.fatal(li.message, li.throwable);
            } else {
                this.fatal(String.format(format, args));
            }
        }
    }
}

